/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.support.annotation.NonNull;
import com.mopub.common.BaseUrlGenerator;
import com.mopub.common.ClientMetadata;

class PositioningUrlGenerator
extends BaseUrlGenerator {
    private static final String POSITIONING_API_VERSION = "1";
    @NonNull
    private final Context mContext;
    @NonNull
    private String mAdUnitId;

    public PositioningUrlGenerator(@NonNull Context context) {
        this.mContext = context;
    }

    @NonNull
    public PositioningUrlGenerator withAdUnitId(@NonNull String adUnitId) {
        this.mAdUnitId = adUnitId;
        return this;
    }

    public String generateUrlString(@NonNull String serverHostname) {
        this.initUrlString(serverHostname, "/m/pos");
        this.setAdUnitId(this.mAdUnitId);
        this.setApiVersion(POSITIONING_API_VERSION);
        ClientMetadata clientMetadata = ClientMetadata.getInstance((Context)this.mContext);
        this.setSdkVersion(clientMetadata.getSdkVersion());
        this.setDeviceInfo(new String[]{clientMetadata.getDeviceManufacturer(), clientMetadata.getDeviceModel(), clientMetadata.getDeviceProduct()});
        this.setAppVersion(clientMetadata.getAppVersion());
        this.appendAdvertisingInfoTemplates();
        return this.getFinalUrlString();
    }

    private void setAdUnitId(@NonNull String adUnitId) {
        this.addParam("id", adUnitId);
    }

    private void setSdkVersion(@NonNull String sdkVersion) {
        this.addParam("nsv", sdkVersion);
    }
}

