/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.widget.ImageView;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.nativeads.NativeErrorCode;
import com.mopub.network.Networking;
import com.mopub.volley.VolleyError;
import com.mopub.volley.toolbox.ImageLoader;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class NativeImageHelper {
    public static void preCacheImages(@NonNull Context context, @NonNull List<String> imageUrls, final @NonNull ImageListener imageListener) {
        ImageLoader imageLoader = Networking.getImageLoader((Context)context);
        final AtomicInteger imageCounter = new AtomicInteger(imageUrls.size());
        final AtomicBoolean anyFailures = new AtomicBoolean(false);
        ImageLoader.ImageListener volleyImageListener = new ImageLoader.ImageListener(){

            public void onResponse(ImageLoader.ImageContainer imageContainer, boolean isImmediate) {
                int count;
                if (imageContainer.getBitmap() != null && (count = imageCounter.decrementAndGet()) == 0 && !anyFailures.get()) {
                    imageListener.onImagesCached();
                }
            }

            public void onErrorResponse(VolleyError volleyError) {
                MoPubLog.d((String)"Failed to download a native ads image:", (Throwable)volleyError);
                boolean anyPreviousErrors = anyFailures.getAndSet(true);
                imageCounter.decrementAndGet();
                if (!anyPreviousErrors) {
                    imageListener.onImagesFailedToCache(NativeErrorCode.IMAGE_DOWNLOAD_FAILURE);
                }
            }
        };
        for (String url : imageUrls) {
            if (TextUtils.isEmpty((CharSequence)url)) {
                anyFailures.set(true);
                imageListener.onImagesFailedToCache(NativeErrorCode.IMAGE_DOWNLOAD_FAILURE);
                return;
            }
            imageLoader.get(url, volleyImageListener);
        }
    }

    public static void loadImageView(@Nullable String url, final @Nullable ImageView imageView) {
        if (!Preconditions.NoThrow.checkNotNull((Object)imageView, (String)"Cannot load image into null ImageView")) {
            return;
        }
        if (!Preconditions.NoThrow.checkNotNull((Object)url, (String)"Cannot load image with null url")) {
            imageView.setImageDrawable(null);
            return;
        }
        ImageLoader mImageLoader = Networking.getImageLoader((Context)imageView.getContext());
        mImageLoader.get(url, new ImageLoader.ImageListener(){

            public void onResponse(ImageLoader.ImageContainer imageContainer, boolean isImmediate) {
                if (!isImmediate) {
                    MoPubLog.d((String)"Image was not loaded immediately into your ad view. You should call preCacheImages as part of your custom event loading process.");
                }
                imageView.setImageBitmap(imageContainer.getBitmap());
            }

            public void onErrorResponse(VolleyError volleyError) {
                MoPubLog.d((String)"Failed to load image.", (Throwable)volleyError);
                imageView.setImageDrawable(null);
            }
        });
    }

    public static interface ImageListener {
        public void onImagesCached();

        public void onImagesFailedToCache(NativeErrorCode var1);
    }
}

