/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.VisibleForTesting;
import com.mopub.nativeads.AdRendererRegistry;
import com.mopub.nativeads.MoPubAdRenderer;
import com.mopub.nativeads.MoPubNative;
import com.mopub.nativeads.NativeAd;
import com.mopub.nativeads.NativeErrorCode;
import com.mopub.nativeads.RequestParameters;
import com.mopub.nativeads.TimestampWrapper;
import java.util.ArrayList;
import java.util.List;

class NativeAdSource {
    private static final int CACHE_LIMIT = 1;
    private static final int EXPIRATION_TIME_MILLISECONDS = 900000;
    private static final int MAXIMUM_RETRY_TIME_MILLISECONDS = 300000;
    @VisibleForTesting
    static final int[] RETRY_TIME_ARRAY_MILLISECONDS = new int[]{1000, 3000, 5000, 25000, 60000, 300000};
    @NonNull
    private final List<TimestampWrapper<NativeAd>> mNativeAdCache;
    @NonNull
    private final Handler mReplenishCacheHandler;
    @NonNull
    private final Runnable mReplenishCacheRunnable;
    @NonNull
    private final MoPubNative.MoPubNativeNetworkListener mMoPubNativeNetworkListener;
    @VisibleForTesting
    boolean mRequestInFlight;
    @VisibleForTesting
    boolean mRetryInFlight;
    @VisibleForTesting
    int mSequenceNumber;
    @VisibleForTesting
    int mCurrentRetries;
    @Nullable
    private AdSourceListener mAdSourceListener;
    @Nullable
    private RequestParameters mRequestParameters;
    @Nullable
    private MoPubNative mMoPubNative;
    @NonNull
    private final AdRendererRegistry mAdRendererRegistry;

    NativeAdSource() {
        this(new ArrayList<TimestampWrapper<NativeAd>>(1), new Handler(), new AdRendererRegistry());
    }

    @VisibleForTesting
    NativeAdSource(@NonNull List<TimestampWrapper<NativeAd>> nativeAdCache, @NonNull Handler replenishCacheHandler, @NonNull AdRendererRegistry adRendererRegistry) {
        this.mNativeAdCache = nativeAdCache;
        this.mReplenishCacheHandler = replenishCacheHandler;
        this.mReplenishCacheRunnable = new Runnable(){

            @Override
            public void run() {
                NativeAdSource.this.mRetryInFlight = false;
                NativeAdSource.this.replenishCache();
            }
        };
        this.mAdRendererRegistry = adRendererRegistry;
        this.mMoPubNativeNetworkListener = new MoPubNative.MoPubNativeNetworkListener(){

            @Override
            public void onNativeLoad(@NonNull NativeAd nativeAd) {
                if (NativeAdSource.this.mMoPubNative == null) {
                    return;
                }
                NativeAdSource.this.mRequestInFlight = false;
                ++NativeAdSource.this.mSequenceNumber;
                NativeAdSource.this.resetRetryTime();
                NativeAdSource.this.mNativeAdCache.add(new TimestampWrapper<NativeAd>(nativeAd));
                if (NativeAdSource.this.mNativeAdCache.size() == 1 && NativeAdSource.this.mAdSourceListener != null) {
                    NativeAdSource.this.mAdSourceListener.onAdsAvailable();
                }
                NativeAdSource.this.replenishCache();
            }

            @Override
            public void onNativeFail(NativeErrorCode errorCode) {
                NativeAdSource.this.mRequestInFlight = false;
                if (NativeAdSource.this.mCurrentRetries >= RETRY_TIME_ARRAY_MILLISECONDS.length - 1) {
                    NativeAdSource.this.resetRetryTime();
                    return;
                }
                NativeAdSource.this.updateRetryTime();
                NativeAdSource.this.mRetryInFlight = true;
                NativeAdSource.this.mReplenishCacheHandler.postDelayed(NativeAdSource.this.mReplenishCacheRunnable, (long)NativeAdSource.this.getRetryTime());
            }
        };
        this.mSequenceNumber = 0;
        this.resetRetryTime();
    }

    int getAdRendererCount() {
        return this.mAdRendererRegistry.getAdRendererCount();
    }

    public int getViewTypeForAd(@NonNull NativeAd nativeAd) {
        return this.mAdRendererRegistry.getViewTypeForAd(nativeAd);
    }

    void registerAdRenderer(@NonNull MoPubAdRenderer moPubNativeAdRenderer) {
        this.mAdRendererRegistry.registerAdRenderer(moPubNativeAdRenderer);
        if (this.mMoPubNative != null) {
            this.mMoPubNative.registerAdRenderer(moPubNativeAdRenderer);
        }
    }

    @Nullable
    public MoPubAdRenderer getAdRendererForViewType(int viewType) {
        return this.mAdRendererRegistry.getRendererForViewType(viewType);
    }

    void setAdSourceListener(@Nullable AdSourceListener adSourceListener) {
        this.mAdSourceListener = adSourceListener;
    }

    void loadAds(@NonNull Activity activity, @NonNull String adUnitId, RequestParameters requestParameters) {
        this.loadAds(requestParameters, new MoPubNative((Context)activity, adUnitId, this.mMoPubNativeNetworkListener));
    }

    @VisibleForTesting
    void loadAds(RequestParameters requestParameters, MoPubNative moPubNative) {
        this.clear();
        for (MoPubAdRenderer renderer : this.mAdRendererRegistry.getRendererIterable()) {
            moPubNative.registerAdRenderer(renderer);
        }
        this.mRequestParameters = requestParameters;
        this.mMoPubNative = moPubNative;
        this.replenishCache();
    }

    void clear() {
        if (this.mMoPubNative != null) {
            this.mMoPubNative.destroy();
            this.mMoPubNative = null;
        }
        this.mRequestParameters = null;
        for (TimestampWrapper<NativeAd> timestampWrapper : this.mNativeAdCache) {
            ((NativeAd)timestampWrapper.mInstance).destroy();
        }
        this.mNativeAdCache.clear();
        this.mReplenishCacheHandler.removeMessages(0);
        this.mRequestInFlight = false;
        this.mSequenceNumber = 0;
        this.resetRetryTime();
    }

    @Nullable
    NativeAd dequeueAd() {
        long now = SystemClock.uptimeMillis();
        if (!this.mRequestInFlight && !this.mRetryInFlight) {
            this.mReplenishCacheHandler.post(this.mReplenishCacheRunnable);
        }
        while (!this.mNativeAdCache.isEmpty()) {
            TimestampWrapper<NativeAd> responseWrapper = this.mNativeAdCache.remove(0);
            if (now - responseWrapper.mCreatedTimestamp >= 900000L) continue;
            return (NativeAd)responseWrapper.mInstance;
        }
        return null;
    }

    @VisibleForTesting
    void updateRetryTime() {
        if (this.mCurrentRetries < RETRY_TIME_ARRAY_MILLISECONDS.length - 1) {
            ++this.mCurrentRetries;
        }
    }

    @VisibleForTesting
    void resetRetryTime() {
        this.mCurrentRetries = 0;
    }

    @VisibleForTesting
    int getRetryTime() {
        if (this.mCurrentRetries >= RETRY_TIME_ARRAY_MILLISECONDS.length) {
            this.mCurrentRetries = RETRY_TIME_ARRAY_MILLISECONDS.length - 1;
        }
        return RETRY_TIME_ARRAY_MILLISECONDS[this.mCurrentRetries];
    }

    @VisibleForTesting
    void replenishCache() {
        if (!this.mRequestInFlight && this.mMoPubNative != null && this.mNativeAdCache.size() < 1) {
            this.mRequestInFlight = true;
            this.mMoPubNative.makeRequest(this.mRequestParameters, this.mSequenceNumber);
        }
    }

    @Deprecated
    @VisibleForTesting
    void setMoPubNative(MoPubNative moPubNative) {
        this.mMoPubNative = moPubNative;
    }

    @Deprecated
    @NonNull
    @VisibleForTesting
    MoPubNative.MoPubNativeNetworkListener getMoPubNativeNetworkListener() {
        return this.mMoPubNativeNetworkListener;
    }

    static interface AdSourceListener {
        public void onAdsAvailable();
    }
}

