/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.nativeads.ClientPositioningSource;
import com.mopub.nativeads.MoPubAdRenderer;
import com.mopub.nativeads.MoPubNativeAdLoadedListener;
import com.mopub.nativeads.MoPubNativeAdPositioning;
import com.mopub.nativeads.NativeAd;
import com.mopub.nativeads.NativeAdSource;
import com.mopub.nativeads.PlacementData;
import com.mopub.nativeads.PositioningSource;
import com.mopub.nativeads.RequestParameters;
import com.mopub.nativeads.ServerPositioningSource;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.WeakHashMap;

public class MoPubStreamAdPlacer {
    public static final int CONTENT_VIEW_TYPE = 0;
    private static final int DEFAULT_AD_VIEW_TYPE = -1;
    private static final MoPubNativeAdLoadedListener EMPTY_NATIVE_AD_LOADED_LISTENER = new MoPubNativeAdLoadedListener(){

        @Override
        public void onAdLoaded(int position) {
        }

        @Override
        public void onAdRemoved(int position) {
        }
    };
    @NonNull
    private final Activity mActivity;
    @NonNull
    private final Handler mPlacementHandler;
    @NonNull
    private final Runnable mPlacementRunnable;
    @NonNull
    private final PositioningSource mPositioningSource;
    @NonNull
    private final NativeAdSource mAdSource;
    @NonNull
    private final HashMap<NativeAd, WeakReference<View>> mViewMap;
    @NonNull
    private final WeakHashMap<View, NativeAd> mNativeAdMap;
    private boolean mHasReceivedPositions;
    @Nullable
    private PlacementData mPendingPlacementData;
    private boolean mHasReceivedAds;
    private boolean mHasPlacedAds;
    @NonNull
    private PlacementData mPlacementData;
    @Nullable
    private String mAdUnitId;
    @NonNull
    private MoPubNativeAdLoadedListener mAdLoadedListener = EMPTY_NATIVE_AD_LOADED_LISTENER;
    private static final int MAX_VISIBLE_RANGE = 100;
    private int mVisibleRangeStart;
    private int mVisibleRangeEnd;
    private int mItemCount;
    private static final int RANGE_BUFFER = 6;
    private boolean mNeedsPlacement;

    public MoPubStreamAdPlacer(@NonNull Activity activity) {
        this(activity, MoPubNativeAdPositioning.serverPositioning());
    }

    public MoPubStreamAdPlacer(@NonNull Activity activity, @NonNull MoPubNativeAdPositioning.MoPubServerPositioning adPositioning) {
        this(activity, new NativeAdSource(), new ServerPositioningSource((Context)activity));
    }

    public MoPubStreamAdPlacer(@NonNull Activity activity, @NonNull MoPubNativeAdPositioning.MoPubClientPositioning adPositioning) {
        this(activity, new NativeAdSource(), new ClientPositioningSource(adPositioning));
    }

    @VisibleForTesting
    MoPubStreamAdPlacer(@NonNull Activity activity, @NonNull NativeAdSource adSource, @NonNull PositioningSource positioningSource) {
        Preconditions.checkNotNull((Object)activity, (String)"activity is not allowed to be null");
        Preconditions.checkNotNull((Object)adSource, (String)"adSource is not allowed to be null");
        Preconditions.checkNotNull((Object)positioningSource, (String)"positioningSource is not allowed to be null");
        this.mActivity = activity;
        this.mPositioningSource = positioningSource;
        this.mAdSource = adSource;
        this.mPlacementData = PlacementData.empty();
        this.mNativeAdMap = new WeakHashMap();
        this.mViewMap = new HashMap();
        this.mPlacementHandler = new Handler();
        this.mPlacementRunnable = new Runnable(){

            @Override
            public void run() {
                if (!MoPubStreamAdPlacer.this.mNeedsPlacement) {
                    return;
                }
                MoPubStreamAdPlacer.this.placeAds();
                MoPubStreamAdPlacer.this.mNeedsPlacement = false;
            }
        };
        this.mVisibleRangeStart = 0;
        this.mVisibleRangeEnd = 0;
    }

    public void registerAdRenderer(@NonNull MoPubAdRenderer adRenderer) {
        if (!Preconditions.NoThrow.checkNotNull((Object)adRenderer, (String)"Cannot register a null adRenderer")) {
            return;
        }
        this.mAdSource.registerAdRenderer(adRenderer);
    }

    @Nullable
    public MoPubAdRenderer getAdRendererForViewType(int viewType) {
        return this.mAdSource.getAdRendererForViewType(viewType);
    }

    public void setAdLoadedListener(@Nullable MoPubNativeAdLoadedListener listener) {
        this.mAdLoadedListener = listener == null ? EMPTY_NATIVE_AD_LOADED_LISTENER : listener;
    }

    public void loadAds(@NonNull String adUnitId) {
        this.loadAds(adUnitId, null);
    }

    public void loadAds(@NonNull String adUnitId, @Nullable RequestParameters requestParameters) {
        if (!Preconditions.NoThrow.checkNotNull((Object)adUnitId, (String)"Cannot load ads with a null ad unit ID")) {
            return;
        }
        if (this.mAdSource.getAdRendererCount() == 0) {
            MoPubLog.w((String)"You must register at least 1 ad renderer by calling registerAdRenderer before loading ads");
            return;
        }
        this.mAdUnitId = adUnitId;
        this.mHasPlacedAds = false;
        this.mHasReceivedPositions = false;
        this.mHasReceivedAds = false;
        this.mPositioningSource.loadPositions(adUnitId, new PositioningSource.PositioningListener(){

            @Override
            public void onLoad(@NonNull MoPubNativeAdPositioning.MoPubClientPositioning positioning) {
                MoPubStreamAdPlacer.this.handlePositioningLoad(positioning);
            }

            @Override
            public void onFailed() {
                MoPubLog.d((String)"Unable to show ads because ad positions could not be loaded from the MoPub ad server.");
            }
        });
        this.mAdSource.setAdSourceListener(new NativeAdSource.AdSourceListener(){

            @Override
            public void onAdsAvailable() {
                MoPubStreamAdPlacer.this.handleAdsAvailable();
            }
        });
        this.mAdSource.loadAds(this.mActivity, adUnitId, requestParameters);
    }

    @VisibleForTesting
    void handlePositioningLoad(@NonNull MoPubNativeAdPositioning.MoPubClientPositioning positioning) {
        PlacementData placementData = PlacementData.fromAdPositioning(positioning);
        if (this.mHasReceivedAds) {
            this.placeInitialAds(placementData);
        } else {
            this.mPendingPlacementData = placementData;
        }
        this.mHasReceivedPositions = true;
    }

    @VisibleForTesting
    void handleAdsAvailable() {
        if (this.mHasPlacedAds) {
            this.notifyNeedsPlacement();
            return;
        }
        if (this.mHasReceivedPositions) {
            this.placeInitialAds(this.mPendingPlacementData);
        }
        this.mHasReceivedAds = true;
    }

    private void placeInitialAds(PlacementData placementData) {
        this.removeAdsInRange(0, this.mItemCount);
        this.mPlacementData = placementData;
        this.placeAds();
        this.mHasPlacedAds = true;
    }

    public void placeAdsInRange(int startPosition, int endPosition) {
        this.mVisibleRangeStart = startPosition;
        this.mVisibleRangeEnd = Math.min(endPosition, startPosition + 100);
        this.notifyNeedsPlacement();
    }

    public boolean isAd(int position) {
        return this.mPlacementData.isPlacedAd(position);
    }

    public void clearAds() {
        this.removeAdsInRange(0, this.mItemCount);
        this.mAdSource.clear();
    }

    public void destroy() {
        this.mPlacementHandler.removeMessages(0);
        this.mAdSource.clear();
        this.mPlacementData.clearAds();
    }

    @Nullable
    public Object getAdData(int position) {
        return this.mPlacementData.getPlacedAd(position);
    }

    @Nullable
    public View getAdView(int position, @Nullable View convertView, @Nullable ViewGroup parent) {
        NativeAd nativeAd = this.mPlacementData.getPlacedAd(position);
        if (nativeAd == null) {
            return null;
        }
        View view = convertView != null ? convertView : nativeAd.createAdView((Context)this.mActivity, parent);
        this.bindAdView(nativeAd, view);
        return view;
    }

    public void bindAdView(@NonNull NativeAd nativeAd, @NonNull View adView) {
        WeakReference<View> mappedViewRef = this.mViewMap.get(nativeAd);
        View mappedView = null;
        if (mappedViewRef != null) {
            mappedView = (View)mappedViewRef.get();
        }
        if (!adView.equals(mappedView)) {
            this.clearNativeAd(mappedView);
            this.clearNativeAd(adView);
            this.prepareNativeAd(nativeAd, adView);
            nativeAd.renderAdView(adView);
        }
    }

    public int removeAdsInRange(int originalStartPosition, int originalEndPosition) {
        int[] positions = this.mPlacementData.getPlacedAdPositions();
        int adjustedStartRange = this.mPlacementData.getAdjustedPosition(originalStartPosition);
        int adjustedEndRange = this.mPlacementData.getAdjustedPosition(originalEndPosition);
        ArrayList<Integer> removedPositions = new ArrayList<Integer>();
        for (int i = positions.length - 1; i >= 0; --i) {
            int position = positions[i];
            if (position < adjustedStartRange || position >= adjustedEndRange) continue;
            removedPositions.add(position);
            if (position < this.mVisibleRangeStart) {
                --this.mVisibleRangeStart;
            }
            --this.mItemCount;
        }
        int clearedAdsCount = this.mPlacementData.clearAdsInRange(adjustedStartRange, adjustedEndRange);
        Iterator i$ = removedPositions.iterator();
        while (i$.hasNext()) {
            int position = (Integer)i$.next();
            this.mAdLoadedListener.onAdRemoved(position);
        }
        return clearedAdsCount;
    }

    public int getAdViewTypeCount() {
        return this.mAdSource.getAdRendererCount();
    }

    public int getAdViewType(int position) {
        NativeAd nativeAd = this.mPlacementData.getPlacedAd(position);
        if (nativeAd == null) {
            return 0;
        }
        return this.mAdSource.getViewTypeForAd(nativeAd);
    }

    public int getOriginalPosition(int position) {
        return this.mPlacementData.getOriginalPosition(position);
    }

    public int getAdjustedPosition(int originalPosition) {
        return this.mPlacementData.getAdjustedPosition(originalPosition);
    }

    public int getOriginalCount(int count) {
        return this.mPlacementData.getOriginalCount(count);
    }

    public int getAdjustedCount(int originalCount) {
        return this.mPlacementData.getAdjustedCount(originalCount);
    }

    public void setItemCount(int originalCount) {
        this.mItemCount = this.mPlacementData.getAdjustedCount(originalCount);
        if (this.mHasPlacedAds) {
            this.notifyNeedsPlacement();
        }
    }

    public void insertItem(int originalPosition) {
        this.mPlacementData.insertItem(originalPosition);
    }

    public void removeItem(int originalPosition) {
        this.mPlacementData.removeItem(originalPosition);
    }

    public void moveItem(int originalPosition, int newPosition) {
        this.mPlacementData.moveItem(originalPosition, newPosition);
    }

    private void notifyNeedsPlacement() {
        if (this.mNeedsPlacement) {
            return;
        }
        this.mNeedsPlacement = true;
        this.mPlacementHandler.post(this.mPlacementRunnable);
    }

    private void placeAds() {
        if (!this.tryPlaceAdsInRange(this.mVisibleRangeStart, this.mVisibleRangeEnd)) {
            return;
        }
        this.tryPlaceAdsInRange(this.mVisibleRangeEnd, this.mVisibleRangeEnd + 6);
    }

    private boolean tryPlaceAdsInRange(int start, int end) {
        int position = start;
        int lastPosition = end - 1;
        while (position <= lastPosition && position != -1 && position < this.mItemCount) {
            if (this.mPlacementData.shouldPlaceAd(position)) {
                if (!this.tryPlaceAd(position)) {
                    return false;
                }
                ++lastPosition;
            }
            position = this.mPlacementData.nextInsertionPosition(position);
        }
        return true;
    }

    private boolean tryPlaceAd(int position) {
        NativeAd nativeAd = this.mAdSource.dequeueAd();
        if (nativeAd == null) {
            return false;
        }
        this.mPlacementData.placeAd(position, nativeAd);
        ++this.mItemCount;
        this.mAdLoadedListener.onAdLoaded(position);
        return true;
    }

    private void clearNativeAd(@Nullable View view) {
        if (view == null) {
            return;
        }
        NativeAd lastNativeAd = this.mNativeAdMap.get(view);
        if (lastNativeAd != null) {
            lastNativeAd.clear(view);
            this.mNativeAdMap.remove(view);
            this.mViewMap.remove(lastNativeAd);
        }
    }

    private void prepareNativeAd(@NonNull NativeAd nativeAd, @NonNull View view) {
        this.mViewMap.put(nativeAd, new WeakReference<View>(view));
        this.mNativeAdMap.put(view, nativeAd);
        nativeAd.prepare(view);
    }
}

