/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.AdFormat;
import com.mopub.common.GpsHelper;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.DeviceUtils;
import com.mopub.common.util.ManifestUtils;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.nativeads.AdRendererRegistry;
import com.mopub.nativeads.BaseNativeAd;
import com.mopub.nativeads.CustomEventNative;
import com.mopub.nativeads.CustomEventNativeAdapter;
import com.mopub.nativeads.MoPubAdRenderer;
import com.mopub.nativeads.NativeAd;
import com.mopub.nativeads.NativeErrorCode;
import com.mopub.nativeads.NativeUrlGenerator;
import com.mopub.nativeads.RequestParameters;
import com.mopub.network.AdRequest;
import com.mopub.network.AdResponse;
import com.mopub.network.MoPubNetworkError;
import com.mopub.network.MoPubRequestQueue;
import com.mopub.network.Networking;
import com.mopub.volley.NetworkResponse;
import com.mopub.volley.Request;
import com.mopub.volley.VolleyError;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.TreeMap;

public class MoPubNative {
    static final MoPubNativeNetworkListener EMPTY_NETWORK_LISTENER = new MoPubNativeNetworkListener(){

        @Override
        public void onNativeLoad(@NonNull NativeAd nativeAd) {
            nativeAd.destroy();
        }

        @Override
        public void onNativeFail(NativeErrorCode errorCode) {
        }
    };
    @NonNull
    private final WeakReference<Context> mContext;
    @NonNull
    private final String mAdUnitId;
    @NonNull
    private MoPubNativeNetworkListener mMoPubNativeNetworkListener;
    @NonNull
    private Map<String, Object> mLocalExtras = new TreeMap<String, Object>();
    @NonNull
    private final AdRequest.Listener mVolleyListener;
    @Nullable
    private AdRequest mNativeRequest;
    @NonNull
    AdRendererRegistry mAdRendererRegistry;

    public MoPubNative(@NonNull Context context, @NonNull String adUnitId, @NonNull MoPubNativeNetworkListener moPubNativeNetworkListener) {
        this(context, adUnitId, new AdRendererRegistry(), moPubNativeNetworkListener);
    }

    @VisibleForTesting
    public MoPubNative(@NonNull Context context, @NonNull String adUnitId, @NonNull AdRendererRegistry adRendererRegistry, @NonNull MoPubNativeNetworkListener moPubNativeNetworkListener) {
        Preconditions.checkNotNull((Object)context, (String)"context may not be null.");
        Preconditions.checkNotNull((Object)adUnitId, (String)"AdUnitId may not be null.");
        Preconditions.checkNotNull((Object)adRendererRegistry, (String)"AdRendererRegistry may not be null.");
        Preconditions.checkNotNull((Object)moPubNativeNetworkListener, (String)"MoPubNativeNetworkListener may not be null.");
        ManifestUtils.checkNativeActivitiesDeclared((Context)context);
        this.mContext = new WeakReference<Context>(context);
        this.mAdUnitId = adUnitId;
        this.mMoPubNativeNetworkListener = moPubNativeNetworkListener;
        this.mAdRendererRegistry = adRendererRegistry;
        this.mVolleyListener = new AdRequest.Listener(){

            public void onSuccess(@NonNull AdResponse response) {
                MoPubNative.this.onAdLoad(response);
            }

            public void onErrorResponse(@NonNull VolleyError volleyError) {
                MoPubNative.this.onAdError(volleyError);
            }
        };
        GpsHelper.fetchAdvertisingInfoAsync((Context)context, null);
    }

    public void registerAdRenderer(MoPubAdRenderer moPubAdRenderer) {
        this.mAdRendererRegistry.registerAdRenderer(moPubAdRenderer);
    }

    public void destroy() {
        this.mContext.clear();
        if (this.mNativeRequest != null) {
            this.mNativeRequest.cancel();
            this.mNativeRequest = null;
        }
        this.mMoPubNativeNetworkListener = EMPTY_NETWORK_LISTENER;
    }

    public void setLocalExtras(@Nullable Map<String, Object> localExtras) {
        this.mLocalExtras = localExtras == null ? new TreeMap<String, Object>() : new TreeMap<String, Object>(localExtras);
    }

    public void makeRequest() {
        this.makeRequest(null);
    }

    public void makeRequest(@Nullable RequestParameters requestParameters) {
        this.makeRequest(requestParameters, null);
    }

    public void makeRequest(@Nullable RequestParameters requestParameters, @Nullable Integer sequenceNumber) {
        Context context = this.getContextOrDestroy();
        if (context == null) {
            return;
        }
        if (!DeviceUtils.isNetworkAvailable((Context)context)) {
            this.mMoPubNativeNetworkListener.onNativeFail(NativeErrorCode.CONNECTION_ERROR);
            return;
        }
        this.loadNativeAd(requestParameters, sequenceNumber);
    }

    private void loadNativeAd(@Nullable RequestParameters requestParameters, @Nullable Integer sequenceNumber) {
        String endpointUrl;
        Context context = this.getContextOrDestroy();
        if (context == null) {
            return;
        }
        NativeUrlGenerator generator = new NativeUrlGenerator(context).withAdUnitId(this.mAdUnitId).withRequest(requestParameters);
        if (sequenceNumber != null) {
            generator.withSequenceNumber(sequenceNumber);
        }
        if ((endpointUrl = generator.generateUrlString("ads.mopub.com")) != null) {
            MoPubLog.d((String)("Loading ad from: " + endpointUrl));
        }
        this.requestNativeAd(endpointUrl);
    }

    void requestNativeAd(@Nullable String endpointUrl) {
        Context context = this.getContextOrDestroy();
        if (context == null) {
            return;
        }
        if (endpointUrl == null) {
            this.mMoPubNativeNetworkListener.onNativeFail(NativeErrorCode.INVALID_REQUEST_URL);
            return;
        }
        this.mNativeRequest = new AdRequest(endpointUrl, AdFormat.NATIVE, this.mAdUnitId, context, this.mVolleyListener);
        MoPubRequestQueue requestQueue = Networking.getRequestQueue((Context)context);
        requestQueue.add((Request)this.mNativeRequest);
    }

    private void onAdLoad(final @NonNull AdResponse response) {
        Context context = this.getContextOrDestroy();
        if (context == null) {
            return;
        }
        CustomEventNative.CustomEventNativeListener customEventNativeListener = new CustomEventNative.CustomEventNativeListener(){

            @Override
            public void onNativeAdLoaded(@NonNull BaseNativeAd nativeAd) {
                Context context = MoPubNative.this.getContextOrDestroy();
                if (context == null) {
                    return;
                }
                MoPubAdRenderer renderer = MoPubNative.this.mAdRendererRegistry.getRendererForAd(nativeAd);
                if (renderer == null) {
                    this.onNativeAdFailed(NativeErrorCode.NATIVE_RENDERER_CONFIGURATION_ERROR);
                    return;
                }
                MoPubNative.this.mMoPubNativeNetworkListener.onNativeLoad(new NativeAd(context, response.getImpressionTrackingUrl(), response.getClickTrackingUrl(), MoPubNative.this.mAdUnitId, nativeAd, renderer));
            }

            @Override
            public void onNativeAdFailed(NativeErrorCode errorCode) {
                MoPubLog.v((String)String.format("Native Ad failed to load with error: %s.", new Object[]{errorCode}));
                MoPubNative.this.requestNativeAd(response.getFailoverUrl());
            }
        };
        CustomEventNativeAdapter.loadNativeAd(context, this.mLocalExtras, response, customEventNativeListener);
    }

    @VisibleForTesting
    void onAdError(@NonNull VolleyError volleyError) {
        MoPubLog.d((String)"Native ad request failed.", (Throwable)volleyError);
        if (volleyError instanceof MoPubNetworkError) {
            MoPubNetworkError error = (MoPubNetworkError)volleyError;
            switch (error.getReason()) {
                case BAD_BODY: {
                    this.mMoPubNativeNetworkListener.onNativeFail(NativeErrorCode.INVALID_RESPONSE);
                    return;
                }
                case BAD_HEADER_DATA: {
                    this.mMoPubNativeNetworkListener.onNativeFail(NativeErrorCode.INVALID_RESPONSE);
                    return;
                }
                case WARMING_UP: {
                    MoPubLog.c((String)MoPubErrorCode.WARMUP.toString());
                    this.mMoPubNativeNetworkListener.onNativeFail(NativeErrorCode.EMPTY_AD_RESPONSE);
                    return;
                }
                case NO_FILL: {
                    this.mMoPubNativeNetworkListener.onNativeFail(NativeErrorCode.EMPTY_AD_RESPONSE);
                    return;
                }
            }
            this.mMoPubNativeNetworkListener.onNativeFail(NativeErrorCode.UNSPECIFIED);
            return;
        }
        NetworkResponse response = volleyError.networkResponse;
        if (response != null && response.statusCode >= 500 && response.statusCode < 600) {
            this.mMoPubNativeNetworkListener.onNativeFail(NativeErrorCode.SERVER_ERROR_RESPONSE_CODE);
        } else if (response == null && !DeviceUtils.isNetworkAvailable((Context)((Context)this.mContext.get()))) {
            MoPubLog.c((String)String.valueOf(MoPubErrorCode.NO_CONNECTION.toString()));
            this.mMoPubNativeNetworkListener.onNativeFail(NativeErrorCode.CONNECTION_ERROR);
        } else {
            this.mMoPubNativeNetworkListener.onNativeFail(NativeErrorCode.UNSPECIFIED);
        }
    }

    @VisibleForTesting
    @Nullable
    Context getContextOrDestroy() {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            this.destroy();
            MoPubLog.d((String)"Weak reference to Context in MoPubNative became null. This instance of MoPubNative is destroyed and No more requests will be processed.");
        }
        return context;
    }

    @Deprecated
    @VisibleForTesting
    @NonNull
    MoPubNativeNetworkListener getMoPubNativeNetworkListener() {
        return this.mMoPubNativeNetworkListener;
    }

    public static interface MoPubNativeNetworkListener {
        public void onNativeLoad(NativeAd var1);

        public void onNativeFail(NativeErrorCode var1);
    }
}

