/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Numbers;
import com.mopub.nativeads.CustomEventNative;
import com.mopub.nativeads.ImpressionTracker;
import com.mopub.nativeads.NativeClickHandler;
import com.mopub.nativeads.NativeErrorCode;
import com.mopub.nativeads.NativeImageHelper;
import com.mopub.nativeads.StaticNativeAd;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class MoPubCustomEventNative
extends CustomEventNative {
    @Override
    protected void loadNativeAd(@NonNull Context context, @NonNull CustomEventNative.CustomEventNativeListener customEventNativeListener, @NonNull Map<String, Object> localExtras, @NonNull Map<String, String> serverExtras) {
        Object json = localExtras.get("com_mopub_native_json");
        if (!(json instanceof JSONObject)) {
            customEventNativeListener.onNativeAdFailed(NativeErrorCode.INVALID_RESPONSE);
            return;
        }
        MoPubStaticNativeAd moPubStaticNativeAd = new MoPubStaticNativeAd(context, (JSONObject)json, new ImpressionTracker(context), new NativeClickHandler(context), customEventNativeListener);
        try {
            moPubStaticNativeAd.loadAd();
        }
        catch (IllegalArgumentException e) {
            customEventNativeListener.onNativeAdFailed(NativeErrorCode.UNSPECIFIED);
        }
    }

    static class MoPubStaticNativeAd
    extends StaticNativeAd {
        @VisibleForTesting
        static final String PRIVACY_INFORMATION_CLICKTHROUGH_URL = "https://www.mopub.com/optout";
        @NonNull
        private final Context mContext;
        @NonNull
        private final CustomEventNative.CustomEventNativeListener mCustomEventNativeListener;
        @NonNull
        private final JSONObject mJsonObject;
        @NonNull
        private final ImpressionTracker mImpressionTracker;
        @NonNull
        private final NativeClickHandler mNativeClickHandler;

        MoPubStaticNativeAd(@NonNull Context context, @NonNull JSONObject jsonBody, @NonNull ImpressionTracker impressionTracker, @NonNull NativeClickHandler nativeClickHandler, @NonNull CustomEventNative.CustomEventNativeListener customEventNativeListener) {
            this.mJsonObject = jsonBody;
            this.mContext = context.getApplicationContext();
            this.mImpressionTracker = impressionTracker;
            this.mNativeClickHandler = nativeClickHandler;
            this.mCustomEventNativeListener = customEventNativeListener;
        }

        void loadAd() throws IllegalArgumentException {
            if (!this.containsRequiredKeys(this.mJsonObject)) {
                throw new IllegalArgumentException("JSONObject did not contain required keys.");
            }
            Iterator keys = this.mJsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Parameter parameter = Parameter.from(key);
                if (parameter != null) {
                    try {
                        this.addInstanceVariable(parameter, this.mJsonObject.opt(key));
                        continue;
                    }
                    catch (ClassCastException e) {
                        throw new IllegalArgumentException("JSONObject key (" + key + ") contained unexpected value.");
                    }
                }
                this.addExtra(key, this.mJsonObject.opt(key));
            }
            this.setPrivacyInformationIconClickThroughUrl(PRIVACY_INFORMATION_CLICKTHROUGH_URL);
            NativeImageHelper.preCacheImages(this.mContext, this.getAllImageUrls(), new NativeImageHelper.ImageListener(){

                @Override
                public void onImagesCached() {
                    MoPubStaticNativeAd.this.mCustomEventNativeListener.onNativeAdLoaded(MoPubStaticNativeAd.this);
                }

                @Override
                public void onImagesFailedToCache(NativeErrorCode errorCode) {
                    MoPubStaticNativeAd.this.mCustomEventNativeListener.onNativeAdFailed(errorCode);
                }
            });
        }

        private boolean containsRequiredKeys(@NonNull JSONObject jsonObject) {
            HashSet keys = new HashSet();
            Iterator jsonKeys = jsonObject.keys();
            while (jsonKeys.hasNext()) {
                keys.add(jsonKeys.next());
            }
            return keys.containsAll(Parameter.requiredKeys);
        }

        private void addInstanceVariable(@NonNull Parameter key, @Nullable Object value) throws ClassCastException {
            try {
                switch (key) {
                    case MAIN_IMAGE: {
                        this.setMainImageUrl((String)value);
                        break;
                    }
                    case ICON_IMAGE: {
                        this.setIconImageUrl((String)value);
                        break;
                    }
                    case IMPRESSION_TRACKER: {
                        this.addImpressionTrackers(value);
                        break;
                    }
                    case CLICK_DESTINATION: {
                        this.setClickDestinationUrl((String)value);
                        break;
                    }
                    case CLICK_TRACKER: {
                        this.parseClickTrackers(value);
                        break;
                    }
                    case CALL_TO_ACTION: {
                        this.setCallToAction((String)value);
                        break;
                    }
                    case TITLE: {
                        this.setTitle((String)value);
                        break;
                    }
                    case TEXT: {
                        this.setText((String)value);
                        break;
                    }
                    case STAR_RATING: {
                        this.setStarRating(Numbers.parseDouble((Object)value));
                        break;
                    }
                    default: {
                        MoPubLog.d((String)("Unable to add JSON key to internal mapping: " + key.name));
                        break;
                    }
                }
            }
            catch (ClassCastException e) {
                if (!key.required) {
                    MoPubLog.d((String)("Ignoring class cast exception for optional key: " + key.name));
                }
                throw e;
            }
        }

        private void parseClickTrackers(@NonNull Object clickTrackers) {
            if (clickTrackers instanceof JSONArray) {
                this.addClickTrackers(clickTrackers);
            } else {
                this.addClickTracker((String)clickTrackers);
            }
        }

        private boolean isImageKey(@Nullable String name) {
            return name != null && name.toLowerCase(Locale.US).endsWith("image");
        }

        @NonNull
        List<String> getExtrasImageUrls() {
            ArrayList<String> extrasBitmapUrls = new ArrayList<String>(this.getExtras().size());
            for (Map.Entry<String, Object> entry : this.getExtras().entrySet()) {
                if (!this.isImageKey(entry.getKey()) || !(entry.getValue() instanceof String)) continue;
                extrasBitmapUrls.add((String)entry.getValue());
            }
            return extrasBitmapUrls;
        }

        @NonNull
        List<String> getAllImageUrls() {
            ArrayList<String> imageUrls = new ArrayList<String>();
            if (this.getMainImageUrl() != null) {
                imageUrls.add(this.getMainImageUrl());
            }
            if (this.getIconImageUrl() != null) {
                imageUrls.add(this.getIconImageUrl());
            }
            imageUrls.addAll(this.getExtrasImageUrls());
            return imageUrls;
        }

        @Override
        public void prepare(@NonNull View view) {
            this.mImpressionTracker.addView(view, this);
            this.mNativeClickHandler.setOnClickListener(view, this);
        }

        @Override
        public void clear(@NonNull View view) {
            this.mImpressionTracker.removeView(view);
            this.mNativeClickHandler.clearOnClickListener(view);
        }

        @Override
        public void destroy() {
            this.mImpressionTracker.destroy();
        }

        @Override
        public void recordImpression(@NonNull View view) {
            this.notifyAdImpressed();
        }

        @Override
        public void handleClick(@Nullable View view) {
            this.notifyAdClicked();
            this.mNativeClickHandler.openClickDestinationUrl(this.getClickDestinationUrl(), view);
        }

        static enum Parameter {
            IMPRESSION_TRACKER("imptracker", true),
            CLICK_TRACKER("clktracker", true),
            TITLE("title", false),
            TEXT("text", false),
            MAIN_IMAGE("mainimage", false),
            ICON_IMAGE("iconimage", false),
            CLICK_DESTINATION("clk", false),
            FALLBACK("fallback", false),
            CALL_TO_ACTION("ctatext", false),
            STAR_RATING("starrating", false);

            @NonNull
            final String name;
            final boolean required;
            @NonNull
            @VisibleForTesting
            static final Set<String> requiredKeys;

            private Parameter(String name, boolean required) {
                this.name = name;
                this.required = required;
            }

            @Nullable
            static Parameter from(@NonNull String name) {
                for (Parameter parameter : Parameter.values()) {
                    if (!parameter.name.equals(name)) continue;
                    return parameter;
                }
                return null;
            }

            static {
                requiredKeys = new HashSet<String>();
                for (Parameter parameter : Parameter.values()) {
                    if (!parameter.required) continue;
                    requiredKeys.add(parameter.name);
                }
            }
        }
    }
}

