/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.support.annotation.NonNull;
import com.mopub.common.event.EventDetails;
import com.mopub.common.logging.MoPubLog;
import com.mopub.nativeads.CustomEventNative;
import com.mopub.nativeads.NativeErrorCode;
import com.mopub.nativeads.factories.CustomEventNativeFactory;
import com.mopub.network.AdResponse;
import java.util.Map;

final class CustomEventNativeAdapter {
    private CustomEventNativeAdapter() {
    }

    public static void loadNativeAd(@NonNull Context context, @NonNull Map<String, Object> localExtras, @NonNull AdResponse adResponse, @NonNull CustomEventNative.CustomEventNativeListener customEventNativeListener) {
        EventDetails eventDetails;
        CustomEventNative customEventNative;
        String customEventNativeClassName = adResponse.getCustomEventClassName();
        MoPubLog.d((String)("Attempting to invoke custom event: " + customEventNativeClassName));
        try {
            customEventNative = CustomEventNativeFactory.create(customEventNativeClassName);
        }
        catch (Exception e) {
            MoPubLog.w((String)("Failed to load Custom Event Native class: " + customEventNativeClassName));
            customEventNativeListener.onNativeAdFailed(NativeErrorCode.NATIVE_ADAPTER_NOT_FOUND);
            return;
        }
        if (adResponse.hasJson()) {
            localExtras.put("com_mopub_native_json", adResponse.getJsonBody());
        }
        if ((eventDetails = adResponse.getEventDetails()) != null) {
            localExtras.put("Event-Details", eventDetails);
        }
        localExtras.put("Click-Tracking-Url", adResponse.getClickTrackingUrl());
        try {
            customEventNative.loadNativeAd(context, customEventNativeListener, localExtras, adResponse.getServerExtras());
        }
        catch (Exception e) {
            MoPubLog.w((String)"Loading custom event native threw an error.", (Throwable)e);
            customEventNativeListener.onNativeAdFailed(NativeErrorCode.NATIVE_ADAPTER_NOT_FOUND);
        }
    }
}

