/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;

public abstract class BaseNativeAd {
    @NonNull
    private final Set<String> mImpressionTrackers = new HashSet<String>();
    @NonNull
    private final Set<String> mClickTrackers = new HashSet<String>();
    @Nullable
    private NativeEventListener mNativeEventListener;

    protected BaseNativeAd() {
    }

    public abstract void prepare(@NonNull View var1);

    public abstract void clear(@NonNull View var1);

    public abstract void destroy();

    public void setNativeEventListener(@Nullable NativeEventListener nativeEventListener) {
        this.mNativeEventListener = nativeEventListener;
    }

    protected final void notifyAdImpressed() {
        if (this.mNativeEventListener != null) {
            this.mNativeEventListener.onAdImpressed();
        }
    }

    protected final void notifyAdClicked() {
        if (this.mNativeEventListener != null) {
            this.mNativeEventListener.onAdClicked();
        }
    }

    protected final void addImpressionTrackers(Object impressionTrackers) throws ClassCastException {
        if (!(impressionTrackers instanceof JSONArray)) {
            throw new ClassCastException("Expected impression trackers of type JSONArray.");
        }
        JSONArray trackers = (JSONArray)impressionTrackers;
        for (int i = 0; i < trackers.length(); ++i) {
            try {
                this.addImpressionTracker(trackers.getString(i));
                continue;
            }
            catch (JSONException e) {
                MoPubLog.d((String)"Unable to parse impression trackers.");
            }
        }
    }

    protected final void addClickTrackers(Object clickTrackers) throws ClassCastException {
        if (!(clickTrackers instanceof JSONArray)) {
            throw new ClassCastException("Expected click trackers of type JSONArray.");
        }
        JSONArray trackers = (JSONArray)clickTrackers;
        for (int i = 0; i < trackers.length(); ++i) {
            try {
                this.addClickTracker(trackers.getString(i));
                continue;
            }
            catch (JSONException e) {
                MoPubLog.d((String)"Unable to parse click trackers.");
            }
        }
    }

    public final void addImpressionTracker(@NonNull String url) {
        if (!Preconditions.NoThrow.checkNotNull((Object)url, (String)"impressionTracker url is not allowed to be null")) {
            return;
        }
        this.mImpressionTrackers.add(url);
    }

    public final void addClickTracker(@NonNull String url) {
        if (!Preconditions.NoThrow.checkNotNull((Object)url, (String)"clickTracker url is not allowed to be null")) {
            return;
        }
        this.mClickTrackers.add(url);
    }

    @NonNull
    Set<String> getImpressionTrackers() {
        return new HashSet<String>(this.mImpressionTrackers);
    }

    @NonNull
    Set<String> getClickTrackers() {
        return new HashSet<String>(this.mClickTrackers);
    }

    public static interface NativeEventListener {
        public void onAdImpressed();

        public void onAdClicked();
    }
}

