/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mopub.common.CacheService;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Json;
import com.mopub.mobileads.CustomEventInterstitial;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MraidVideoPlayerActivity;
import com.mopub.mobileads.ResponseBodyInterstitial;
import com.mopub.mobileads.VastManager;
import com.mopub.mobileads.VastVideoConfig;
import com.mopub.mobileads.factories.VastManagerFactory;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class VastVideoInterstitial
extends ResponseBodyInterstitial
implements VastManager.VastManagerListener {
    private CustomEventInterstitial.CustomEventInterstitialListener mCustomEventInterstitialListener;
    private String mVastResponse;
    private VastManager mVastManager;
    private VastVideoConfig mVastVideoConfig;
    @Nullable
    private JSONObject mVideoTrackers;
    @Nullable
    private Map<String, String> mExternalViewabilityTrackers;

    VastVideoInterstitial() {
    }

    @Override
    protected void extractExtras(Map<String, String> serverExtras) {
        this.mVastResponse = serverExtras.get("html-response-body");
        String externalViewabilityTrackers = serverExtras.get("external-video-viewability-trackers");
        try {
            this.mExternalViewabilityTrackers = Json.jsonStringToMap((String)externalViewabilityTrackers);
        }
        catch (JSONException e) {
            MoPubLog.d((String)("Failed to parse video viewability trackers to JSON: " + externalViewabilityTrackers));
        }
        String videoTrackers = serverExtras.get("video-trackers");
        if (TextUtils.isEmpty((CharSequence)videoTrackers)) {
            return;
        }
        try {
            this.mVideoTrackers = new JSONObject(videoTrackers);
        }
        catch (JSONException e) {
            MoPubLog.d((String)("Failed to parse video trackers to JSON: " + videoTrackers), (Throwable)e);
            this.mVideoTrackers = null;
        }
    }

    @Override
    protected void preRenderHtml(CustomEventInterstitial.CustomEventInterstitialListener customEventInterstitialListener) {
        this.mCustomEventInterstitialListener = customEventInterstitialListener;
        if (!CacheService.initializeDiskCache((Context)this.mContext)) {
            this.mCustomEventInterstitialListener.onInterstitialFailed(MoPubErrorCode.VIDEO_CACHE_ERROR);
            return;
        }
        this.mVastManager = VastManagerFactory.create((Context)this.mContext);
        this.mVastManager.prepareVastVideoConfiguration(this.mVastResponse, (VastManager.VastManagerListener)this, this.mAdReport.getDspCreativeId(), this.mContext);
    }

    @Override
    public void showInterstitial() {
        MraidVideoPlayerActivity.startVast((Context)this.mContext, (VastVideoConfig)this.mVastVideoConfig, (long)this.mBroadcastIdentifier);
    }

    @Override
    public void onInvalidate() {
        if (this.mVastManager != null) {
            this.mVastManager.cancel();
        }
        super.onInvalidate();
    }

    public void onVastVideoConfigurationPrepared(VastVideoConfig vastVideoConfig) {
        if (vastVideoConfig == null) {
            this.mCustomEventInterstitialListener.onInterstitialFailed(MoPubErrorCode.VIDEO_DOWNLOAD_ERROR);
            return;
        }
        this.mVastVideoConfig = vastVideoConfig;
        this.mVastVideoConfig.addVideoTrackers(this.mVideoTrackers);
        this.mVastVideoConfig.addExternalViewabilityTrackers(this.mExternalViewabilityTrackers);
        this.mCustomEventInterstitialListener.onInterstitialLoaded();
    }

    @Deprecated
    String getVastResponse() {
        return this.mVastResponse;
    }

    @Deprecated
    void setVastManager(VastManager vastManager) {
        this.mVastManager = vastManager;
    }
}

