/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.mopub.common.AdReport;
import com.mopub.common.ExternalViewabilitySessionManager;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.JavaScriptWebViewCallbacks;
import com.mopub.mobileads.BaseInterstitialActivity;
import com.mopub.mobileads.BaseWebView;
import com.mopub.mobileads.CustomEventInterstitial;
import com.mopub.mobileads.EventForwardingBroadcastReceiver;
import com.mopub.mobileads.Interstitial;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.WebViewCacheService;
import com.mopub.mraid.MraidBridge;
import com.mopub.mraid.MraidController;
import com.mopub.mraid.MraidWebViewClient;
import com.mopub.mraid.MraidWebViewDebugListener;
import com.mopub.mraid.PlacementType;
import com.mopub.network.Networking;
import java.io.Serializable;

public class MraidActivity
extends BaseInterstitialActivity {
    @Nullable
    private MraidController mMraidController;
    @Nullable
    private MraidWebViewDebugListener mDebugListener;
    @Nullable
    private ExternalViewabilitySessionManager mExternalViewabilitySessionManager;

    public static void preRenderHtml(@NonNull Interstitial mraidInterstitial, @NonNull Context context, @NonNull CustomEventInterstitial.CustomEventInterstitialListener customEventInterstitialListener, @Nullable String htmlData, @NonNull Long broadcastIdentifier) {
        Preconditions.checkNotNull((Object)mraidInterstitial);
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)customEventInterstitialListener);
        Preconditions.checkNotNull((Object)broadcastIdentifier);
        MraidActivity.preRenderHtml(mraidInterstitial, customEventInterstitialListener, htmlData, (BaseWebView)new MraidBridge.MraidWebView(context), broadcastIdentifier);
    }

    @VisibleForTesting
    static void preRenderHtml(@NonNull Interstitial mraidInterstitial, final @NonNull CustomEventInterstitial.CustomEventInterstitialListener customEventInterstitialListener, @Nullable String htmlData, @NonNull BaseWebView mraidWebView, @NonNull Long broadcastIdentifier) {
        Preconditions.checkNotNull((Object)mraidInterstitial);
        Preconditions.checkNotNull((Object)customEventInterstitialListener);
        Preconditions.checkNotNull((Object)mraidWebView);
        Preconditions.checkNotNull((Object)broadcastIdentifier);
        mraidWebView.enablePlugins(false);
        mraidWebView.enableJavascriptCaching();
        mraidWebView.setWebViewClient((WebViewClient)new MraidWebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if ("mopub://failLoad".equals(url)) {
                    customEventInterstitialListener.onInterstitialFailed(MoPubErrorCode.MRAID_LOAD_ERROR);
                }
                return true;
            }

            public void onPageFinished(WebView view, String url) {
                customEventInterstitialListener.onInterstitialLoaded();
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
                customEventInterstitialListener.onInterstitialFailed(MoPubErrorCode.MRAID_LOAD_ERROR);
            }
        });
        Context context = mraidWebView.getContext();
        ExternalViewabilitySessionManager externalViewabilitySessionManager = new ExternalViewabilitySessionManager(context);
        externalViewabilitySessionManager.createDisplaySession(context, (WebView)mraidWebView, true);
        mraidWebView.loadDataWithBaseURL(Networking.getBaseUrlScheme() + "://" + "ads.mopub.com" + "/", htmlData, "text/html", "UTF-8", null);
        WebViewCacheService.storeWebViewConfig((Long)broadcastIdentifier, (Interstitial)mraidInterstitial, (BaseWebView)mraidWebView, (ExternalViewabilitySessionManager)externalViewabilitySessionManager);
    }

    public static void start(@NonNull Context context, @Nullable AdReport adreport, @Nullable String htmlData, long broadcastIdentifier) {
        Intent intent = MraidActivity.createIntent(context, adreport, htmlData, broadcastIdentifier);
        try {
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException exception) {
            Log.d((String)"MraidInterstitial", (String)"MraidActivity.class not found. Did you declare MraidActivity in your manifest?");
        }
    }

    @VisibleForTesting
    protected static Intent createIntent(@NonNull Context context, @Nullable AdReport adReport, @Nullable String htmlData, long broadcastIdentifier) {
        Intent intent = new Intent(context, MraidActivity.class);
        intent.putExtra("html-response-body", htmlData);
        intent.putExtra("broadcastIdentifier", broadcastIdentifier);
        intent.putExtra("mopub-intent-ad-report", (Serializable)adReport);
        intent.addFlags(0x10000000);
        return intent;
    }

    @Override
    public View getAdView() {
        String htmlData = this.getIntent().getStringExtra("html-response-body");
        if (htmlData == null) {
            MoPubLog.w((String)"MraidActivity received a null HTML body. Finishing the activity.");
            this.finish();
            return new View((Context)this);
        }
        this.mMraidController = new MraidController((Context)this, this.mAdReport, PlacementType.INTERSTITIAL);
        this.mMraidController.setDebugListener(this.mDebugListener);
        this.mMraidController.setMraidListener(new MraidController.MraidListener(){

            public void onLoaded(View view) {
                MraidActivity.this.mMraidController.loadJavascript(JavaScriptWebViewCallbacks.WEB_VIEW_DID_APPEAR.getJavascript());
            }

            public void onFailedToLoad() {
                MoPubLog.d((String)"MraidActivity failed to load. Finishing the activity");
                if (MraidActivity.this.getBroadcastIdentifier() != null) {
                    EventForwardingBroadcastReceiver.broadcastAction((Context)MraidActivity.this, (long)MraidActivity.this.getBroadcastIdentifier(), (String)"com.mopub.action.interstitial.fail");
                }
                MraidActivity.this.finish();
            }

            public void onClose() {
                MraidActivity.this.mMraidController.loadJavascript(JavaScriptWebViewCallbacks.WEB_VIEW_DID_CLOSE.getJavascript());
                MraidActivity.this.finish();
            }

            public void onExpand() {
            }

            public void onOpen() {
                if (MraidActivity.this.getBroadcastIdentifier() != null) {
                    EventForwardingBroadcastReceiver.broadcastAction((Context)MraidActivity.this, (long)MraidActivity.this.getBroadcastIdentifier(), (String)"com.mopub.action.interstitial.click");
                }
            }
        });
        this.mMraidController.setUseCustomCloseListener(new MraidController.UseCustomCloseListener(){

            public void useCustomCloseChanged(boolean useCustomClose) {
                if (useCustomClose) {
                    MraidActivity.this.hideInterstitialCloseButton();
                } else {
                    MraidActivity.this.showInterstitialCloseButton();
                }
            }
        });
        this.mMraidController.fillContent(this.getBroadcastIdentifier(), htmlData, new MraidController.MraidWebViewCacheListener(){

            public void onReady(@NonNull MraidBridge.MraidWebView webView, @Nullable ExternalViewabilitySessionManager viewabilityManager) {
                if (viewabilityManager != null) {
                    MraidActivity.this.mExternalViewabilitySessionManager = viewabilityManager;
                } else {
                    MraidActivity.this.mExternalViewabilitySessionManager = new ExternalViewabilitySessionManager((Context)MraidActivity.this);
                    MraidActivity.this.mExternalViewabilitySessionManager.createDisplaySession((Context)MraidActivity.this, (WebView)webView, true);
                }
            }
        });
        return this.mMraidController.getAdContainer();
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.mExternalViewabilitySessionManager != null) {
            this.mExternalViewabilitySessionManager.startDeferredDisplaySession((Activity)this);
        }
        if (this.getBroadcastIdentifier() != null) {
            EventForwardingBroadcastReceiver.broadcastAction((Context)this, (long)this.getBroadcastIdentifier(), (String)"com.mopub.action.interstitial.show");
        }
        this.getWindow().setFlags(0x1000000, 0x1000000);
    }

    protected void onPause() {
        if (this.mMraidController != null) {
            this.mMraidController.pause(this.isFinishing());
        }
        super.onPause();
    }

    protected void onResume() {
        super.onResume();
        if (this.mMraidController != null) {
            this.mMraidController.resume();
        }
    }

    @Override
    protected void onDestroy() {
        if (this.mExternalViewabilitySessionManager != null) {
            this.mExternalViewabilitySessionManager.endDisplaySession();
            this.mExternalViewabilitySessionManager = null;
        }
        if (this.mMraidController != null) {
            this.mMraidController.destroy();
        }
        if (this.getBroadcastIdentifier() != null) {
            EventForwardingBroadcastReceiver.broadcastAction((Context)this, (long)this.getBroadcastIdentifier(), (String)"com.mopub.action.interstitial.dismiss");
        }
        super.onDestroy();
    }

    @VisibleForTesting
    public void setDebugListener(@Nullable MraidWebViewDebugListener debugListener) {
        this.mDebugListener = debugListener;
        if (this.mMraidController != null) {
            this.mMraidController.setDebugListener(debugListener);
        }
    }
}

