/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.mopub.common.AdReport;
import com.mopub.common.CreativeOrientation;
import com.mopub.common.ExternalViewabilitySessionManager;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.DeviceUtils;
import com.mopub.common.util.JavaScriptWebViewCallbacks;
import com.mopub.mobileads.BaseInterstitialActivity;
import com.mopub.mobileads.BaseWebView;
import com.mopub.mobileads.CustomEventInterstitial;
import com.mopub.mobileads.EventForwardingBroadcastReceiver;
import com.mopub.mobileads.HtmlInterstitialWebView;
import com.mopub.mobileads.Interstitial;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.WebViewCacheService;
import com.mopub.mobileads.factories.HtmlInterstitialWebViewFactory;
import java.io.Serializable;

public class MoPubActivity
extends BaseInterstitialActivity {
    @Nullable
    private HtmlInterstitialWebView mHtmlInterstitialWebView;
    @Nullable
    private ExternalViewabilitySessionManager mExternalViewabilitySessionManager;

    public static void start(Context context, String htmlData, AdReport adReport, String clickthroughUrl, CreativeOrientation creativeOrientation, long broadcastIdentifier) {
        Intent intent = MoPubActivity.createIntent(context, htmlData, adReport, clickthroughUrl, creativeOrientation, broadcastIdentifier);
        try {
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException anfe) {
            Log.d((String)"MoPubActivity", (String)"MoPubActivity not found - did you declare it in AndroidManifest.xml?");
        }
    }

    static Intent createIntent(Context context, String htmlData, AdReport adReport, String clickthroughUrl, CreativeOrientation orientation, long broadcastIdentifier) {
        Intent intent = new Intent(context, MoPubActivity.class);
        intent.putExtra("html-response-body", htmlData);
        intent.putExtra("clickthrough-url", clickthroughUrl);
        intent.putExtra("broadcastIdentifier", broadcastIdentifier);
        intent.putExtra("mopub-intent-ad-report", (Serializable)adReport);
        intent.putExtra("com_mopub_orientation", (Serializable)orientation);
        intent.addFlags(0x10000000);
        return intent;
    }

    static void preRenderHtml(Interstitial baseInterstitial, Context context, AdReport adReport, final CustomEventInterstitial.CustomEventInterstitialListener customEventInterstitialListener, String htmlData, String clickthroughUrl, long broadcastIdentifier) {
        HtmlInterstitialWebView htmlInterstitialWebView = HtmlInterstitialWebViewFactory.create(context.getApplicationContext(), adReport, customEventInterstitialListener, clickthroughUrl);
        htmlInterstitialWebView.enablePlugins(false);
        htmlInterstitialWebView.enableJavascriptCaching();
        htmlInterstitialWebView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if ("mopub://finishLoad".equals(url)) {
                    customEventInterstitialListener.onInterstitialLoaded();
                } else if ("mopub://failLoad".equals(url)) {
                    customEventInterstitialListener.onInterstitialFailed(null);
                }
                return true;
            }
        });
        ExternalViewabilitySessionManager externalViewabilitySessionManager = new ExternalViewabilitySessionManager(context);
        externalViewabilitySessionManager.createDisplaySession(context, (WebView)htmlInterstitialWebView, true);
        htmlInterstitialWebView.loadHtmlResponse(htmlData);
        WebViewCacheService.storeWebViewConfig((Long)broadcastIdentifier, (Interstitial)baseInterstitial, (BaseWebView)htmlInterstitialWebView, (ExternalViewabilitySessionManager)externalViewabilitySessionManager);
    }

    @Override
    public View getAdView() {
        WebViewCacheService.Config config;
        Intent intent = this.getIntent();
        String clickthroughUrl = intent.getStringExtra("clickthrough-url");
        String htmlResponse = intent.getStringExtra("html-response-body");
        Long broadcastIdentifier = this.getBroadcastIdentifier();
        if (broadcastIdentifier != null && (config = WebViewCacheService.popWebViewConfig((Long)broadcastIdentifier)) != null && config.getWebView() instanceof HtmlInterstitialWebView) {
            this.mHtmlInterstitialWebView = (HtmlInterstitialWebView)config.getWebView();
            this.mHtmlInterstitialWebView.init(new BroadcastingInterstitialListener(), clickthroughUrl, this.mAdReport != null ? this.mAdReport.getDspCreativeId() : null);
            this.mHtmlInterstitialWebView.enablePlugins(true);
            this.mHtmlInterstitialWebView.loadUrl(JavaScriptWebViewCallbacks.WEB_VIEW_DID_APPEAR.getUrl());
            this.mExternalViewabilitySessionManager = config.getViewabilityManager();
            return this.mHtmlInterstitialWebView;
        }
        MoPubLog.d((String)"WebView cache miss. Recreating the WebView.");
        this.mHtmlInterstitialWebView = HtmlInterstitialWebViewFactory.create(this.getApplicationContext(), this.mAdReport, new BroadcastingInterstitialListener(), clickthroughUrl);
        this.mExternalViewabilitySessionManager = new ExternalViewabilitySessionManager((Context)this);
        this.mExternalViewabilitySessionManager.createDisplaySession((Context)this, (WebView)this.mHtmlInterstitialWebView, true);
        this.mHtmlInterstitialWebView.loadHtmlResponse(htmlResponse);
        return this.mHtmlInterstitialWebView;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Serializable orientationExtra = this.getIntent().getSerializableExtra("com_mopub_orientation");
        CreativeOrientation requestedOrientation = orientationExtra == null || !(orientationExtra instanceof CreativeOrientation) ? CreativeOrientation.UNDEFINED : (CreativeOrientation)orientationExtra;
        DeviceUtils.lockOrientation((Activity)this, (CreativeOrientation)requestedOrientation);
        if (this.mExternalViewabilitySessionManager != null) {
            this.mExternalViewabilitySessionManager.startDeferredDisplaySession((Activity)this);
        }
        EventForwardingBroadcastReceiver.broadcastAction((Context)this, (long)this.getBroadcastIdentifier(), (String)"com.mopub.action.interstitial.show");
    }

    @Override
    protected void onDestroy() {
        if (this.mExternalViewabilitySessionManager != null) {
            this.mExternalViewabilitySessionManager.endDisplaySession();
            this.mExternalViewabilitySessionManager = null;
        }
        if (this.mHtmlInterstitialWebView != null) {
            this.mHtmlInterstitialWebView.loadUrl(JavaScriptWebViewCallbacks.WEB_VIEW_DID_CLOSE.getUrl());
            this.mHtmlInterstitialWebView.destroy();
        }
        EventForwardingBroadcastReceiver.broadcastAction((Context)this, (long)this.getBroadcastIdentifier(), (String)"com.mopub.action.interstitial.dismiss");
        super.onDestroy();
    }

    class BroadcastingInterstitialListener
    implements CustomEventInterstitial.CustomEventInterstitialListener {
        BroadcastingInterstitialListener() {
        }

        @Override
        public void onInterstitialLoaded() {
            if (MoPubActivity.this.mHtmlInterstitialWebView != null) {
                MoPubActivity.this.mHtmlInterstitialWebView.loadUrl(JavaScriptWebViewCallbacks.WEB_VIEW_DID_APPEAR.getUrl());
            }
        }

        @Override
        public void onInterstitialFailed(MoPubErrorCode errorCode) {
            EventForwardingBroadcastReceiver.broadcastAction((Context)MoPubActivity.this, (long)MoPubActivity.this.getBroadcastIdentifier(), (String)"com.mopub.action.interstitial.fail");
            MoPubActivity.this.finish();
        }

        @Override
        public void onInterstitialShown() {
        }

        @Override
        public void onInterstitialClicked() {
            EventForwardingBroadcastReceiver.broadcastAction((Context)MoPubActivity.this, (long)MoPubActivity.this.getBroadcastIdentifier(), (String)"com.mopub.action.interstitial.click");
        }

        @Override
        public void onInterstitialImpression() {
        }

        @Override
        public void onLeaveApplication() {
        }

        @Override
        public void onInterstitialDismissed() {
        }
    }
}

