/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.BroadcastReceiver;
import android.content.Context;
import com.mopub.common.AdReport;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.CustomEventInterstitial;
import com.mopub.mobileads.EventForwardingBroadcastReceiver;
import com.mopub.mobileads.MoPubErrorCode;
import java.util.Map;

public abstract class ResponseBodyInterstitial
extends CustomEventInterstitial {
    private EventForwardingBroadcastReceiver mBroadcastReceiver;
    protected Context mContext;
    protected AdReport mAdReport;
    protected long mBroadcastIdentifier;

    protected abstract void extractExtras(Map<String, String> var1);

    protected abstract void preRenderHtml(CustomEventInterstitial.CustomEventInterstitialListener var1);

    @Override
    public abstract void showInterstitial();

    @Override
    public void loadInterstitial(Context context, CustomEventInterstitial.CustomEventInterstitialListener customEventInterstitialListener, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        this.mContext = context;
        if (!this.extrasAreValid(serverExtras)) {
            customEventInterstitialListener.onInterstitialFailed(MoPubErrorCode.NETWORK_INVALID_STATE);
            return;
        }
        this.extractExtras(serverExtras);
        try {
            this.mAdReport = (AdReport)localExtras.get("mopub-intent-ad-report");
            Long boxedBroadcastId = (Long)localExtras.get("broadcastIdentifier");
            if (boxedBroadcastId == null) {
                MoPubLog.e((String)"Broadcast Identifier was not set in localExtras");
                customEventInterstitialListener.onInterstitialFailed(MoPubErrorCode.INTERNAL_ERROR);
                return;
            }
            this.mBroadcastIdentifier = boxedBroadcastId;
        }
        catch (ClassCastException e) {
            MoPubLog.e((String)"LocalExtras contained an incorrect type.");
            customEventInterstitialListener.onInterstitialFailed(MoPubErrorCode.INTERNAL_ERROR);
            return;
        }
        this.mBroadcastReceiver = new EventForwardingBroadcastReceiver(customEventInterstitialListener, this.mBroadcastIdentifier);
        this.mBroadcastReceiver.register((BroadcastReceiver)this.mBroadcastReceiver, context);
        this.preRenderHtml(customEventInterstitialListener);
    }

    @Override
    public void onInvalidate() {
        if (this.mBroadcastReceiver != null) {
            this.mBroadcastReceiver.unregister((BroadcastReceiver)this.mBroadcastReceiver);
        }
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("Html-Response-Body");
    }
}

