/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.Context;
import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mopub.common.AdFormat;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.CustomEventInterstitialAdapter;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MoPubView;
import com.mopub.mobileads.factories.CustomEventInterstitialAdapterFactory;
import java.util.Map;

public class MoPubInterstitial
implements CustomEventInterstitialAdapter.CustomEventInterstitialAdapterListener {
    @NonNull
    private MoPubInterstitialView mInterstitialView;
    @Nullable
    private CustomEventInterstitialAdapter mCustomEventInterstitialAdapter;
    @Nullable
    private InterstitialAdListener mInterstitialAdListener;
    @NonNull
    private Activity mActivity;
    @NonNull
    private volatile InterstitialState mCurrentInterstitialState;

    public MoPubInterstitial(@NonNull Activity activity, @NonNull String adUnitId) {
        this.mActivity = activity;
        this.mInterstitialView = new MoPubInterstitialView((Context)this.mActivity);
        this.mInterstitialView.setAdUnitId(adUnitId);
        this.mCurrentInterstitialState = InterstitialState.IDLE;
    }

    private boolean attemptStateTransition(@NonNull InterstitialState endState) {
        return this.attemptStateTransition(endState, false);
    }

    @VisibleForTesting
    synchronized boolean attemptStateTransition(@NonNull InterstitialState endState, boolean forceRefresh) {
        Preconditions.checkNotNull((Object)((Object)endState));
        InterstitialState startState = this.mCurrentInterstitialState;
        switch (startState) {
            case IDLE: {
                switch (endState) {
                    case LOADING: {
                        this.invalidateInterstitialAdapter();
                        this.mCurrentInterstitialState = InterstitialState.LOADING;
                        if (forceRefresh) {
                            this.mInterstitialView.forceRefresh();
                        } else {
                            this.mInterstitialView.loadAd();
                        }
                        return true;
                    }
                    case SHOWING: {
                        MoPubLog.d((String)"No interstitial loading or loaded.");
                        return false;
                    }
                    case DESTROYED: {
                        this.setInterstitialStateDestroyed();
                        return true;
                    }
                }
                return false;
            }
            case LOADING: {
                switch (endState) {
                    case IDLE: {
                        this.invalidateInterstitialAdapter();
                        this.mCurrentInterstitialState = InterstitialState.IDLE;
                        return true;
                    }
                    case LOADING: {
                        if (!forceRefresh) {
                            MoPubLog.d((String)"Already loading an interstitial.");
                        }
                        return false;
                    }
                    case READY: {
                        this.mCurrentInterstitialState = InterstitialState.READY;
                        return true;
                    }
                    case SHOWING: {
                        MoPubLog.d((String)"Interstitial is not ready to be shown yet.");
                        return false;
                    }
                    case DESTROYED: {
                        this.setInterstitialStateDestroyed();
                        return true;
                    }
                }
                return false;
            }
            case READY: {
                switch (endState) {
                    case IDLE: {
                        if (forceRefresh) {
                            this.invalidateInterstitialAdapter();
                            this.mCurrentInterstitialState = InterstitialState.IDLE;
                            return true;
                        }
                        return false;
                    }
                    case LOADING: {
                        MoPubLog.d((String)"Interstitial already loaded. Not loading another.");
                        if (this.mInterstitialAdListener != null) {
                            this.mInterstitialAdListener.onInterstitialLoaded(this);
                        }
                        return false;
                    }
                    case SHOWING: {
                        this.showCustomEventInterstitial();
                        this.mCurrentInterstitialState = InterstitialState.SHOWING;
                        return true;
                    }
                    case DESTROYED: {
                        this.setInterstitialStateDestroyed();
                        return true;
                    }
                }
                return false;
            }
            case SHOWING: {
                switch (endState) {
                    case IDLE: {
                        if (forceRefresh) {
                            MoPubLog.d((String)"Cannot force refresh while showing an interstitial.");
                            return false;
                        }
                        this.invalidateInterstitialAdapter();
                        this.mCurrentInterstitialState = InterstitialState.IDLE;
                        return true;
                    }
                    case LOADING: {
                        if (!forceRefresh) {
                            MoPubLog.d((String)"Interstitial already showing. Not loading another.");
                        }
                        return false;
                    }
                    case SHOWING: {
                        MoPubLog.d((String)"Already showing an interstitial. Cannot show it again.");
                        return false;
                    }
                    case DESTROYED: {
                        this.setInterstitialStateDestroyed();
                        return true;
                    }
                }
                return false;
            }
            case DESTROYED: {
                MoPubLog.d((String)"MoPubInterstitial destroyed. Ignoring all requests.");
                return false;
            }
        }
        return false;
    }

    private void setInterstitialStateDestroyed() {
        this.invalidateInterstitialAdapter();
        this.mInterstitialView.setBannerAdListener(null);
        this.mInterstitialView.destroy();
        this.mCurrentInterstitialState = InterstitialState.DESTROYED;
    }

    public void load() {
        this.attemptStateTransition(InterstitialState.LOADING);
    }

    public boolean show() {
        return this.attemptStateTransition(InterstitialState.SHOWING);
    }

    public void forceRefresh() {
        this.attemptStateTransition(InterstitialState.IDLE, true);
        this.attemptStateTransition(InterstitialState.LOADING, true);
    }

    public boolean isReady() {
        return this.mCurrentInterstitialState == InterstitialState.READY;
    }

    boolean isDestroyed() {
        return this.mCurrentInterstitialState == InterstitialState.DESTROYED;
    }

    Integer getAdTimeoutDelay() {
        return this.mInterstitialView.getAdTimeoutDelay();
    }

    @NonNull
    MoPubInterstitialView getMoPubInterstitialView() {
        return this.mInterstitialView;
    }

    private void showCustomEventInterstitial() {
        if (this.mCustomEventInterstitialAdapter != null) {
            this.mCustomEventInterstitialAdapter.showInterstitial();
        }
    }

    private void invalidateInterstitialAdapter() {
        if (this.mCustomEventInterstitialAdapter != null) {
            this.mCustomEventInterstitialAdapter.invalidate();
            this.mCustomEventInterstitialAdapter = null;
        }
    }

    public void setKeywords(@Nullable String keywords) {
        this.mInterstitialView.setKeywords(keywords);
    }

    @Nullable
    public String getKeywords() {
        return this.mInterstitialView.getKeywords();
    }

    @NonNull
    public Activity getActivity() {
        return this.mActivity;
    }

    @Nullable
    public Location getLocation() {
        return this.mInterstitialView.getLocation();
    }

    public void destroy() {
        this.attemptStateTransition(InterstitialState.DESTROYED);
    }

    public void setInterstitialAdListener(@Nullable InterstitialAdListener listener) {
        this.mInterstitialAdListener = listener;
    }

    @Nullable
    public InterstitialAdListener getInterstitialAdListener() {
        return this.mInterstitialAdListener;
    }

    public void setTesting(boolean testing) {
        this.mInterstitialView.setTesting(testing);
    }

    public boolean getTesting() {
        return this.mInterstitialView.getTesting();
    }

    public void setLocalExtras(Map<String, Object> extras) {
        this.mInterstitialView.setLocalExtras(extras);
    }

    @NonNull
    public Map<String, Object> getLocalExtras() {
        return this.mInterstitialView.getLocalExtras();
    }

    @Override
    public void onCustomEventInterstitialLoaded() {
        if (this.isDestroyed()) {
            return;
        }
        this.attemptStateTransition(InterstitialState.READY);
        if (this.mInterstitialAdListener != null) {
            this.mInterstitialAdListener.onInterstitialLoaded(this);
        }
    }

    @Override
    public void onCustomEventInterstitialFailed(@NonNull MoPubErrorCode errorCode) {
        if (this.isDestroyed()) {
            return;
        }
        if (!this.mInterstitialView.loadFailUrl(errorCode)) {
            this.attemptStateTransition(InterstitialState.IDLE);
        }
    }

    @Override
    public void onCustomEventInterstitialShown() {
        if (this.isDestroyed()) {
            return;
        }
        this.mInterstitialView.trackImpression();
        if (this.mInterstitialAdListener != null) {
            this.mInterstitialAdListener.onInterstitialShown(this);
        }
    }

    @Override
    public void onCustomEventInterstitialClicked() {
        if (this.isDestroyed()) {
            return;
        }
        this.mInterstitialView.registerClick();
        if (this.mInterstitialAdListener != null) {
            this.mInterstitialAdListener.onInterstitialClicked(this);
        }
    }

    @Override
    public void onCustomEventInterstitialDismissed() {
        if (this.isDestroyed()) {
            return;
        }
        this.attemptStateTransition(InterstitialState.IDLE);
        if (this.mInterstitialAdListener != null) {
            this.mInterstitialAdListener.onInterstitialDismissed(this);
        }
    }

    @Deprecated
    @VisibleForTesting
    void setInterstitialView(@NonNull MoPubInterstitialView interstitialView) {
        this.mInterstitialView = interstitialView;
    }

    @Deprecated
    @VisibleForTesting
    void setCurrentInterstitialState(@NonNull InterstitialState interstitialState) {
        this.mCurrentInterstitialState = interstitialState;
    }

    @Deprecated
    @VisibleForTesting
    @NonNull
    InterstitialState getCurrentInterstitialState() {
        return this.mCurrentInterstitialState;
    }

    @Deprecated
    @VisibleForTesting
    void setCustomEventInterstitialAdapter(@NonNull CustomEventInterstitialAdapter customEventInterstitialAdapter) {
        this.mCustomEventInterstitialAdapter = customEventInterstitialAdapter;
    }

    public class MoPubInterstitialView
    extends MoPubView {
        public MoPubInterstitialView(Context context) {
            super(context);
            this.setAutorefreshEnabled(false);
        }

        public AdFormat getAdFormat() {
            return AdFormat.INTERSTITIAL;
        }

        protected void loadCustomEvent(String customEventClassName, Map<String, String> serverExtras) {
            if (this.mAdViewController == null) {
                return;
            }
            if (TextUtils.isEmpty((CharSequence)customEventClassName)) {
                MoPubLog.d((String)"Couldn't invoke custom event because the server did not specify one.");
                this.loadFailUrl(MoPubErrorCode.ADAPTER_NOT_FOUND);
                return;
            }
            if (MoPubInterstitial.this.mCustomEventInterstitialAdapter != null) {
                MoPubInterstitial.this.mCustomEventInterstitialAdapter.invalidate();
            }
            MoPubLog.d((String)"Loading custom event interstitial adapter.");
            MoPubInterstitial.this.mCustomEventInterstitialAdapter = CustomEventInterstitialAdapterFactory.create(MoPubInterstitial.this, customEventClassName, serverExtras, this.mAdViewController.getBroadcastIdentifier(), this.mAdViewController.getAdReport());
            MoPubInterstitial.this.mCustomEventInterstitialAdapter.setAdapterListener(MoPubInterstitial.this);
            MoPubInterstitial.this.mCustomEventInterstitialAdapter.loadInterstitial();
        }

        protected void trackImpression() {
            MoPubLog.d((String)"Tracking impression for interstitial.");
            if (this.mAdViewController != null) {
                this.mAdViewController.trackImpression();
            }
        }

        protected void adFailed(MoPubErrorCode errorCode) {
            MoPubInterstitial.this.attemptStateTransition(InterstitialState.IDLE);
            if (MoPubInterstitial.this.mInterstitialAdListener != null) {
                MoPubInterstitial.this.mInterstitialAdListener.onInterstitialFailed(MoPubInterstitial.this, errorCode);
            }
        }
    }

    public static interface InterstitialAdListener {
        public void onInterstitialLoaded(MoPubInterstitial var1);

        public void onInterstitialFailed(MoPubInterstitial var1, MoPubErrorCode var2);

        public void onInterstitialShown(MoPubInterstitial var1);

        public void onInterstitialClicked(MoPubInterstitial var1);

        public void onInterstitialDismissed(MoPubInterstitial var1);
    }

    @VisibleForTesting
    static enum InterstitialState {
        IDLE,
        LOADING,
        READY,
        SHOWING,
        DESTROYED;

    }
}

