/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.mopub.common.AdReport;
import com.mopub.common.CreativeOrientation;
import com.mopub.common.util.DeviceUtils;
import com.mopub.mobileads.BaseInterstitialActivity;
import com.mopub.mobileads.CustomEventInterstitial;
import com.mopub.mobileads.EventForwardingBroadcastReceiver;
import com.mopub.mobileads.HtmlInterstitialWebView;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.factories.HtmlInterstitialWebViewFactory;
import java.io.Serializable;

public class MoPubActivity
extends BaseInterstitialActivity {
    private HtmlInterstitialWebView mHtmlInterstitialWebView;

    public static void start(Context context, String htmlData, AdReport adReport, boolean isScrollable, String redirectUrl, String clickthroughUrl, CreativeOrientation creativeOrientation, long broadcastIdentifier) {
        Intent intent = MoPubActivity.createIntent(context, htmlData, adReport, isScrollable, redirectUrl, clickthroughUrl, creativeOrientation, broadcastIdentifier);
        try {
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException anfe) {
            Log.d((String)"MoPubActivity", (String)"MoPubActivity not found - did you declare it in AndroidManifest.xml?");
        }
    }

    static Intent createIntent(Context context, String htmlData, AdReport adReport, boolean isScrollable, String redirectUrl, String clickthroughUrl, CreativeOrientation orientation, long broadcastIdentifier) {
        Intent intent = new Intent(context, MoPubActivity.class);
        intent.putExtra("Html-Response-Body", htmlData);
        intent.putExtra("Scrollable", isScrollable);
        intent.putExtra("Clickthrough-Url", clickthroughUrl);
        intent.putExtra("Redirect-Url", redirectUrl);
        intent.putExtra("broadcastIdentifier", broadcastIdentifier);
        intent.putExtra("mopub-intent-ad-report", (Serializable)adReport);
        intent.putExtra("com_mopub_orientation", (Serializable)orientation);
        intent.addFlags(0x10000000);
        return intent;
    }

    static void preRenderHtml(Context context, AdReport adReport, final CustomEventInterstitial.CustomEventInterstitialListener customEventInterstitialListener, String htmlData) {
        HtmlInterstitialWebView dummyWebView = HtmlInterstitialWebViewFactory.create(context, adReport, customEventInterstitialListener, false, null, null);
        dummyWebView.enablePlugins(false);
        dummyWebView.enableJavascriptCaching();
        dummyWebView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if ("mopub://finishLoad".equals(url)) {
                    customEventInterstitialListener.onInterstitialLoaded();
                } else if ("mopub://failLoad".equals(url)) {
                    customEventInterstitialListener.onInterstitialFailed(null);
                }
                return true;
            }
        });
        dummyWebView.loadHtmlResponse(htmlData);
    }

    @Override
    public View getAdView() {
        Intent intent = this.getIntent();
        boolean isScrollable = intent.getBooleanExtra("Scrollable", false);
        String redirectUrl = intent.getStringExtra("Redirect-Url");
        String clickthroughUrl = intent.getStringExtra("Clickthrough-Url");
        String htmlResponse = intent.getStringExtra("Html-Response-Body");
        this.mHtmlInterstitialWebView = HtmlInterstitialWebViewFactory.create(this.getApplicationContext(), this.mAdReport, new BroadcastingInterstitialListener(), isScrollable, redirectUrl, clickthroughUrl);
        this.mHtmlInterstitialWebView.loadHtmlResponse(htmlResponse);
        return this.mHtmlInterstitialWebView;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Serializable orientationExtra = this.getIntent().getSerializableExtra("com_mopub_orientation");
        CreativeOrientation requestedOrientation = orientationExtra == null || !(orientationExtra instanceof CreativeOrientation) ? CreativeOrientation.UNDEFINED : (CreativeOrientation)orientationExtra;
        DeviceUtils.lockOrientation((Activity)this, (CreativeOrientation)requestedOrientation);
        EventForwardingBroadcastReceiver.broadcastAction((Context)this, (long)this.getBroadcastIdentifier(), (String)"com.mopub.action.interstitial.show");
    }

    @Override
    protected void onDestroy() {
        this.mHtmlInterstitialWebView.loadUrl(BaseInterstitialActivity.JavaScriptWebViewCallbacks.WEB_VIEW_DID_CLOSE.getUrl());
        this.mHtmlInterstitialWebView.destroy();
        EventForwardingBroadcastReceiver.broadcastAction((Context)this, (long)this.getBroadcastIdentifier(), (String)"com.mopub.action.interstitial.dismiss");
        super.onDestroy();
    }

    class BroadcastingInterstitialListener
    implements CustomEventInterstitial.CustomEventInterstitialListener {
        BroadcastingInterstitialListener() {
        }

        @Override
        public void onInterstitialLoaded() {
            MoPubActivity.this.mHtmlInterstitialWebView.loadUrl(BaseInterstitialActivity.JavaScriptWebViewCallbacks.WEB_VIEW_DID_APPEAR.getUrl());
        }

        @Override
        public void onInterstitialFailed(MoPubErrorCode errorCode) {
            EventForwardingBroadcastReceiver.broadcastAction((Context)MoPubActivity.this, (long)MoPubActivity.this.getBroadcastIdentifier(), (String)"com.mopub.action.interstitial.fail");
            MoPubActivity.this.finish();
        }

        @Override
        public void onInterstitialShown() {
        }

        @Override
        public void onInterstitialClicked() {
            EventForwardingBroadcastReceiver.broadcastAction((Context)MoPubActivity.this, (long)MoPubActivity.this.getBroadcastIdentifier(), (String)"com.mopub.action.interstitial.click");
        }

        @Override
        public void onLeaveApplication() {
        }

        @Override
        public void onInterstitialDismissed() {
        }
    }
}

