/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import com.mopub.mobileads.BaseBroadcastReceiver;
import com.mopub.mobileads.CustomEventInterstitial;
import com.mopub.mobileads.MoPubErrorCode;

public class EventForwardingBroadcastReceiver
extends BaseBroadcastReceiver {
    private final CustomEventInterstitial.CustomEventInterstitialListener mCustomEventInterstitialListener;
    private static IntentFilter sIntentFilter;

    public EventForwardingBroadcastReceiver(CustomEventInterstitial.CustomEventInterstitialListener customEventInterstitialListener, long broadcastIdentifier) {
        super(broadcastIdentifier);
        this.mCustomEventInterstitialListener = customEventInterstitialListener;
        this.getIntentFilter();
    }

    @NonNull
    public IntentFilter getIntentFilter() {
        if (sIntentFilter == null) {
            sIntentFilter = new IntentFilter();
            sIntentFilter.addAction("com.mopub.action.interstitial.fail");
            sIntentFilter.addAction("com.mopub.action.interstitial.show");
            sIntentFilter.addAction("com.mopub.action.interstitial.dismiss");
            sIntentFilter.addAction("com.mopub.action.interstitial.click");
        }
        return sIntentFilter;
    }

    public void onReceive(Context context, Intent intent) {
        if (this.mCustomEventInterstitialListener == null) {
            return;
        }
        if (!this.shouldConsumeBroadcast(intent)) {
            return;
        }
        String action = intent.getAction();
        if ("com.mopub.action.interstitial.fail".equals(action)) {
            this.mCustomEventInterstitialListener.onInterstitialFailed(MoPubErrorCode.NETWORK_INVALID_STATE);
        } else if ("com.mopub.action.interstitial.show".equals(action)) {
            this.mCustomEventInterstitialListener.onInterstitialShown();
        } else if ("com.mopub.action.interstitial.dismiss".equals(action)) {
            this.mCustomEventInterstitialListener.onInterstitialDismissed();
            this.unregister((BroadcastReceiver)this);
        } else if ("com.mopub.action.interstitial.click".equals(action)) {
            this.mCustomEventInterstitialListener.onInterstitialClicked();
        }
    }
}

