/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.network;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.LruCache;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.util.DeviceUtils;
import com.mopub.network.CustomSSLSocketFactory;
import com.mopub.network.MaxWidthImageLoader;
import com.mopub.network.MoPubRequestQueue;
import com.mopub.network.PlayServicesUrlRewriter;
import com.mopub.network.RequestQueueHttpStack;
import com.mopub.volley.Cache;
import com.mopub.volley.Network;
import com.mopub.volley.toolbox.BaseHttpStack;
import com.mopub.volley.toolbox.BasicNetwork;
import com.mopub.volley.toolbox.DiskBasedCache;
import com.mopub.volley.toolbox.HurlStack;
import com.mopub.volley.toolbox.ImageLoader;
import java.io.File;

public class Networking {
    @VisibleForTesting
    static final String CACHE_DIRECTORY_NAME = "mopub-volley-cache";
    private static final String DEFAULT_USER_AGENT = System.getProperty("http.agent");
    private static volatile MoPubRequestQueue sRequestQueue;
    private static volatile String sUserAgent;
    private static volatile MaxWidthImageLoader sMaxWidthImageLoader;
    private static boolean sUseHttps;
    private static HurlStack.UrlRewriter sUrlRewriter;

    @Nullable
    public static MoPubRequestQueue getRequestQueue() {
        return sRequestQueue;
    }

    @NonNull
    public static HurlStack.UrlRewriter getUrlRewriter(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        if (sUrlRewriter == null) {
            sUrlRewriter = new PlayServicesUrlRewriter();
        }
        return sUrlRewriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static MoPubRequestQueue getRequestQueue(@NonNull Context context) {
        MoPubRequestQueue requestQueue = sRequestQueue;
        if (requestQueue != null) return requestQueue;
        Class<Networking> clazz = Networking.class;
        synchronized (Networking.class) {
            requestQueue = sRequestQueue;
            if (requestQueue != null) return requestQueue;
            CustomSSLSocketFactory socketFactory = CustomSSLSocketFactory.getDefault(10000);
            String userAgent = Networking.getUserAgent(context.getApplicationContext());
            RequestQueueHttpStack httpStack = new RequestQueueHttpStack(userAgent, Networking.getUrlRewriter(context), socketFactory);
            BasicNetwork network = new BasicNetwork((BaseHttpStack)httpStack);
            File volleyCacheDir = new File(context.getCacheDir().getPath() + File.separator + CACHE_DIRECTORY_NAME);
            DiskBasedCache cache = new DiskBasedCache(volleyCacheDir, (int)DeviceUtils.diskCacheSizeBytes(volleyCacheDir, 0xA00000L));
            sRequestQueue = requestQueue = new MoPubRequestQueue((Cache)cache, (Network)network);
            requestQueue.start();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return requestQueue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static ImageLoader getImageLoader(@NonNull Context context) {
        MaxWidthImageLoader imageLoader = sMaxWidthImageLoader;
        if (imageLoader != null) return imageLoader;
        Class<Networking> clazz = Networking.class;
        synchronized (Networking.class) {
            imageLoader = sMaxWidthImageLoader;
            if (imageLoader != null) return imageLoader;
            MoPubRequestQueue queue = Networking.getRequestQueue(context);
            int cacheSize = DeviceUtils.memoryCacheSizeBytes(context);
            LruCache<String, Bitmap> imageCache = new LruCache<String, Bitmap>(cacheSize){

                protected int sizeOf(String key, Bitmap value) {
                    if (value != null) {
                        return value.getRowBytes() * value.getHeight();
                    }
                    return super.sizeOf((Object)key, (Object)value);
                }
            };
            sMaxWidthImageLoader = imageLoader = new MaxWidthImageLoader(queue, context, new ImageLoader.ImageCache((LruCache)imageCache){
                final /* synthetic */ LruCache val$imageCache;
                {
                    this.val$imageCache = lruCache;
                }

                public Bitmap getBitmap(String key) {
                    return (Bitmap)this.val$imageCache.get((Object)key);
                }

                public void putBitmap(String key, Bitmap bitmap) {
                    this.val$imageCache.put((Object)key, (Object)bitmap);
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return imageLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static String getUserAgent(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        String userAgent = sUserAgent;
        if (userAgent != null) return userAgent;
        Class<Networking> clazz = Networking.class;
        synchronized (Networking.class) {
            userAgent = sUserAgent;
            if (userAgent != null) return userAgent;
            try {
                userAgent = Build.VERSION.SDK_INT >= 17 ? WebSettings.getDefaultUserAgent((Context)context) : (Looper.myLooper() == Looper.getMainLooper() ? new WebView(context).getSettings().getUserAgentString() : DEFAULT_USER_AGENT);
            }
            catch (Exception e) {
                userAgent = DEFAULT_USER_AGENT;
            }
            sUserAgent = userAgent;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return userAgent;
        }
    }

    @NonNull
    public static String getCachedUserAgent() {
        String userAgent = sUserAgent;
        if (userAgent == null) {
            return DEFAULT_USER_AGENT;
        }
        return userAgent;
    }

    @VisibleForTesting
    public static synchronized void clearForTesting() {
        sRequestQueue = null;
        sMaxWidthImageLoader = null;
        sUserAgent = null;
    }

    @VisibleForTesting
    public static synchronized void setRequestQueueForTesting(MoPubRequestQueue queue) {
        sRequestQueue = queue;
    }

    @VisibleForTesting
    public static synchronized void setImageLoaderForTesting(MaxWidthImageLoader imageLoader) {
        sMaxWidthImageLoader = imageLoader;
    }

    @VisibleForTesting
    public static synchronized void setUserAgentForTesting(String userAgent) {
        sUserAgent = userAgent;
    }

    public static void useHttps(boolean useHttps) {
        sUseHttps = useHttps;
    }

    public static boolean shouldUseHttps() {
        return sUseHttps;
    }

    public static String getScheme() {
        return "https";
    }

    public static String getBaseUrlScheme() {
        return Networking.shouldUseHttps() ? "https" : "http";
    }

    static {
        sUseHttps = false;
    }
}

