/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.network;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mopub.common.AdFormat;
import com.mopub.common.ExternalViewabilitySessionManager;
import com.mopub.common.MoPub;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Json;
import com.mopub.common.util.ResponseHeader;
import com.mopub.mobileads.AdTypeTranslator;
import com.mopub.network.AdResponse;
import com.mopub.network.HeaderUtils;
import com.mopub.network.MoPubNetworkError;
import com.mopub.volley.NetworkResponse;
import com.mopub.volley.toolbox.HttpHeaderParser;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MultiAdResponse
implements Iterator<AdResponse> {
    @NonNull
    private final Iterator<AdResponse> mResponseIterator;
    @NonNull
    private String mFailUrl;
    @Nullable
    private static ServerOverrideListener sServerOverrideListener;

    @NonNull
    public String getFailURL() {
        return this.mFailUrl;
    }

    public MultiAdResponse(@NonNull Context appContext, @NonNull NetworkResponse networkResponse, @NonNull AdFormat adFormat, @Nullable String adUnitId) throws JSONException, MoPubNetworkError {
        String responseBody = MultiAdResponse.parseStringBody(networkResponse);
        JSONObject jsonObject = new JSONObject(responseBody);
        this.mFailUrl = jsonObject.optString(ResponseHeader.FAIL_URL.getKey());
        String requestId = jsonObject.optString(ResponseHeader.REQUEST_ID.getKey());
        boolean invalidateConsent = HeaderUtils.extractBooleanHeader(jsonObject, ResponseHeader.INVALIDATE_CONSENT, false);
        boolean forceExplicitNo = HeaderUtils.extractBooleanHeader(jsonObject, ResponseHeader.FORCE_EXPLICIT_NO, false);
        boolean reacquireConsent = HeaderUtils.extractBooleanHeader(jsonObject, ResponseHeader.REACQUIRE_CONSENT, false);
        String consentChangeReason = HeaderUtils.extractHeader(jsonObject, ResponseHeader.CONSENT_CHANGE_REASON);
        boolean forceGdprApplies = HeaderUtils.extractBooleanHeader(jsonObject, ResponseHeader.FORCE_GDPR_APPLIES, false);
        if (sServerOverrideListener != null) {
            if (forceGdprApplies) {
                sServerOverrideListener.onForceGdprApplies();
            }
            if (forceExplicitNo) {
                sServerOverrideListener.onForceExplicitNo(consentChangeReason);
            } else if (invalidateConsent) {
                sServerOverrideListener.onInvalidateConsent(consentChangeReason);
            } else if (reacquireConsent) {
                sServerOverrideListener.onReacquireConsent(consentChangeReason);
            }
        }
        JSONArray adResponses = jsonObject.getJSONArray(ResponseHeader.AD_RESPONSES.getKey());
        int ADS_PER_RESPONSE = 3;
        ArrayList<AdResponse> list = new ArrayList<AdResponse>(ADS_PER_RESPONSE);
        AdResponse adResponseClear = null;
        for (int i = 0; i < adResponses.length(); ++i) {
            try {
                JSONObject item = adResponses.getJSONObject(i);
                AdResponse singleAdResponse = MultiAdResponse.parseSingleAdResponse(appContext, networkResponse, item, adUnitId, adFormat, requestId);
                if (!"clear".equals(singleAdResponse.getAdType())) {
                    list.add(singleAdResponse);
                    continue;
                }
                this.mFailUrl = "";
                adResponseClear = singleAdResponse;
                if (!MultiAdResponse.extractWarmup(item)) break;
                throw new MoPubNetworkError("Server is preparing this Ad Unit.", MoPubNetworkError.Reason.WARMING_UP, adResponseClear.getRefreshTimeMillis());
            }
            catch (JSONException ex) {
                MoPubLog.w("Invalid response item. Body: " + responseBody);
                continue;
            }
            catch (MoPubNetworkError ex) {
                if (ex.getReason() == MoPubNetworkError.Reason.WARMING_UP) {
                    throw ex;
                }
                MoPubLog.w("Invalid response item. Error: " + (Object)((Object)ex.getReason()));
                continue;
            }
            catch (Exception ex) {
                MoPubLog.w("Unexpected error parsing response item. " + ex.getMessage());
            }
        }
        this.mResponseIterator = list.iterator();
        if (!this.mResponseIterator.hasNext()) {
            Integer refreshTimeMilliseconds = 30000;
            if (adResponseClear != null) {
                refreshTimeMilliseconds = adResponseClear.getRefreshTimeMillis();
            }
            throw new MoPubNetworkError("No ads found for ad unit.", MoPubNetworkError.Reason.NO_FILL, refreshTimeMilliseconds);
        }
    }

    @Override
    public boolean hasNext() {
        return this.mResponseIterator.hasNext();
    }

    @Override
    @NonNull
    public AdResponse next() {
        return this.mResponseIterator.next();
    }

    boolean isWaterfallFinished() {
        return TextUtils.isEmpty((CharSequence)this.mFailUrl);
    }

    public static void setServerOverrideListener(@NonNull ServerOverrideListener serverOverrideListener) {
        sServerOverrideListener = serverOverrideListener;
    }

    @NonNull
    protected static AdResponse parseSingleAdResponse(@NonNull Context appContext, @NonNull NetworkResponse networkResponse, @NonNull JSONObject jsonObject, @Nullable String adUnitId, @NonNull AdFormat adFormat, @Nullable String requestId) throws JSONException, MoPubNetworkError {
        ExternalViewabilitySessionManager.ViewabilityVendor disabledVendors;
        String disabledViewabilityVendors;
        String videoTrackers;
        Map<String, String> serverExtras;
        Preconditions.checkNotNull(appContext);
        Preconditions.checkNotNull(networkResponse);
        Preconditions.checkNotNull(jsonObject);
        Preconditions.checkNotNull((Object)adFormat);
        AdResponse.Builder builder = new AdResponse.Builder();
        String content = jsonObject.optString(ResponseHeader.CONTENT.getKey());
        JSONObject jsonHeaders = jsonObject.getJSONObject(ResponseHeader.METADATA.getKey());
        builder.setAdUnitId(adUnitId);
        builder.setResponseBody(content);
        String adTypeString = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.AD_TYPE);
        String fullAdTypeString = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.FULL_AD_TYPE);
        builder.setAdType(adTypeString);
        builder.setFullAdType(fullAdTypeString);
        Integer refreshTimeMilliseconds = MultiAdResponse.extractRefreshTimeMS(jsonObject);
        builder.setRefreshTimeMilliseconds(refreshTimeMilliseconds);
        if ("clear".equals(adTypeString)) {
            return builder.build();
        }
        String dspCreativeId = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.DSP_CREATIVE_ID);
        builder.setDspCreativeId(dspCreativeId);
        String networkType = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.NETWORK_TYPE);
        builder.setNetworkType(networkType);
        String clickTrackingUrl = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.CLICK_TRACKING_URL);
        builder.setClickTrackingUrl(clickTrackingUrl);
        List<String> impressionUrls = HeaderUtils.extractStringArray(jsonHeaders, ResponseHeader.IMPRESSION_URLS);
        if (impressionUrls.isEmpty()) {
            impressionUrls.add(HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.IMPRESSION_URL));
        }
        builder.setImpressionTrackingUrls(impressionUrls);
        builder.setBeforeLoadUrl(HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.BEFORE_LOAD_URL));
        List<String> afterLoadUrls = HeaderUtils.extractStringArray(jsonHeaders, ResponseHeader.AFTER_LOAD_URL);
        if (afterLoadUrls.isEmpty()) {
            afterLoadUrls.add(HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.AFTER_LOAD_URL));
        }
        builder.setAfterLoadUrls(afterLoadUrls);
        List<String> afterLoadSuccessUrls = HeaderUtils.extractStringArray(jsonHeaders, ResponseHeader.AFTER_LOAD_SUCCESS_URL);
        if (afterLoadSuccessUrls.isEmpty()) {
            afterLoadSuccessUrls.add(HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.AFTER_LOAD_SUCCESS_URL));
        }
        builder.setAfterLoadSuccessUrls(afterLoadSuccessUrls);
        List<String> afterLoadFailUrls = HeaderUtils.extractStringArray(jsonHeaders, ResponseHeader.AFTER_LOAD_FAIL_URL);
        if (afterLoadFailUrls.isEmpty()) {
            afterLoadFailUrls.add(HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.AFTER_LOAD_FAIL_URL));
        }
        builder.setAfterLoadFailUrls(afterLoadFailUrls);
        builder.setRequestId(requestId);
        Integer width = HeaderUtils.extractIntegerHeader(jsonHeaders, ResponseHeader.WIDTH);
        Integer height = HeaderUtils.extractIntegerHeader(jsonHeaders, ResponseHeader.HEIGHT);
        builder.setDimensions(width, height);
        Integer adTimeoutDelayMilliseconds = HeaderUtils.extractIntegerHeader(jsonHeaders, ResponseHeader.AD_TIMEOUT);
        builder.setAdTimeoutDelayMilliseconds(adTimeoutDelayMilliseconds);
        if ("json".equals(adTypeString) || "json_video".equals(adTypeString)) {
            try {
                builder.setJsonBody(new JSONObject(content));
            }
            catch (JSONException e) {
                throw new MoPubNetworkError("Failed to decode body JSON for native ad format", e, MoPubNetworkError.Reason.BAD_BODY);
            }
        }
        String customEventClassName = AdTypeTranslator.getCustomEventName(adFormat, adTypeString, fullAdTypeString, jsonHeaders);
        builder.setCustomEventClassName(customEventClassName);
        MoPub.BrowserAgent browserAgent = MoPub.BrowserAgent.fromHeader(HeaderUtils.extractIntegerHeader(jsonHeaders, ResponseHeader.BROWSER_AGENT));
        MoPub.setBrowserAgentFromAdServer(browserAgent);
        builder.setBrowserAgent(browserAgent);
        String customEventData = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.CUSTOM_EVENT_DATA);
        if (TextUtils.isEmpty((CharSequence)customEventData)) {
            customEventData = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.NATIVE_PARAMS);
        }
        try {
            serverExtras = Json.jsonStringToMap(customEventData);
        }
        catch (JSONException e) {
            throw new MoPubNetworkError("Failed to decode server extras for custom event data.", e, MoPubNetworkError.Reason.BAD_HEADER_DATA);
        }
        try {
            if (!jsonHeaders.optString("adm").isEmpty()) {
                serverExtras.put("adm", jsonHeaders.getString("adm"));
            }
        }
        catch (JSONException e) {
            throw new MoPubNetworkError("Failed to parse ADM for advanced bidding", e, MoPubNetworkError.Reason.BAD_BODY);
        }
        if (!TextUtils.isEmpty((CharSequence)clickTrackingUrl)) {
            serverExtras.put("clickthrough-url", clickTrackingUrl);
        }
        if (MultiAdResponse.eventDataIsInResponseBody(adTypeString, fullAdTypeString)) {
            serverExtras.put("html-response-body", content);
            serverExtras.put("com_mopub_orientation", HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.ORIENTATION));
        }
        if ("json".equals(adTypeString) || "json_video".equals(adTypeString)) {
            String impressionMinVisiblePercent = HeaderUtils.extractPercentHeaderString(jsonHeaders, ResponseHeader.IMPRESSION_MIN_VISIBLE_PERCENT);
            String impressionVisibleMS = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.IMPRESSION_VISIBLE_MS);
            String impressionMinVisiblePx = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.IMPRESSION_MIN_VISIBLE_PX);
            if (!TextUtils.isEmpty((CharSequence)impressionMinVisiblePercent)) {
                serverExtras.put("impression-min-visible-percent", impressionMinVisiblePercent);
            }
            if (!TextUtils.isEmpty((CharSequence)impressionVisibleMS)) {
                serverExtras.put("impression-visible-ms", impressionVisibleMS);
            }
            if (!TextUtils.isEmpty((CharSequence)impressionMinVisiblePx)) {
                serverExtras.put("impression-min-visible-px", impressionMinVisiblePx);
            }
        }
        if ("json_video".equals(adTypeString)) {
            serverExtras.put("play-visible-percent", HeaderUtils.extractPercentHeaderString(jsonHeaders, ResponseHeader.PLAY_VISIBLE_PERCENT));
            serverExtras.put("pause-visible-percent", HeaderUtils.extractPercentHeaderString(jsonHeaders, ResponseHeader.PAUSE_VISIBLE_PERCENT));
            serverExtras.put("max-buffer-ms", HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.MAX_BUFFER_MS));
        }
        if (!TextUtils.isEmpty((CharSequence)(videoTrackers = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.VIDEO_TRACKERS)))) {
            serverExtras.put("video-trackers", videoTrackers);
        }
        if ("rewarded_video".equals(adTypeString) || "interstitial".equals(adTypeString) && "vast".equals(fullAdTypeString)) {
            serverExtras.put("external-video-viewability-trackers", HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.VIDEO_VIEWABILITY_TRACKERS));
        }
        if (AdFormat.BANNER.equals((Object)adFormat)) {
            serverExtras.put("banner-impression-min-ms", HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.BANNER_IMPRESSION_MIN_VISIBLE_MS));
            serverExtras.put("banner-impression-min-pixels", HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.BANNER_IMPRESSION_MIN_VISIBLE_DIPS));
        }
        if (!TextUtils.isEmpty((CharSequence)(disabledViewabilityVendors = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.DISABLE_VIEWABILITY))) && (disabledVendors = ExternalViewabilitySessionManager.ViewabilityVendor.fromKey(disabledViewabilityVendors)) != null) {
            disabledVendors.disable();
        }
        builder.setServerExtras(serverExtras);
        if ("rewarded_video".equals(adTypeString) || "custom".equals(adTypeString) || "rewarded_playable".equals(adTypeString)) {
            String rewardedVideoCurrencyName = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.REWARDED_VIDEO_CURRENCY_NAME);
            String rewardedVideoCurrencyAmount = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.REWARDED_VIDEO_CURRENCY_AMOUNT);
            String rewardedCurrencies = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.REWARDED_CURRENCIES);
            String rewardedVideoCompletionUrl = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.REWARDED_VIDEO_COMPLETION_URL);
            Integer rewardedDuration = HeaderUtils.extractIntegerHeader(jsonHeaders, ResponseHeader.REWARDED_DURATION);
            boolean shouldRewardOnClick = HeaderUtils.extractBooleanHeader(jsonHeaders, ResponseHeader.SHOULD_REWARD_ON_CLICK, false);
            builder.setRewardedVideoCurrencyName(rewardedVideoCurrencyName);
            builder.setRewardedVideoCurrencyAmount(rewardedVideoCurrencyAmount);
            builder.setRewardedCurrencies(rewardedCurrencies);
            builder.setRewardedVideoCompletionUrl(rewardedVideoCompletionUrl);
            builder.setRewardedDuration(rewardedDuration);
            builder.setShouldRewardOnClick(shouldRewardOnClick);
        }
        return builder.build();
    }

    @Nullable
    private static Integer extractRefreshTimeMS(@NonNull JSONObject item) throws JSONException {
        Preconditions.checkNotNull(item);
        JSONObject jsonHeaders = item.getJSONObject(ResponseHeader.METADATA.getKey());
        Integer refreshTimeSeconds = HeaderUtils.extractIntegerHeader(jsonHeaders, ResponseHeader.REFRESH_TIME);
        return refreshTimeSeconds == null ? null : Integer.valueOf(refreshTimeSeconds * 1000);
    }

    private static boolean extractWarmup(@NonNull JSONObject item) {
        Preconditions.checkNotNull(item);
        JSONObject jsonHeaders = item.optJSONObject(ResponseHeader.METADATA.getKey());
        return HeaderUtils.extractBooleanHeader(jsonHeaders, ResponseHeader.WARMUP, false);
    }

    private static String parseStringBody(@NonNull NetworkResponse response) {
        String parsed;
        Preconditions.checkNotNull(response);
        try {
            parsed = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers));
        }
        catch (UnsupportedEncodingException e) {
            parsed = new String(response.data);
        }
        return parsed;
    }

    private static boolean eventDataIsInResponseBody(@Nullable String adType, @Nullable String fullAdType) {
        return "mraid".equals(adType) || "html".equals(adType) || "interstitial".equals(adType) && "vast".equals(fullAdType) || "rewarded_video".equals(adType) && "vast".equals(fullAdType) || "rewarded_playable".equals(adType);
    }

    public static interface ServerOverrideListener {
        public void onForceExplicitNo(@Nullable String var1);

        public void onInvalidateConsent(@Nullable String var1);

        public void onReacquireConsent(@Nullable String var1);

        public void onForceGdprApplies();
    }
}

