/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.network;

import android.os.Handler;
import android.support.annotation.NonNull;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.volley.Cache;
import com.mopub.volley.Network;
import com.mopub.volley.Request;
import com.mopub.volley.RequestQueue;
import com.mopub.volley.ResponseDelivery;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MoPubRequestQueue
extends RequestQueue {
    private static final int CAPACITY = 10;
    @NonNull
    private final Map<Request<?>, DelayedRequestHelper> mDelayedRequests = new HashMap(10);

    MoPubRequestQueue(Cache cache, Network network, int threadPoolSize, ResponseDelivery delivery) {
        super(cache, network, threadPoolSize, delivery);
    }

    MoPubRequestQueue(Cache cache, Network network, int threadPoolSize) {
        super(cache, network, threadPoolSize);
    }

    MoPubRequestQueue(Cache cache, Network network) {
        super(cache, network);
    }

    public void addDelayedRequest(@NonNull Request<?> request, int delayMs) {
        Preconditions.checkNotNull(request);
        this.addDelayedRequest(request, new DelayedRequestHelper(request, delayMs));
    }

    @VisibleForTesting
    void addDelayedRequest(@NonNull Request<?> request, @NonNull DelayedRequestHelper delayedRequestHelper) {
        Preconditions.checkNotNull(delayedRequestHelper);
        if (this.mDelayedRequests.containsKey(request)) {
            this.cancel(request);
        }
        delayedRequestHelper.start();
        this.mDelayedRequests.put(request, delayedRequestHelper);
    }

    public void cancelAll(@NonNull RequestQueue.RequestFilter filter) {
        Preconditions.checkNotNull(filter);
        super.cancelAll(filter);
        Iterator<Map.Entry<Request<?>, DelayedRequestHelper>> iterator = this.mDelayedRequests.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Request<?>, DelayedRequestHelper> entry = iterator.next();
            if (!filter.apply(entry.getKey())) continue;
            entry.getKey().cancel();
            entry.getValue().cancel();
            iterator.remove();
        }
    }

    public void cancelAll(final @NonNull Object tag) {
        Preconditions.checkNotNull(tag);
        super.cancelAll(tag);
        this.cancelAll(new RequestQueue.RequestFilter(){

            public boolean apply(Request<?> request) {
                return request.getTag() == tag;
            }
        });
    }

    public void cancel(final @NonNull Request<?> request) {
        Preconditions.checkNotNull(request);
        this.cancelAll(new RequestQueue.RequestFilter(){

            public boolean apply(Request<?> _request) {
                return request == _request;
            }
        });
    }

    @Deprecated
    @NonNull
    @VisibleForTesting
    Map<Request<?>, DelayedRequestHelper> getDelayedRequests() {
        return this.mDelayedRequests;
    }

    class DelayedRequestHelper {
        final int mDelayMs;
        @NonNull
        final Handler mHandler;
        @NonNull
        final Runnable mDelayedRunnable;

        DelayedRequestHelper(Request<?> request, int delayMs) {
            this(request, delayMs, new Handler());
        }

        @VisibleForTesting
        DelayedRequestHelper(final Request<?> request, @NonNull int delayMs, Handler handler) {
            this.mDelayMs = delayMs;
            this.mHandler = handler;
            this.mDelayedRunnable = new Runnable(){

                @Override
                public void run() {
                    MoPubRequestQueue.this.mDelayedRequests.remove(request);
                    MoPubRequestQueue.this.add(request);
                }
            };
        }

        void start() {
            this.mHandler.postDelayed(this.mDelayedRunnable, (long)this.mDelayMs);
        }

        void cancel() {
            this.mHandler.removeCallbacks(this.mDelayedRunnable);
        }
    }
}

