/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.network;

import android.net.SSLCertificateSocketFactory;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Reflection;
import com.mopub.network.InetAddressUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class CustomSSLSocketFactory
extends SSLSocketFactory {
    @Nullable
    private SSLSocketFactory mCertificateSocketFactory;

    private CustomSSLSocketFactory() {
    }

    @NonNull
    public static CustomSSLSocketFactory getDefault(int handshakeTimeoutMillis) {
        CustomSSLSocketFactory factory = new CustomSSLSocketFactory();
        factory.mCertificateSocketFactory = SSLCertificateSocketFactory.getDefault((int)handshakeTimeoutMillis, null);
        return factory;
    }

    @Override
    public Socket createSocket() throws IOException {
        if (this.mCertificateSocketFactory == null) {
            throw new SocketException("SSLSocketFactory was null. Unable to create socket.");
        }
        Socket socket = this.mCertificateSocketFactory.createSocket();
        this.enableTlsIfAvailable(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int i) throws IOException, UnknownHostException {
        if (this.mCertificateSocketFactory == null) {
            throw new SocketException("SSLSocketFactory was null. Unable to create socket.");
        }
        Socket socket = this.mCertificateSocketFactory.createSocket(host, i);
        this.enableTlsIfAvailable(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localhost, int localPort) throws IOException, UnknownHostException {
        if (this.mCertificateSocketFactory == null) {
            throw new SocketException("SSLSocketFactory was null. Unable to create socket.");
        }
        Socket socket = this.mCertificateSocketFactory.createSocket(host, port, localhost, localPort);
        this.enableTlsIfAvailable(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        if (this.mCertificateSocketFactory == null) {
            throw new SocketException("SSLSocketFactory was null. Unable to create socket.");
        }
        Socket socket = this.mCertificateSocketFactory.createSocket(address, port);
        this.enableTlsIfAvailable(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localhost, int localPort) throws IOException {
        if (this.mCertificateSocketFactory == null) {
            throw new SocketException("SSLSocketFactory was null. Unable to create socket.");
        }
        Socket socket = this.mCertificateSocketFactory.createSocket(address, port, localhost, localPort);
        this.enableTlsIfAvailable(socket);
        return socket;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        if (this.mCertificateSocketFactory == null) {
            return new String[0];
        }
        return this.mCertificateSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        if (this.mCertificateSocketFactory == null) {
            return new String[0];
        }
        return this.mCertificateSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socketParam, String host, int port, boolean autoClose) throws IOException {
        if (this.mCertificateSocketFactory == null) {
            throw new SocketException("SSLSocketFactory was null. Unable to create socket.");
        }
        if (Build.VERSION.SDK_INT < 23) {
            if (autoClose && socketParam != null) {
                socketParam.close();
            }
            Socket socket = this.mCertificateSocketFactory.createSocket(InetAddressUtils.getInetAddressByName(host), port);
            this.enableTlsIfAvailable(socket);
            this.doManualServerNameIdentification(socket, host);
            return socket;
        }
        Socket socket = this.mCertificateSocketFactory.createSocket(socketParam, host, port, autoClose);
        this.enableTlsIfAvailable(socket);
        return socket;
    }

    private void doManualServerNameIdentification(@NonNull Socket socket, @Nullable String host) throws IOException {
        Preconditions.checkNotNull(socket);
        if (this.mCertificateSocketFactory == null) {
            throw new SocketException("SSLSocketFactory was null. Unable to create socket.");
        }
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            CustomSSLSocketFactory.setHostnameOnSocket((SSLCertificateSocketFactory)this.mCertificateSocketFactory, sslSocket, host);
            CustomSSLSocketFactory.verifyServerName(sslSocket, host);
        }
    }

    @VisibleForTesting
    static void setHostnameOnSocket(@NonNull SSLCertificateSocketFactory certificateSocketFactory, @NonNull SSLSocket sslSocket, @Nullable String host) {
        Preconditions.checkNotNull(certificateSocketFactory);
        Preconditions.checkNotNull(sslSocket);
        if (Build.VERSION.SDK_INT >= 17) {
            certificateSocketFactory.setHostname((Socket)sslSocket, host);
        } else {
            try {
                new Reflection.MethodBuilder(sslSocket, "setHostname").addParam(String.class, host).execute();
            }
            catch (Exception e) {
                MoPubLog.d("Unable to call setHostname() on the socket");
            }
        }
    }

    @VisibleForTesting
    static void verifyServerName(@NonNull SSLSocket sslSocket, @Nullable String host) throws IOException {
        Preconditions.checkNotNull(sslSocket);
        sslSocket.startHandshake();
        HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
        if (!hostnameVerifier.verify(host, sslSocket.getSession())) {
            throw new SSLHandshakeException("Server Name Identification failed.");
        }
    }

    private void enableTlsIfAvailable(@Nullable Socket socket) {
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            String[] supportedProtocols = sslSocket.getSupportedProtocols();
            sslSocket.setEnabledProtocols(supportedProtocols);
        }
    }

    @Deprecated
    @VisibleForTesting
    void setCertificateSocketFactory(@NonNull SSLSocketFactory sslSocketFactory) {
        this.mCertificateSocketFactory = sslSocketFactory;
    }
}

