/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.network;

import android.content.Context;
import android.net.Uri;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mopub.common.Preconditions;
import com.mopub.mobileads.MoPubError;
import com.mopub.network.AdResponse;
import com.mopub.network.TrackingRequest;
import java.util.ArrayList;
import java.util.List;

class ContentDownloadAnalytics {
    private static final String LOAD_DURATION_MS_MACRO = "%%LOAD_DURATION_MS%%";
    private static final String LOAD_RESULT_MACRO = "%%LOAD_RESULT%%";
    @Nullable
    Long mBeforeLoadTime = null;
    @NonNull
    private AdResponse mAdResponse;

    ContentDownloadAnalytics(@NonNull AdResponse adResponse) {
        Preconditions.checkNotNull(adResponse);
        this.mAdResponse = adResponse;
    }

    void reportBeforeLoad(@Nullable Context context) {
        if (context == null) {
            return;
        }
        String url = this.mAdResponse.getBeforeLoadUrl();
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        this.mBeforeLoadTime = SystemClock.uptimeMillis();
        TrackingRequest.makeTrackingHttpRequest(url, context);
    }

    void reportAfterLoad(@Nullable Context context, @Nullable MoPubError errorCode) {
        if (context == null || this.mBeforeLoadTime == null) {
            return;
        }
        DownloadResult result = this.errorCodeToDownloadResult(errorCode);
        List<String> urls = this.generateAfterLoadUrls(this.mAdResponse.getAfterLoadUrls(), result.value);
        TrackingRequest.makeTrackingHttpRequest(urls, context);
    }

    void reportAfterLoadSuccess(@Nullable Context context) {
        if (context == null || this.mBeforeLoadTime == null) {
            return;
        }
        List<String> urls = this.generateAfterLoadUrls(this.mAdResponse.getAfterLoadSuccessUrls(), DownloadResult.AD_LOADED.value);
        TrackingRequest.makeTrackingHttpRequest(urls, context);
    }

    void reportAfterLoadFail(@Nullable Context context, @Nullable MoPubError errorCode) {
        if (context == null || this.mBeforeLoadTime == null) {
            return;
        }
        DownloadResult result = this.errorCodeToDownloadResult(errorCode);
        List<String> urls = this.generateAfterLoadUrls(this.mAdResponse.getAfterLoadFailUrls(), result.value);
        TrackingRequest.makeTrackingHttpRequest(urls, context);
    }

    @Nullable
    private List<String> generateAfterLoadUrls(@Nullable List<String> urls, @NonNull String loadResult) {
        if (urls == null || urls.isEmpty() || this.mBeforeLoadTime == null) {
            return null;
        }
        ArrayList<String> newUrls = new ArrayList<String>();
        for (String url : urls) {
            url = url.replace(LOAD_DURATION_MS_MACRO, String.valueOf(SystemClock.uptimeMillis() - this.mBeforeLoadTime));
            url = url.replace(LOAD_RESULT_MACRO, Uri.encode((String)loadResult));
            newUrls.add(url);
        }
        return newUrls;
    }

    @NonNull
    private DownloadResult errorCodeToDownloadResult(@Nullable MoPubError errorCode) {
        if (null == errorCode) {
            return DownloadResult.AD_LOADED;
        }
        switch (errorCode.getIntCode()) {
            case 0: {
                return DownloadResult.AD_LOADED;
            }
            case 2: {
                return DownloadResult.TIMEOUT;
            }
            case 1: {
                return DownloadResult.MISSING_ADAPTER;
            }
        }
        return DownloadResult.INVALID_DATA;
    }

    static enum DownloadResult {
        AD_LOADED("ad_loaded"),
        MISSING_ADAPTER("missing_adapter"),
        TIMEOUT("timeout"),
        INVALID_DATA("invalid_data");

        @NonNull
        private final String value;

        private DownloadResult(String loadResult) {
            this.value = loadResult;
        }
    }
}

