/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mraid;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.widget.Toast;
import com.mopub.common.MoPubHttpUrlConnection;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.AsyncTasks;
import com.mopub.common.util.DeviceUtils;
import com.mopub.common.util.Intents;
import com.mopub.common.util.ResponseHeader;
import com.mopub.common.util.Streams;
import com.mopub.common.util.Utils;
import com.mopub.mraid.MraidCommandException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MraidNativeCommandHandler {
    private static final int MAX_NUMBER_DAYS_IN_MONTH = 31;
    private static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ssZZZZZ", "yyyy-MM-dd'T'HH:mmZZZZZ"};
    public static final String ANDROID_CALENDAR_CONTENT_TYPE = "vnd.android.cursor.item/event";

    void createCalendarEvent(Context context, Map<String, String> params) throws MraidCommandException {
        if (MraidNativeCommandHandler.isCalendarAvailable(context)) {
            try {
                Map<String, Object> calendarParams = this.translateJSParamsToAndroidCalendarEventMapping(params);
                Intent intent = new Intent("android.intent.action.INSERT").setType(ANDROID_CALENDAR_CONTENT_TYPE);
                for (String key : calendarParams.keySet()) {
                    Object value = calendarParams.get(key);
                    if (value instanceof Long) {
                        intent.putExtra(key, ((Long)value).longValue());
                        continue;
                    }
                    if (value instanceof Integer) {
                        intent.putExtra(key, ((Integer)value).intValue());
                        continue;
                    }
                    intent.putExtra(key, (String)value);
                }
                intent.setFlags(0x10000000);
                context.startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                MoPubLog.d("no calendar app installed");
                throw new MraidCommandException("Action is unsupported on this device - no calendar app installed");
            }
            catch (IllegalArgumentException e) {
                MoPubLog.d("create calendar: invalid parameters " + e.getMessage());
                throw new MraidCommandException(e);
            }
            catch (Exception e) {
                MoPubLog.d("could not create calendar event");
                throw new MraidCommandException(e);
            }
        } else {
            MoPubLog.d("unsupported action createCalendarEvent for devices pre-ICS");
            throw new MraidCommandException("Action is unsupported on this device (need Android version Ice Cream Sandwich or above)");
        }
    }

    void storePicture(@NonNull Context context, @NonNull String imageUrl, @NonNull MraidCommandFailureListener failureListener) throws MraidCommandException {
        if (!MraidNativeCommandHandler.isStorePictureSupported(context)) {
            MoPubLog.d("Error downloading file - the device does not have an SD card mounted, or the Android permission is not granted.");
            throw new MraidCommandException("Error downloading file  - the device does not have an SD card mounted, or the Android permission is not granted.");
        }
        if (context instanceof Activity) {
            this.showUserDialog(context, imageUrl, failureListener);
        } else {
            Toast.makeText((Context)context, (CharSequence)"Downloading image to Picture gallery...", (int)0).show();
            this.downloadImage(context, imageUrl, failureListener);
        }
    }

    boolean isTelAvailable(Context context) {
        Intent telIntent = new Intent("android.intent.action.DIAL");
        telIntent.setData(Uri.parse((String)"tel:"));
        return Intents.deviceCanHandleIntent(context, telIntent);
    }

    boolean isSmsAvailable(Context context) {
        Intent smsIntent = new Intent("android.intent.action.VIEW");
        smsIntent.setData(Uri.parse((String)"sms:"));
        return Intents.deviceCanHandleIntent(context, smsIntent);
    }

    public static boolean isStorePictureSupported(Context context) {
        return "mounted".equals(Environment.getExternalStorageState()) && DeviceUtils.isPermissionGranted(context, "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    static boolean isCalendarAvailable(Context context) {
        Intent calendarIntent = new Intent("android.intent.action.INSERT").setType(ANDROID_CALENDAR_CONTENT_TYPE);
        return Intents.deviceCanHandleIntent(context, calendarIntent);
    }

    boolean isInlineVideoAvailable(@NonNull Activity activity, @NonNull View view) {
        View tempView = view;
        while (true) {
            if (!tempView.isHardwareAccelerated() || Utils.bitMaskContainsFlag(tempView.getLayerType(), 1)) {
                return false;
            }
            if (!(tempView.getParent() instanceof View)) break;
            tempView = (View)tempView.getParent();
        }
        Window window = activity.getWindow();
        return window != null && Utils.bitMaskContainsFlag(window.getAttributes().flags, 0x1000000);
    }

    private Map<String, Object> translateJSParamsToAndroidCalendarEventMapping(Map<String, String> params) {
        Date startDateTime;
        HashMap<String, Object> validatedParamsMapping = new HashMap<String, Object>();
        if (!params.containsKey("description") || !params.containsKey("start")) {
            throw new IllegalArgumentException("Missing start and description fields");
        }
        validatedParamsMapping.put("title", params.get("description"));
        if (params.containsKey("start") && params.get("start") != null) {
            startDateTime = this.parseDate(params.get("start"));
            if (startDateTime == null) {
                throw new IllegalArgumentException("Invalid calendar event: start time is malformed. Date format expecting (yyyy-MM-DDTHH:MM:SS-xx:xx) or (yyyy-MM-DDTHH:MM-xx:xx) i.e. 2013-08-14T09:00:01-08:00");
            }
        } else {
            throw new IllegalArgumentException("Invalid calendar event: start is null.");
        }
        validatedParamsMapping.put("beginTime", startDateTime.getTime());
        if (params.containsKey("end") && params.get("end") != null) {
            Date endDateTime = this.parseDate(params.get("end"));
            if (endDateTime != null) {
                validatedParamsMapping.put("endTime", endDateTime.getTime());
            } else {
                throw new IllegalArgumentException("Invalid calendar event: end time is malformed. Date format expecting (yyyy-MM-DDTHH:MM:SS-xx:xx) or (yyyy-MM-DDTHH:MM-xx:xx) i.e. 2013-08-14T09:00:01-08:00");
            }
        }
        if (params.containsKey("location")) {
            validatedParamsMapping.put("eventLocation", params.get("location"));
        }
        if (params.containsKey("summary")) {
            validatedParamsMapping.put("description", params.get("summary"));
        }
        if (params.containsKey("transparency")) {
            validatedParamsMapping.put("availability", params.get("transparency").equals("transparent") ? 1 : 0);
        }
        validatedParamsMapping.put("rrule", this.parseRecurrenceRule(params));
        return validatedParamsMapping;
    }

    private Date parseDate(String dateTime) {
        Date result = null;
        for (String DATE_FORMAT : DATE_FORMATS) {
            try {
                result = new SimpleDateFormat(DATE_FORMAT, Locale.US).parse(dateTime);
                if (result == null) continue;
                break;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    private String parseRecurrenceRule(Map<String, String> params) throws IllegalArgumentException {
        StringBuilder rule = new StringBuilder();
        if (params.containsKey("frequency")) {
            String frequency = params.get("frequency");
            int interval = -1;
            if (params.containsKey("interval")) {
                interval = Integer.parseInt(params.get("interval"));
            }
            if ("daily".equals(frequency)) {
                rule.append("FREQ=DAILY;");
                if (interval != -1) {
                    rule.append("INTERVAL=" + interval + ";");
                }
            } else if ("weekly".equals(frequency)) {
                rule.append("FREQ=WEEKLY;");
                if (interval != -1) {
                    rule.append("INTERVAL=" + interval + ";");
                }
                if (params.containsKey("daysInWeek")) {
                    String weekdays = this.translateWeekIntegersToDays(params.get("daysInWeek"));
                    if (weekdays == null) {
                        throw new IllegalArgumentException("invalid ");
                    }
                    rule.append("BYDAY=" + weekdays + ";");
                }
            } else if ("monthly".equals(frequency)) {
                rule.append("FREQ=MONTHLY;");
                if (interval != -1) {
                    rule.append("INTERVAL=" + interval + ";");
                }
                if (params.containsKey("daysInMonth")) {
                    String monthDays = this.translateMonthIntegersToDays(params.get("daysInMonth"));
                    if (monthDays == null) {
                        throw new IllegalArgumentException();
                    }
                    rule.append("BYMONTHDAY=" + monthDays + ";");
                }
            } else {
                throw new IllegalArgumentException("frequency is only supported for daily, weekly, and monthly.");
            }
        }
        return rule.toString();
    }

    private String translateWeekIntegersToDays(String expression) throws IllegalArgumentException {
        String[] days;
        StringBuilder daysResult = new StringBuilder();
        boolean[] daysAlreadyCounted = new boolean[7];
        for (String day : days = expression.split(",")) {
            int dayNumber = Integer.parseInt(day);
            int n = dayNumber = dayNumber == 7 ? 0 : dayNumber;
            if (daysAlreadyCounted[dayNumber]) continue;
            daysResult.append(this.dayNumberToDayOfWeekString(dayNumber) + ",");
            daysAlreadyCounted[dayNumber] = true;
        }
        if (days.length == 0) {
            throw new IllegalArgumentException("must have at least 1 day of the week if specifying repeating weekly");
        }
        daysResult.deleteCharAt(daysResult.length() - 1);
        return daysResult.toString();
    }

    private String translateMonthIntegersToDays(String expression) throws IllegalArgumentException {
        String[] days;
        StringBuilder daysResult = new StringBuilder();
        boolean[] daysAlreadyCounted = new boolean[63];
        for (String day : days = expression.split(",")) {
            int dayNumber = Integer.parseInt(day);
            if (daysAlreadyCounted[dayNumber + 31]) continue;
            daysResult.append(this.dayNumberToDayOfMonthString(dayNumber) + ",");
            daysAlreadyCounted[dayNumber + 31] = true;
        }
        if (days.length == 0) {
            throw new IllegalArgumentException("must have at least 1 day of the month if specifying repeating weekly");
        }
        daysResult.deleteCharAt(daysResult.length() - 1);
        return daysResult.toString();
    }

    private String dayNumberToDayOfWeekString(int number) throws IllegalArgumentException {
        String dayOfWeek;
        switch (number) {
            case 0: {
                dayOfWeek = "SU";
                break;
            }
            case 1: {
                dayOfWeek = "MO";
                break;
            }
            case 2: {
                dayOfWeek = "TU";
                break;
            }
            case 3: {
                dayOfWeek = "WE";
                break;
            }
            case 4: {
                dayOfWeek = "TH";
                break;
            }
            case 5: {
                dayOfWeek = "FR";
                break;
            }
            case 6: {
                dayOfWeek = "SA";
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid day of week " + number);
            }
        }
        return dayOfWeek;
    }

    private String dayNumberToDayOfMonthString(int number) throws IllegalArgumentException {
        if (number == 0 || number < -31 || number > 31) {
            throw new IllegalArgumentException("invalid day of month " + number);
        }
        String dayOfMonth = "" + number;
        return dayOfMonth;
    }

    void downloadImage(final Context context, String uriString, final MraidCommandFailureListener failureListener) {
        DownloadImageAsyncTask downloadImageAsyncTask = new DownloadImageAsyncTask(context, new DownloadImageAsyncTask.DownloadImageAsyncTaskListener(){

            @Override
            public void onSuccess() {
                MoPubLog.d("Image successfully saved.");
            }

            @Override
            public void onFailure() {
                Toast.makeText((Context)context, (CharSequence)"Image failed to download.", (int)0).show();
                MoPubLog.d("Error downloading and saving image file.");
                failureListener.onFailure(new MraidCommandException("Error downloading and saving image file."));
            }
        });
        AsyncTasks.safeExecuteOnExecutor(downloadImageAsyncTask, uriString);
    }

    private void showUserDialog(final Context context, final String imageUrl, final MraidCommandFailureListener failureListener) {
        AlertDialog.Builder alertDialogDownloadImage = new AlertDialog.Builder(context);
        alertDialogDownloadImage.setTitle((CharSequence)"Save Image").setMessage((CharSequence)"Download image to Picture gallery?").setNegativeButton((CharSequence)"Cancel", null).setPositiveButton((CharSequence)"Okay", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MraidNativeCommandHandler.this.downloadImage(context, imageUrl, failureListener);
            }
        }).setCancelable(true).show();
    }

    private static class MoPubMediaScannerConnectionClient
    implements MediaScannerConnection.MediaScannerConnectionClient {
        private final String mFilename;
        private final String mMimeType;
        private MediaScannerConnection mMediaScannerConnection;

        private MoPubMediaScannerConnectionClient(String filename, String mimeType) {
            this.mFilename = filename;
            this.mMimeType = mimeType;
        }

        private void setMediaScannerConnection(MediaScannerConnection connection) {
            this.mMediaScannerConnection = connection;
        }

        public void onMediaScannerConnected() {
            if (this.mMediaScannerConnection != null) {
                this.mMediaScannerConnection.scanFile(this.mFilename, this.mMimeType);
            }
        }

        public void onScanCompleted(String path, Uri uri) {
            if (this.mMediaScannerConnection != null) {
                this.mMediaScannerConnection.disconnect();
            }
        }
    }

    @VisibleForTesting
    static class DownloadImageAsyncTask
    extends AsyncTask<String, Void, Boolean> {
        private final Context mContext;
        private final DownloadImageAsyncTaskListener mListener;

        public DownloadImageAsyncTask(@NonNull Context context, @NonNull DownloadImageAsyncTaskListener listener) {
            this.mContext = context.getApplicationContext();
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground(@NonNull String[] params) {
            Boolean bl;
            if (params == null || params.length == 0 || params[0] == null) {
                return false;
            }
            File pictureStoragePath = this.getPictureStoragePath();
            pictureStoragePath.mkdirs();
            String uriString = params[0];
            URI uri = URI.create(uriString);
            BufferedInputStream pictureInputStream = null;
            FileOutputStream pictureOutputStream = null;
            try {
                HttpURLConnection urlConnection = MoPubHttpUrlConnection.getHttpUrlConnection(uriString);
                pictureInputStream = new BufferedInputStream(urlConnection.getInputStream());
                String redirectLocation = urlConnection.getHeaderField(ResponseHeader.LOCATION.getKey());
                if (!TextUtils.isEmpty((CharSequence)redirectLocation)) {
                    uri = URI.create(redirectLocation);
                }
                String pictureFileName = this.getFileNameForUriAndHeaders(uri, urlConnection.getHeaderFields());
                File pictureFile = new File(pictureStoragePath, pictureFileName);
                pictureOutputStream = new FileOutputStream(pictureFile);
                Streams.copyContent(pictureInputStream, pictureOutputStream);
                String pictureFileFullPath = pictureFile.toString();
                this.loadPictureIntoGalleryApp(pictureFileFullPath);
                bl = true;
                Streams.closeStream(pictureInputStream);
            }
            catch (Exception e) {
                Boolean bl2 = false;
                return bl2;
            }
            finally {
                Streams.closeStream(pictureInputStream);
                Streams.closeStream(pictureOutputStream);
            }
            Streams.closeStream(pictureOutputStream);
            return bl;
        }

        protected void onPostExecute(Boolean success) {
            if (success != null && success.booleanValue()) {
                this.mListener.onSuccess();
            } else {
                this.mListener.onFailure();
            }
        }

        @Nullable
        private String getFileNameForUriAndHeaders(@NonNull URI uri, @Nullable Map<String, List<String>> headers) {
            String[] fields;
            Preconditions.checkNotNull(uri);
            String path = uri.getPath();
            if (path == null || headers == null) {
                return null;
            }
            String filename = new File(path).getName();
            List<String> mimeTypeHeaders = headers.get(ResponseHeader.CONTENT_TYPE.getKey());
            if (mimeTypeHeaders == null || mimeTypeHeaders.isEmpty() || mimeTypeHeaders.get(0) == null) {
                return filename;
            }
            for (String field : fields = mimeTypeHeaders.get(0).split(";")) {
                if (!field.contains("image/")) continue;
                String extension = "." + field.split("/")[1];
                if (filename.endsWith(extension)) break;
                filename = filename + extension;
                break;
            }
            return filename;
        }

        private File getPictureStoragePath() {
            return new File(Environment.getExternalStorageDirectory(), "Pictures");
        }

        private void loadPictureIntoGalleryApp(String filename) {
            MoPubMediaScannerConnectionClient mediaScannerConnectionClient = new MoPubMediaScannerConnectionClient(filename, null);
            MediaScannerConnection mediaScannerConnection = new MediaScannerConnection(this.mContext, (MediaScannerConnection.MediaScannerConnectionClient)mediaScannerConnectionClient);
            mediaScannerConnectionClient.setMediaScannerConnection(mediaScannerConnection);
            mediaScannerConnection.connect();
        }

        @Deprecated
        @VisibleForTesting
        DownloadImageAsyncTaskListener getListener() {
            return this.mListener;
        }

        static interface DownloadImageAsyncTaskListener {
            public void onSuccess();

            public void onFailure();
        }
    }

    static interface MraidCommandFailureListener {
        public void onFailure(MraidCommandException var1);
    }
}

