/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mraid;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.ConsoleMessage;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.mopub.common.AdReport;
import com.mopub.common.CloseableLayout;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibilityTracker;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.BaseWebView;
import com.mopub.mobileads.ViewGestureDetector;
import com.mopub.mraid.MraidCommandException;
import com.mopub.mraid.MraidJavascriptCommand;
import com.mopub.mraid.MraidNativeCommandHandler;
import com.mopub.mraid.MraidOrientation;
import com.mopub.mraid.MraidScreenMetrics;
import com.mopub.mraid.MraidWebViewClient;
import com.mopub.mraid.PlacementType;
import com.mopub.mraid.ViewState;
import com.mopub.network.Networking;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.json.JSONObject;

public class MraidBridge {
    private final AdReport mAdReport;
    @NonNull
    private final PlacementType mPlacementType;
    @NonNull
    private final MraidNativeCommandHandler mMraidNativeCommandHandler;
    @Nullable
    private MraidBridgeListener mMraidBridgeListener;
    @Nullable
    private MraidWebView mMraidWebView;
    private boolean mIsClicked;
    private boolean mHasLoaded;
    private final WebViewClient mMraidWebViewClient = new MraidWebViewClient(){

        public boolean shouldOverrideUrlLoading(@NonNull WebView view, @NonNull String url) {
            return MraidBridge.this.handleShouldOverrideUrl(url);
        }

        public void onPageFinished(@NonNull WebView view, @NonNull String url) {
            MraidBridge.this.handlePageFinished();
        }

        public void onReceivedError(@NonNull WebView view, int errorCode, @NonNull String description, @NonNull String failingUrl) {
            MoPubLog.d("Error: " + description);
            super.onReceivedError(view, errorCode, description, failingUrl);
        }
    };

    MraidBridge(@Nullable AdReport adReport, @NonNull PlacementType placementType) {
        this(adReport, placementType, new MraidNativeCommandHandler());
    }

    @VisibleForTesting
    MraidBridge(@Nullable AdReport adReport, @NonNull PlacementType placementType, @NonNull MraidNativeCommandHandler mraidNativeCommandHandler) {
        this.mAdReport = adReport;
        this.mPlacementType = placementType;
        this.mMraidNativeCommandHandler = mraidNativeCommandHandler;
    }

    void setMraidBridgeListener(@Nullable MraidBridgeListener listener) {
        this.mMraidBridgeListener = listener;
    }

    void attachView(@NonNull MraidWebView mraidWebView) {
        this.mMraidWebView = mraidWebView;
        this.mMraidWebView.getSettings().setJavaScriptEnabled(true);
        if (Build.VERSION.SDK_INT >= 17 && this.mPlacementType == PlacementType.INTERSTITIAL) {
            mraidWebView.getSettings().setMediaPlaybackRequiresUserGesture(false);
        }
        this.mMraidWebView.setScrollContainer(false);
        this.mMraidWebView.setVerticalScrollBarEnabled(false);
        this.mMraidWebView.setHorizontalScrollBarEnabled(false);
        this.mMraidWebView.setBackgroundColor(-16777216);
        this.mMraidWebView.setWebViewClient(this.mMraidWebViewClient);
        this.mMraidWebView.setWebChromeClient(new WebChromeClient(){

            public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
                if (MraidBridge.this.mMraidBridgeListener != null) {
                    return MraidBridge.this.mMraidBridgeListener.onJsAlert(message, result);
                }
                return super.onJsAlert(view, url, message, result);
            }

            public boolean onConsoleMessage(@NonNull ConsoleMessage consoleMessage) {
                if (MraidBridge.this.mMraidBridgeListener != null) {
                    return MraidBridge.this.mMraidBridgeListener.onConsoleMessage(consoleMessage);
                }
                return super.onConsoleMessage(consoleMessage);
            }

            public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
                super.onShowCustomView(view, callback);
            }
        });
        final ViewGestureDetector gestureDetector = new ViewGestureDetector(this.mMraidWebView.getContext(), (View)this.mMraidWebView, this.mAdReport);
        gestureDetector.setUserClickListener(new ViewGestureDetector.UserClickListener(){

            @Override
            public void onUserClick() {
                MraidBridge.this.mIsClicked = true;
            }

            @Override
            public void onResetUserClick() {
                MraidBridge.this.mIsClicked = false;
            }

            @Override
            public boolean wasClicked() {
                return MraidBridge.this.mIsClicked;
            }
        });
        this.mMraidWebView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                gestureDetector.sendTouchEvent(event);
                switch (event.getAction()) {
                    case 0: 
                    case 1: {
                        if (v.hasFocus()) break;
                        v.requestFocus();
                    }
                }
                return false;
            }
        });
        this.mMraidWebView.setVisibilityChangedListener(new MraidWebView.OnVisibilityChangedListener(){

            @Override
            public void onVisibilityChanged(boolean isVisible) {
                if (MraidBridge.this.mMraidBridgeListener != null) {
                    MraidBridge.this.mMraidBridgeListener.onVisibilityChanged(isVisible);
                }
            }
        });
    }

    void detach() {
        if (this.mMraidWebView != null) {
            this.mMraidWebView.destroy();
            this.mMraidWebView = null;
        }
    }

    public void setContentHtml(@NonNull String htmlData) {
        if (this.mMraidWebView == null) {
            MoPubLog.d("MRAID bridge called setContentHtml before WebView was attached");
            return;
        }
        this.mHasLoaded = false;
        this.mMraidWebView.loadDataWithBaseURL(Networking.getBaseUrlScheme() + "://" + "ads.mopub.com" + "/", htmlData, "text/html", "UTF-8", null);
    }

    public void setContentUrl(String url) {
        if (this.mMraidWebView == null) {
            MoPubLog.d("MRAID bridge called setContentHtml while WebView was not attached");
            return;
        }
        this.mHasLoaded = false;
        this.mMraidWebView.loadUrl(url);
    }

    void injectJavaScript(@NonNull String javascript) {
        if (this.mMraidWebView == null) {
            MoPubLog.d("Attempted to inject Javascript into MRAID WebView while was not attached:\n\t" + javascript);
            return;
        }
        MoPubLog.d("Injecting Javascript into MRAID WebView:\n\t" + javascript);
        this.mMraidWebView.loadUrl("javascript:" + javascript);
    }

    private void fireErrorEvent(@NonNull MraidJavascriptCommand command, @NonNull String message) {
        this.injectJavaScript("window.mraidbridge.notifyErrorEvent(" + JSONObject.quote((String)command.toJavascriptString()) + ", " + JSONObject.quote((String)message) + ")");
    }

    private void fireNativeCommandCompleteEvent(@NonNull MraidJavascriptCommand command) {
        this.injectJavaScript("window.mraidbridge.nativeCallComplete(" + JSONObject.quote((String)command.toJavascriptString()) + ")");
    }

    @VisibleForTesting
    boolean handleShouldOverrideUrl(@NonNull String url) {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            MoPubLog.d("Invalid MRAID URL: " + url);
            this.fireErrorEvent(MraidJavascriptCommand.UNSPECIFIED, "Mraid command sent an invalid URL");
            return true;
        }
        String scheme = uri.getScheme();
        String host = uri.getHost();
        if ("mopub".equals(scheme)) {
            if ("failLoad".equals(host) && this.mPlacementType == PlacementType.INLINE && this.mMraidBridgeListener != null) {
                this.mMraidBridgeListener.onPageFailedToLoad();
            }
            return true;
        }
        if ("mraid".equals(scheme)) {
            HashMap<String, String> params = new HashMap<String, String>();
            for (NameValuePair pair : URLEncodedUtils.parse((URI)uri, (String)"UTF-8")) {
                params.put(pair.getName(), pair.getValue());
            }
            MraidJavascriptCommand command = MraidJavascriptCommand.fromJavascriptString(host);
            try {
                this.runCommand(command, params);
            }
            catch (MraidCommandException exception) {
                this.fireErrorEvent(command, exception.getMessage());
            }
            this.fireNativeCommandCompleteEvent(command);
            return true;
        }
        if (this.mIsClicked) {
            Intent intent = new Intent();
            intent.setAction("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            intent.addFlags(0x10000000);
            try {
                if (this.mMraidWebView == null) {
                    MoPubLog.d("WebView was detached. Unable to load a URL");
                    return true;
                }
                this.mMraidWebView.getContext().startActivity(intent);
                return true;
            }
            catch (ActivityNotFoundException e) {
                MoPubLog.d("No activity found to handle this URL " + url);
                return false;
            }
        }
        return false;
    }

    @VisibleForTesting
    private void handlePageFinished() {
        if (this.mHasLoaded) {
            return;
        }
        this.mHasLoaded = true;
        if (this.mMraidBridgeListener != null) {
            this.mMraidBridgeListener.onPageLoaded();
        }
    }

    @VisibleForTesting
    void runCommand(final @NonNull MraidJavascriptCommand command, @NonNull Map<String, String> params) throws MraidCommandException {
        if (command.requiresClick(this.mPlacementType) && !this.mIsClicked) {
            throw new MraidCommandException("Cannot execute this command unless the user clicks");
        }
        if (this.mMraidBridgeListener == null) {
            throw new MraidCommandException("Invalid state to execute this command");
        }
        if (this.mMraidWebView == null) {
            throw new MraidCommandException("The current WebView is being destroyed");
        }
        switch (command) {
            case CLOSE: {
                this.mMraidBridgeListener.onClose();
                break;
            }
            case RESIZE: {
                int width = this.checkRange(this.parseSize(params.get("width")), 0, 100000);
                int height = this.checkRange(this.parseSize(params.get("height")), 0, 100000);
                int offsetX = this.checkRange(this.parseSize(params.get("offsetX")), -100000, 100000);
                int offsetY = this.checkRange(this.parseSize(params.get("offsetY")), -100000, 100000);
                CloseableLayout.ClosePosition closePosition = this.parseClosePosition(params.get("customClosePosition"), CloseableLayout.ClosePosition.TOP_RIGHT);
                boolean allowOffscreen = this.parseBoolean(params.get("allowOffscreen"), true);
                this.mMraidBridgeListener.onResize(width, height, offsetX, offsetY, closePosition, allowOffscreen);
                break;
            }
            case EXPAND: {
                URI uri = this.parseURI(params.get("url"), null);
                boolean shouldUseCustomClose = this.parseBoolean(params.get("shouldUseCustomClose"), false);
                this.mMraidBridgeListener.onExpand(uri, shouldUseCustomClose);
                break;
            }
            case USE_CUSTOM_CLOSE: {
                boolean shouldUseCustomClose = this.parseBoolean(params.get("shouldUseCustomClose"), false);
                this.mMraidBridgeListener.onUseCustomClose(shouldUseCustomClose);
                break;
            }
            case OPEN: {
                URI uri = this.parseURI(params.get("url"));
                this.mMraidBridgeListener.onOpen(uri);
                break;
            }
            case SET_ORIENTATION_PROPERTIES: {
                boolean allowOrientationChange = this.parseBoolean(params.get("allowOrientationChange"));
                MraidOrientation forceOrientation = this.parseOrientation(params.get("forceOrientation"));
                this.mMraidBridgeListener.onSetOrientationProperties(allowOrientationChange, forceOrientation);
                break;
            }
            case PLAY_VIDEO: {
                URI uri = this.parseURI(params.get("uri"));
                this.mMraidBridgeListener.onPlayVideo(uri);
                break;
            }
            case STORE_PICTURE: {
                URI uri = this.parseURI(params.get("uri"));
                this.mMraidNativeCommandHandler.storePicture(this.mMraidWebView.getContext(), uri.toString(), new MraidNativeCommandHandler.MraidCommandFailureListener(){

                    @Override
                    public void onFailure(MraidCommandException exception) {
                        MraidBridge.this.fireErrorEvent(command, exception.getMessage());
                    }
                });
                break;
            }
            case CREATE_CALENDAR_EVENT: {
                this.mMraidNativeCommandHandler.createCalendarEvent(this.mMraidWebView.getContext(), params);
                break;
            }
            case UNSPECIFIED: {
                throw new MraidCommandException("Unspecified MRAID Javascript command");
            }
        }
    }

    private CloseableLayout.ClosePosition parseClosePosition(@NonNull String text, @NonNull CloseableLayout.ClosePosition defaultValue) throws MraidCommandException {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return defaultValue;
        }
        if (text.equals("top-left")) {
            return CloseableLayout.ClosePosition.TOP_LEFT;
        }
        if (text.equals("top-right")) {
            return CloseableLayout.ClosePosition.TOP_RIGHT;
        }
        if (text.equals("center")) {
            return CloseableLayout.ClosePosition.CENTER;
        }
        if (text.equals("bottom-left")) {
            return CloseableLayout.ClosePosition.BOTTOM_LEFT;
        }
        if (text.equals("bottom-right")) {
            return CloseableLayout.ClosePosition.BOTTOM_RIGHT;
        }
        if (text.equals("top-center")) {
            return CloseableLayout.ClosePosition.TOP_CENTER;
        }
        if (text.equals("bottom-center")) {
            return CloseableLayout.ClosePosition.BOTTOM_CENTER;
        }
        throw new MraidCommandException("Invalid close position: " + text);
    }

    private int parseSize(@NonNull String text) throws MraidCommandException {
        int result;
        try {
            result = Integer.parseInt(text, 10);
        }
        catch (NumberFormatException e) {
            throw new MraidCommandException("Invalid numeric parameter: " + text);
        }
        return result;
    }

    private MraidOrientation parseOrientation(String text) throws MraidCommandException {
        if ("portrait".equals(text)) {
            return MraidOrientation.PORTRAIT;
        }
        if ("landscape".equals(text)) {
            return MraidOrientation.LANDSCAPE;
        }
        if ("none".equals(text)) {
            return MraidOrientation.NONE;
        }
        throw new MraidCommandException("Invalid orientation: " + text);
    }

    private int checkRange(int value, int min, int max) throws MraidCommandException {
        if (value < min || value > max) {
            throw new MraidCommandException("Integer parameter out of range: " + value);
        }
        return value;
    }

    private boolean parseBoolean(@Nullable String text, boolean defaultValue) throws MraidCommandException {
        if (text == null) {
            return defaultValue;
        }
        return this.parseBoolean(text);
    }

    private boolean parseBoolean(String text) throws MraidCommandException {
        if ("true".equals(text)) {
            return true;
        }
        if ("false".equals(text)) {
            return false;
        }
        throw new MraidCommandException("Invalid boolean parameter: " + text);
    }

    @NonNull
    private URI parseURI(@Nullable String encodedText, URI defaultValue) throws MraidCommandException {
        if (encodedText == null) {
            return defaultValue;
        }
        return this.parseURI(encodedText);
    }

    @NonNull
    private URI parseURI(@Nullable String encodedText) throws MraidCommandException {
        if (encodedText == null) {
            throw new MraidCommandException("Parameter cannot be null");
        }
        try {
            return new URI(encodedText);
        }
        catch (URISyntaxException e) {
            throw new MraidCommandException("Invalid URL parameter: " + encodedText);
        }
    }

    void notifyViewability(boolean isViewable) {
        this.injectJavaScript("mraidbridge.setIsViewable(" + isViewable + ")");
    }

    void notifyPlacementType(PlacementType placementType) {
        this.injectJavaScript("mraidbridge.setPlacementType(" + JSONObject.quote((String)placementType.toJavascriptString()) + ")");
    }

    void notifyViewState(ViewState state) {
        this.injectJavaScript("mraidbridge.setState(" + JSONObject.quote((String)state.toJavascriptString()) + ")");
    }

    void notifySupports(boolean sms, boolean telephone, boolean calendar, boolean storePicture, boolean inlineVideo) {
        this.injectJavaScript("mraidbridge.setSupports(" + sms + "," + telephone + "," + calendar + "," + storePicture + "," + inlineVideo + ")");
    }

    @NonNull
    private String stringifyRect(Rect rect) {
        return rect.left + "," + rect.top + "," + rect.width() + "," + rect.height();
    }

    @NonNull
    private String stringifySize(Rect rect) {
        return rect.width() + "," + rect.height();
    }

    public void notifyScreenMetrics(@NonNull MraidScreenMetrics screenMetrics) {
        this.injectJavaScript("mraidbridge.setScreenSize(" + this.stringifySize(screenMetrics.getScreenRectDips()) + ");mraidbridge.setMaxSize(" + this.stringifySize(screenMetrics.getRootViewRectDips()) + ");mraidbridge.setCurrentPosition(" + this.stringifyRect(screenMetrics.getCurrentAdRectDips()) + ");mraidbridge.setDefaultPosition(" + this.stringifyRect(screenMetrics.getDefaultAdRectDips()) + ")");
        this.injectJavaScript("mraidbridge.notifySizeChangeEvent(" + this.stringifySize(screenMetrics.getCurrentAdRectDips()) + ")");
    }

    void notifyReady() {
        this.injectJavaScript("mraidbridge.notifyReadyEvent();");
    }

    boolean isClicked() {
        return this.mIsClicked;
    }

    boolean isViewable() {
        MraidWebView mraidWebView = this.mMraidWebView;
        return mraidWebView != null && mraidWebView.isMraidViewable();
    }

    boolean isAttached() {
        return this.mMraidWebView != null;
    }

    boolean isLoaded() {
        return this.mHasLoaded;
    }

    @VisibleForTesting
    MraidWebView getMraidWebView() {
        return this.mMraidWebView;
    }

    @VisibleForTesting
    void setClicked(boolean clicked) {
        this.mIsClicked = clicked;
    }

    public static class MraidWebView
    extends BaseWebView {
        private static final int DEFAULT_MIN_VISIBLE_PX = 1;
        @Nullable
        private OnVisibilityChangedListener mOnVisibilityChangedListener;
        @Nullable
        private VisibilityTracker mVisibilityTracker;
        private boolean mMraidViewable;

        public MraidWebView(Context context) {
            super(context);
            this.mVisibilityTracker = new VisibilityTracker(context);
            VisibilityTracker.VisibilityTrackerListener visibilityTrackerListener = new VisibilityTracker.VisibilityTrackerListener(){

                @Override
                public void onVisibilityChanged(@NonNull List<View> visibleViews, @NonNull List<View> invisibleViews) {
                    Preconditions.checkNotNull(visibleViews);
                    Preconditions.checkNotNull(invisibleViews);
                    MraidWebView.this.setMraidViewable(visibleViews.contains((Object)MraidWebView.this));
                }
            };
            this.mVisibilityTracker.setVisibilityTrackerListener(visibilityTrackerListener);
        }

        void setVisibilityChangedListener(@Nullable OnVisibilityChangedListener listener) {
            this.mOnVisibilityChangedListener = listener;
        }

        protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
            super.onVisibilityChanged(changedView, visibility);
            if (this.mVisibilityTracker == null) {
                this.setMraidViewable(visibility == 0);
                return;
            }
            if (visibility == 0) {
                this.mVisibilityTracker.clear();
                this.mVisibilityTracker.addView(changedView, (View)this, 0, 0, 1);
            } else {
                this.mVisibilityTracker.removeView((View)this);
                this.setMraidViewable(false);
            }
        }

        private void setMraidViewable(boolean viewable) {
            if (this.mMraidViewable == viewable) {
                return;
            }
            this.mMraidViewable = viewable;
            if (this.mOnVisibilityChangedListener != null) {
                this.mOnVisibilityChangedListener.onVisibilityChanged(viewable);
            }
        }

        public boolean isMraidViewable() {
            return this.mMraidViewable;
        }

        @Override
        public void destroy() {
            super.destroy();
            this.mVisibilityTracker = null;
            this.mOnVisibilityChangedListener = null;
        }

        public static interface OnVisibilityChangedListener {
            public void onVisibilityChanged(boolean var1);
        }
    }

    public static interface MraidBridgeListener {
        public void onPageLoaded();

        public void onPageFailedToLoad();

        public void onVisibilityChanged(boolean var1);

        public boolean onJsAlert(@NonNull String var1, @NonNull JsResult var2);

        public boolean onConsoleMessage(@NonNull ConsoleMessage var1);

        public void onResize(int var1, int var2, int var3, int var4, @NonNull CloseableLayout.ClosePosition var5, boolean var6) throws MraidCommandException;

        public void onExpand(URI var1, boolean var2) throws MraidCommandException;

        public void onClose();

        public void onUseCustomClose(boolean var1);

        public void onSetOrientationProperties(boolean var1, MraidOrientation var2) throws MraidCommandException;

        public void onOpen(URI var1);

        public void onPlayVideo(URI var1);
    }
}

