/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.ExternalViewabilitySessionManager;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.BaseWebView;
import com.mopub.mobileads.Interstitial;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class WebViewCacheService {
    @VisibleForTesting
    static final int MAX_SIZE = 50;
    @VisibleForTesting
    static final long TRIM_CACHE_FREQUENCY_MILLIS = 900000L;
    @SuppressLint(value={"UseSparseArrays"})
    @NonNull
    private static final Map<Long, Config> sWebViewConfigs = Collections.synchronizedMap(new HashMap());
    @VisibleForTesting
    @NonNull
    static final TrimCacheRunnable sTrimCacheRunnable = new TrimCacheRunnable();
    @NonNull
    private static Handler sHandler = new Handler();

    private WebViewCacheService() {
    }

    @VisibleForTesting
    public static void storeWebViewConfig(@NonNull Long broadcastIdentifier, @NonNull Interstitial baseInterstitial, @NonNull BaseWebView baseWebView, @NonNull ExternalViewabilitySessionManager viewabilityManager) {
        Preconditions.checkNotNull(broadcastIdentifier);
        Preconditions.checkNotNull(baseInterstitial);
        Preconditions.checkNotNull((Object)baseWebView);
        WebViewCacheService.trimCache();
        if (sWebViewConfigs.size() >= 50) {
            MoPubLog.w("Unable to cache web view. Please destroy some via MoPubInterstitial#destroy() and try again.");
            return;
        }
        sWebViewConfigs.put(broadcastIdentifier, new Config(baseWebView, baseInterstitial, viewabilityManager));
    }

    @Nullable
    public static Config popWebViewConfig(@NonNull Long broadcastIdentifier) {
        Preconditions.checkNotNull(broadcastIdentifier);
        return sWebViewConfigs.remove(broadcastIdentifier);
    }

    @VisibleForTesting
    static synchronized void trimCache() {
        Iterator<Map.Entry<Long, Config>> iterator = sWebViewConfigs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, Config> entry = iterator.next();
            if (entry.getValue().getWeakInterstitial().get() != null) continue;
            entry.getValue().getViewabilityManager().endDisplaySession();
            iterator.remove();
        }
        if (!sWebViewConfigs.isEmpty()) {
            sHandler.removeCallbacks((Runnable)sTrimCacheRunnable);
            sHandler.postDelayed((Runnable)sTrimCacheRunnable, 900000L);
        }
    }

    @Deprecated
    @VisibleForTesting
    public static void clearAll() {
        sWebViewConfigs.clear();
        sHandler.removeCallbacks((Runnable)sTrimCacheRunnable);
    }

    @Deprecated
    @VisibleForTesting
    @NonNull
    static Map<Long, Config> getWebViewConfigs() {
        return sWebViewConfigs;
    }

    @Deprecated
    @VisibleForTesting
    static void setHandler(@NonNull Handler handler) {
        sHandler = handler;
    }

    private static class TrimCacheRunnable
    implements Runnable {
        private TrimCacheRunnable() {
        }

        @Override
        public void run() {
            WebViewCacheService.trimCache();
        }
    }

    public static class Config {
        @NonNull
        private final BaseWebView mWebView;
        @NonNull
        private final WeakReference<Interstitial> mWeakInterstitial;
        @NonNull
        private final ExternalViewabilitySessionManager mViewabilityManager;

        Config(@NonNull BaseWebView baseWebView, @NonNull Interstitial baseInterstitial, @NonNull ExternalViewabilitySessionManager viewabilityManager) {
            this.mWebView = baseWebView;
            this.mWeakInterstitial = new WeakReference<Interstitial>(baseInterstitial);
            this.mViewabilityManager = viewabilityManager;
        }

        @NonNull
        public BaseWebView getWebView() {
            return this.mWebView;
        }

        @NonNull
        public WeakReference<Interstitial> getWeakInterstitial() {
            return this.mWeakInterstitial;
        }

        @NonNull
        public ExternalViewabilitySessionManager getViewabilityManager() {
            return this.mViewabilityManager;
        }
    }
}

