/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.CacheService;
import com.mopub.common.MoPubHttpUrlConnection;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.AsyncTasks;
import com.mopub.common.util.Streams;
import java.io.BufferedInputStream;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.util.ArrayDeque;
import java.util.Deque;

public class VideoDownloader {
    private static final int MAX_VIDEO_SIZE = 0x1900000;
    private static final Deque<WeakReference<VideoDownloaderTask>> sDownloaderTasks = new ArrayDeque<WeakReference<VideoDownloaderTask>>();

    private VideoDownloader() {
    }

    public static void cache(@Nullable String url, @NonNull VideoDownloaderListener listener) {
        Preconditions.checkNotNull(listener);
        if (url == null) {
            MoPubLog.d("VideoDownloader attempted to cache video with null url.");
            listener.onComplete(false);
            return;
        }
        VideoDownloaderTask videoDownloaderTask = new VideoDownloaderTask(listener);
        try {
            AsyncTasks.safeExecuteOnExecutor(videoDownloaderTask, url);
        }
        catch (Exception e) {
            listener.onComplete(false);
        }
    }

    public static void cancelAllDownloaderTasks() {
        for (WeakReference<VideoDownloaderTask> weakDownloaderTask : sDownloaderTasks) {
            VideoDownloader.cancelOneTask(weakDownloaderTask);
        }
        sDownloaderTasks.clear();
    }

    public static void cancelLastDownloadTask() {
        if (sDownloaderTasks.isEmpty()) {
            return;
        }
        VideoDownloader.cancelOneTask(sDownloaderTasks.peekLast());
        sDownloaderTasks.removeLast();
    }

    private static boolean cancelOneTask(@Nullable WeakReference<VideoDownloaderTask> weakDownloaderTask) {
        if (weakDownloaderTask == null) {
            return false;
        }
        VideoDownloaderTask downloaderTask = (VideoDownloaderTask)((Object)weakDownloaderTask.get());
        if (downloaderTask == null) {
            return false;
        }
        return downloaderTask.cancel(true);
    }

    @Deprecated
    @VisibleForTesting
    public static Deque<WeakReference<VideoDownloaderTask>> getDownloaderTasks() {
        return sDownloaderTasks;
    }

    @Deprecated
    @VisibleForTesting
    public static void clearDownloaderTasks() {
        sDownloaderTasks.clear();
    }

    @VisibleForTesting
    static class VideoDownloaderTask
    extends AsyncTask<String, Void, Boolean> {
        @NonNull
        private final VideoDownloaderListener mListener;
        @NonNull
        private final WeakReference<VideoDownloaderTask> mWeakSelf;

        @VisibleForTesting
        VideoDownloaderTask(@NonNull VideoDownloaderListener listener) {
            this.mListener = listener;
            this.mWeakSelf = new WeakReference<VideoDownloaderTask>(this);
            sDownloaderTasks.add(this.mWeakSelf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground(String ... params) {
            Boolean bl;
            BufferedInputStream inputStream;
            HttpURLConnection urlConnection;
            String videoUrl;
            block13: {
                block12: {
                    if (params == null || params.length == 0 || params[0] == null) {
                        MoPubLog.d("VideoDownloader task tried to execute null or empty url.");
                        return false;
                    }
                    videoUrl = params[0];
                    urlConnection = null;
                    inputStream = null;
                    urlConnection = MoPubHttpUrlConnection.getHttpUrlConnection(videoUrl);
                    inputStream = new BufferedInputStream(urlConnection.getInputStream());
                    int statusCode = urlConnection.getResponseCode();
                    if (statusCode >= 200 && statusCode < 300) break block12;
                    MoPubLog.d("VideoDownloader encountered unexpected statusCode: " + statusCode);
                    Boolean bl2 = false;
                    Streams.closeStream(inputStream);
                    if (urlConnection != null) {
                        urlConnection.disconnect();
                    }
                    return bl2;
                }
                int contentLength = urlConnection.getContentLength();
                if (contentLength <= 0x1900000) break block13;
                MoPubLog.d(String.format("VideoDownloader encountered video larger than disk cap. (%d bytes / %d maximum).", contentLength, 0x1900000));
                Boolean bl3 = false;
                Streams.closeStream(inputStream);
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                return bl3;
            }
            try {
                boolean diskPutResult = CacheService.putToDiskCache(videoUrl, inputStream);
                bl = diskPutResult;
            }
            catch (Exception e) {
                Boolean bl4;
                try {
                    MoPubLog.d("VideoDownloader task threw an internal exception.", e);
                    bl4 = false;
                }
                catch (Throwable throwable) {
                    Streams.closeStream(inputStream);
                    if (urlConnection != null) {
                        urlConnection.disconnect();
                    }
                    throw throwable;
                }
                Streams.closeStream(inputStream);
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                return bl4;
            }
            Streams.closeStream(inputStream);
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            return bl;
        }

        protected void onPostExecute(Boolean success) {
            if (this.isCancelled()) {
                this.onCancelled();
                return;
            }
            sDownloaderTasks.remove(this.mWeakSelf);
            if (success == null) {
                this.mListener.onComplete(false);
                return;
            }
            this.mListener.onComplete(success);
        }

        protected void onCancelled() {
            MoPubLog.d("VideoDownloader task was cancelled.");
            sDownloaderTasks.remove(this.mWeakSelf);
            this.mListener.onComplete(false);
        }
    }

    static interface VideoDownloaderListener {
        public void onComplete(boolean var1);
    }
}

