/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.graphics.Point;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.Display;
import android.view.WindowManager;
import com.mopub.common.MoPubHttpUrlConnection;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Dips;
import com.mopub.common.util.Streams;
import com.mopub.common.util.Strings;
import com.mopub.mobileads.VastAdXmlManager;
import com.mopub.mobileads.VastBaseInLineWrapperXmlManager;
import com.mopub.mobileads.VastCompanionAdConfig;
import com.mopub.mobileads.VastCompanionAdXmlManager;
import com.mopub.mobileads.VastErrorCode;
import com.mopub.mobileads.VastExtensionParentXmlManager;
import com.mopub.mobileads.VastExtensionXmlManager;
import com.mopub.mobileads.VastIconConfig;
import com.mopub.mobileads.VastIconXmlManager;
import com.mopub.mobileads.VastInLineXmlManager;
import com.mopub.mobileads.VastLinearXmlManager;
import com.mopub.mobileads.VastMediaXmlManager;
import com.mopub.mobileads.VastResource;
import com.mopub.mobileads.VastTracker;
import com.mopub.mobileads.VastVideoConfig;
import com.mopub.mobileads.VastWrapperXmlManager;
import com.mopub.mobileads.VastXmlManager;
import com.mopub.network.Networking;
import com.mopub.network.TrackingRequest;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VastXmlManagerAggregator
extends AsyncTask<String, Void, VastVideoConfig> {
    private static final String MOPUB = "MoPub";
    public static final String ADS_BY_AD_SLOT_ID = "adsBy";
    public static final String SOCIAL_ACTIONS_AD_SLOT_ID = "socialActions";
    static final int MAX_TIMES_TO_FOLLOW_VAST_REDIRECT = 10;
    private static final double ASPECT_RATIO_WEIGHT = 70.0;
    private static final double AREA_WEIGHT = 30.0;
    private static final List<String> VIDEO_MIME_TYPES = Arrays.asList("video/mp4", "video/3gpp");
    private static final int MINIMUM_COMPANION_AD_WIDTH = 300;
    private static final int MINIMUM_COMPANION_AD_HEIGHT = 250;
    @NonNull
    private final WeakReference<VastXmlManagerAggregatorListener> mVastXmlManagerAggregatorListener;
    private final double mScreenAspectRatio;
    private final int mScreenAreaDp;
    @NonNull
    private final Context mContext;
    private int mTimesFollowedVastRedirect;

    VastXmlManagerAggregator(@NonNull VastXmlManagerAggregatorListener vastXmlManagerAggregatorListener, double screenAspectRatio, int screenAreaDp, @NonNull Context context) {
        Preconditions.checkNotNull(vastXmlManagerAggregatorListener);
        Preconditions.checkNotNull(context);
        this.mVastXmlManagerAggregatorListener = new WeakReference<VastXmlManagerAggregatorListener>(vastXmlManagerAggregatorListener);
        this.mScreenAspectRatio = screenAspectRatio;
        this.mScreenAreaDp = screenAreaDp;
        this.mContext = context.getApplicationContext();
    }

    protected void onPreExecute() {
        Networking.getUserAgent(this.mContext);
    }

    protected VastVideoConfig doInBackground(String ... strings) {
        if (strings == null || strings.length == 0 || strings[0] == null) {
            return null;
        }
        try {
            String vastXml = strings[0];
            return this.evaluateVastXmlManager(vastXml, new ArrayList<VastTracker>());
        }
        catch (Exception e) {
            MoPubLog.d("Unable to generate VastVideoConfig.", e);
            return null;
        }
    }

    protected void onPostExecute(@Nullable VastVideoConfig vastVideoConfig) {
        VastXmlManagerAggregatorListener listener = (VastXmlManagerAggregatorListener)this.mVastXmlManagerAggregatorListener.get();
        if (listener != null) {
            listener.onAggregationComplete(vastVideoConfig);
        }
    }

    protected void onCancelled() {
        VastXmlManagerAggregatorListener listener = (VastXmlManagerAggregatorListener)this.mVastXmlManagerAggregatorListener.get();
        if (listener != null) {
            listener.onAggregationComplete(null);
        }
    }

    @VisibleForTesting
    @Nullable
    VastVideoConfig evaluateVastXmlManager(@NonNull String vastXml, @NonNull List<VastTracker> errorTrackers) {
        Preconditions.checkNotNull(vastXml, "vastXml cannot be null");
        Preconditions.checkNotNull(errorTrackers, "errorTrackers cannot be null");
        VastXmlManager xmlManager = new VastXmlManager();
        try {
            xmlManager.parseVastXml(vastXml);
        }
        catch (Exception e) {
            MoPubLog.d("Failed to parse VAST XML", e);
            TrackingRequest.makeVastTrackingHttpRequest(errorTrackers, VastErrorCode.XML_PARSING_ERROR, null, null, this.mContext);
            return null;
        }
        List<VastAdXmlManager> vastAdXmlManagers = xmlManager.getAdXmlManagers();
        if (this.fireErrorTrackerIfNoAds(vastAdXmlManagers, xmlManager, this.mContext)) {
            return null;
        }
        for (VastAdXmlManager vastAdXmlManager : vastAdXmlManagers) {
            VastVideoConfig vastVideoConfig;
            VastVideoConfig vastVideoConfig2;
            if (!VastXmlManagerAggregator.isValidSequenceNumber(vastAdXmlManager.getSequence())) continue;
            VastInLineXmlManager vastInLineXmlManager = vastAdXmlManager.getInLineXmlManager();
            if (vastInLineXmlManager != null && (vastVideoConfig2 = this.evaluateInLineXmlManager(vastInLineXmlManager, errorTrackers)) != null) {
                this.populateMoPubCustomElements(xmlManager, vastVideoConfig2);
                return vastVideoConfig2;
            }
            VastWrapperXmlManager vastWrapperXmlManager = vastAdXmlManager.getWrapperXmlManager();
            if (vastWrapperXmlManager == null) continue;
            ArrayList<VastTracker> wrapperErrorTrackers = new ArrayList<VastTracker>(errorTrackers);
            wrapperErrorTrackers.addAll(vastWrapperXmlManager.getErrorTrackers());
            String vastRedirectXml = this.evaluateWrapperRedirect(vastWrapperXmlManager, wrapperErrorTrackers);
            if (vastRedirectXml == null || (vastVideoConfig = this.evaluateVastXmlManager(vastRedirectXml, wrapperErrorTrackers)) == null) continue;
            vastVideoConfig.addImpressionTrackers(vastWrapperXmlManager.getImpressionTrackers());
            List<VastLinearXmlManager> linearXmlManagers = vastWrapperXmlManager.getLinearXmlManagers();
            for (VastLinearXmlManager linearXmlManager : linearXmlManagers) {
                this.populateLinearTrackersAndIcon(linearXmlManager, vastVideoConfig);
            }
            this.populateVideoViewabilityTracker(vastWrapperXmlManager, vastVideoConfig);
            this.populateViewabilityMetadata(vastWrapperXmlManager, vastVideoConfig);
            List<VastCompanionAdXmlManager> companionAdXmlManagers = vastWrapperXmlManager.getCompanionAdXmlManagers();
            if (!vastVideoConfig.hasCompanionAd()) {
                vastVideoConfig.setVastCompanionAd(this.getBestCompanionAd(companionAdXmlManagers, CompanionOrientation.LANDSCAPE), this.getBestCompanionAd(companionAdXmlManagers, CompanionOrientation.PORTRAIT));
            } else {
                VastCompanionAdConfig landscapeCompanionAd = vastVideoConfig.getVastCompanionAd(2);
                VastCompanionAdConfig portraitCompanionAd = vastVideoConfig.getVastCompanionAd(1);
                if (landscapeCompanionAd != null && portraitCompanionAd != null) {
                    for (VastCompanionAdXmlManager companionAdXmlManager : companionAdXmlManagers) {
                        if (companionAdXmlManager.hasResources()) continue;
                        landscapeCompanionAd.addClickTrackers(companionAdXmlManager.getClickTrackers());
                        landscapeCompanionAd.addCreativeViewTrackers(companionAdXmlManager.getCompanionCreativeViewTrackers());
                        portraitCompanionAd.addClickTrackers(companionAdXmlManager.getClickTrackers());
                        portraitCompanionAd.addCreativeViewTrackers(companionAdXmlManager.getCompanionCreativeViewTrackers());
                    }
                }
            }
            if (vastVideoConfig.getSocialActionsCompanionAds().isEmpty()) {
                vastVideoConfig.setSocialActionsCompanionAds(this.getSocialActionsCompanionAds(companionAdXmlManagers));
            }
            this.populateMoPubCustomElements(xmlManager, vastVideoConfig);
            return vastVideoConfig;
        }
        return null;
    }

    @Nullable
    private VastVideoConfig evaluateInLineXmlManager(@NonNull VastInLineXmlManager vastInLineXmlManager, @NonNull List<VastTracker> errorTrackers) {
        Preconditions.checkNotNull(vastInLineXmlManager);
        Preconditions.checkNotNull(errorTrackers);
        List<VastLinearXmlManager> linearXmlManagers = vastInLineXmlManager.getLinearXmlManagers();
        for (VastLinearXmlManager linearXmlManager : linearXmlManagers) {
            String bestMediaFileUrl = this.getBestMediaFileUrl(linearXmlManager.getMediaXmlManagers());
            if (bestMediaFileUrl == null) continue;
            VastVideoConfig vastVideoConfig = new VastVideoConfig();
            vastVideoConfig.addImpressionTrackers(vastInLineXmlManager.getImpressionTrackers());
            this.populateLinearTrackersAndIcon(linearXmlManager, vastVideoConfig);
            vastVideoConfig.setClickThroughUrl(linearXmlManager.getClickThroughUrl());
            vastVideoConfig.setNetworkMediaFileUrl(bestMediaFileUrl);
            List<VastCompanionAdXmlManager> companionAdXmlManagers = vastInLineXmlManager.getCompanionAdXmlManagers();
            vastVideoConfig.setVastCompanionAd(this.getBestCompanionAd(companionAdXmlManagers, CompanionOrientation.LANDSCAPE), this.getBestCompanionAd(companionAdXmlManagers, CompanionOrientation.PORTRAIT));
            vastVideoConfig.setSocialActionsCompanionAds(this.getSocialActionsCompanionAds(companionAdXmlManagers));
            errorTrackers.addAll(vastInLineXmlManager.getErrorTrackers());
            vastVideoConfig.addErrorTrackers(errorTrackers);
            this.populateVideoViewabilityTracker(vastInLineXmlManager, vastVideoConfig);
            this.populateViewabilityMetadata(vastInLineXmlManager, vastVideoConfig);
            return vastVideoConfig;
        }
        return null;
    }

    private void populateVideoViewabilityTracker(@NonNull VastBaseInLineWrapperXmlManager vastInLineXmlManager, @NonNull VastVideoConfig vastVideoConfig) {
        Preconditions.checkNotNull(vastInLineXmlManager);
        Preconditions.checkNotNull(vastVideoConfig);
        if (vastVideoConfig.getVideoViewabilityTracker() != null) {
            return;
        }
        VastExtensionParentXmlManager vastExtensionParentXmlManager = vastInLineXmlManager.getVastExtensionParentXmlManager();
        if (vastExtensionParentXmlManager != null) {
            List<VastExtensionXmlManager> vastExtensionXmlManagers = vastExtensionParentXmlManager.getVastExtensionXmlManagers();
            for (VastExtensionXmlManager vastExtensionXmlManager : vastExtensionXmlManagers) {
                if (!MOPUB.equals(vastExtensionXmlManager.getType())) continue;
                vastVideoConfig.setVideoViewabilityTracker(vastExtensionXmlManager.getVideoViewabilityTracker());
                break;
            }
        }
    }

    private void populateViewabilityMetadata(@NonNull VastBaseInLineWrapperXmlManager vastInLineXmlManager, @NonNull VastVideoConfig vastVideoConfig) {
        VastExtensionParentXmlManager vastExtensionParentXmlManager = vastInLineXmlManager.getVastExtensionParentXmlManager();
        if (vastExtensionParentXmlManager != null) {
            List<VastExtensionXmlManager> vastExtensionXmlManagers = vastExtensionParentXmlManager.getVastExtensionXmlManagers();
            for (VastExtensionXmlManager vastExtensionXmlManager : vastExtensionXmlManagers) {
                if (vastExtensionXmlManager == null) continue;
                Set<String> avid = vastExtensionXmlManager.getAvidJavaScriptResources();
                vastVideoConfig.addAvidJavascriptResources(avid);
                Set<String> moat = vastExtensionXmlManager.getMoatImpressionPixels();
                vastVideoConfig.addMoatImpressionPixels(moat);
            }
        }
    }

    @Nullable
    private String evaluateWrapperRedirect(@NonNull VastWrapperXmlManager vastWrapperXmlManager, @NonNull List<VastTracker> wrapperErrorTrackers) {
        String vastRedirectXml;
        block3: {
            String vastAdTagUri = vastWrapperXmlManager.getVastAdTagURI();
            if (vastAdTagUri == null) {
                return null;
            }
            vastRedirectXml = null;
            try {
                vastRedirectXml = this.followVastRedirect(vastAdTagUri);
            }
            catch (Exception e) {
                MoPubLog.d("Failed to follow VAST redirect", e);
                if (wrapperErrorTrackers.isEmpty()) break block3;
                TrackingRequest.makeVastTrackingHttpRequest(wrapperErrorTrackers, VastErrorCode.WRAPPER_TIMEOUT, null, null, this.mContext);
            }
        }
        return vastRedirectXml;
    }

    private void populateLinearTrackersAndIcon(@NonNull VastLinearXmlManager linearXmlManager, @NonNull VastVideoConfig vastVideoConfig) {
        Preconditions.checkNotNull(linearXmlManager, "linearXmlManager cannot be null");
        Preconditions.checkNotNull(vastVideoConfig, "vastVideoConfig cannot be null");
        vastVideoConfig.addAbsoluteTrackers(linearXmlManager.getAbsoluteProgressTrackers());
        vastVideoConfig.addFractionalTrackers(linearXmlManager.getFractionalProgressTrackers());
        vastVideoConfig.addPauseTrackers(linearXmlManager.getPauseTrackers());
        vastVideoConfig.addResumeTrackers(linearXmlManager.getResumeTrackers());
        vastVideoConfig.addCompleteTrackers(linearXmlManager.getVideoCompleteTrackers());
        vastVideoConfig.addCloseTrackers(linearXmlManager.getVideoCloseTrackers());
        vastVideoConfig.addSkipTrackers(linearXmlManager.getVideoSkipTrackers());
        vastVideoConfig.addClickTrackers(linearXmlManager.getClickTrackers());
        if (vastVideoConfig.getSkipOffsetString() == null) {
            vastVideoConfig.setSkipOffset(linearXmlManager.getSkipOffset());
        }
        if (vastVideoConfig.getVastIconConfig() == null) {
            vastVideoConfig.setVastIconConfig(this.getBestIcon(linearXmlManager.getIconXmlManagers()));
        }
    }

    private void populateMoPubCustomElements(@NonNull VastXmlManager xmlManager, @NonNull VastVideoConfig vastVideoConfig) {
        Preconditions.checkNotNull(xmlManager, "xmlManager cannot be null");
        Preconditions.checkNotNull(vastVideoConfig, "vastVideoConfig cannot be null");
        vastVideoConfig.addImpressionTrackers(xmlManager.getMoPubImpressionTrackers());
        if (vastVideoConfig.getCustomCtaText() == null) {
            vastVideoConfig.setCustomCtaText(xmlManager.getCustomCtaText());
        }
        if (vastVideoConfig.getCustomSkipText() == null) {
            vastVideoConfig.setCustomSkipText(xmlManager.getCustomSkipText());
        }
        if (vastVideoConfig.getCustomCloseIconUrl() == null) {
            vastVideoConfig.setCustomCloseIconUrl(xmlManager.getCustomCloseIconUrl());
        }
        if (!vastVideoConfig.isCustomForceOrientationSet()) {
            vastVideoConfig.setCustomForceOrientation(xmlManager.getCustomForceOrientation());
        }
    }

    private boolean fireErrorTrackerIfNoAds(@NonNull List<VastAdXmlManager> vastAdXmlManagers, @NonNull VastXmlManager xmlManager, @NonNull Context context) {
        if (vastAdXmlManagers.isEmpty() && xmlManager.getErrorTracker() != null) {
            TrackingRequest.makeVastTrackingHttpRequest(Collections.singletonList(xmlManager.getErrorTracker()), this.mTimesFollowedVastRedirect > 0 ? VastErrorCode.NO_ADS_VAST_RESPONSE : VastErrorCode.UNDEFINED_ERROR, null, null, context);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    @Nullable
    String getBestMediaFileUrl(@NonNull List<VastMediaXmlManager> managers) {
        Preconditions.checkNotNull(managers, "managers cannot be null");
        ArrayList<VastMediaXmlManager> mediaXmlManagers = new ArrayList<VastMediaXmlManager>(managers);
        double bestMediaFitness = Double.POSITIVE_INFINITY;
        String bestMediaFileUrl = null;
        Iterator xmlManagerIterator = mediaXmlManagers.iterator();
        while (xmlManagerIterator.hasNext()) {
            double mediaFitness;
            VastMediaXmlManager mediaXmlManager = (VastMediaXmlManager)xmlManagerIterator.next();
            String mediaType = mediaXmlManager.getType();
            String mediaUrl = mediaXmlManager.getMediaUrl();
            if (!VIDEO_MIME_TYPES.contains(mediaType) || mediaUrl == null) {
                xmlManagerIterator.remove();
                continue;
            }
            Integer mediaWidth = mediaXmlManager.getWidth();
            Integer mediaHeight = mediaXmlManager.getHeight();
            if (mediaWidth == null || mediaWidth <= 0 || mediaHeight == null || mediaHeight <= 0 || !((mediaFitness = this.calculateFitness(mediaWidth, mediaHeight)) < bestMediaFitness)) continue;
            bestMediaFitness = mediaFitness;
            bestMediaFileUrl = mediaUrl;
        }
        return bestMediaFileUrl;
    }

    @VisibleForTesting
    @Nullable
    VastCompanionAdConfig getBestCompanionAd(@NonNull List<VastCompanionAdXmlManager> managers, @NonNull CompanionOrientation orientation) {
        Preconditions.checkNotNull(managers, "managers cannot be null");
        Preconditions.checkNotNull((Object)orientation, "orientation cannot be null");
        ArrayList<VastCompanionAdXmlManager> companionXmlManagers = new ArrayList<VastCompanionAdXmlManager>(managers);
        double bestCompanionFitness = Double.POSITIVE_INFINITY;
        VastCompanionAdXmlManager bestCompanionXmlManager = null;
        VastResource bestVastResource = null;
        Point bestVastScaledDimensions = null;
        for (VastResource.Type type : VastResource.Type.values()) {
            for (VastCompanionAdXmlManager companionXmlManager : companionXmlManagers) {
                double companionFitness;
                Integer width = companionXmlManager.getWidth();
                Integer height = companionXmlManager.getHeight();
                if (width == null || width < 300 || height == null || height < 250) continue;
                Point vastScaledDimensions = this.getScaledDimensions(width, height, type, orientation);
                VastResource vastResource = VastResource.fromVastResourceXmlManager(companionXmlManager.getResourceXmlManager(), type, vastScaledDimensions.x, vastScaledDimensions.y);
                if (vastResource == null || !((companionFitness = CompanionOrientation.PORTRAIT == orientation ? this.calculateFitness(height, width) : this.calculateFitness(width, height)) < bestCompanionFitness)) continue;
                bestCompanionFitness = companionFitness;
                bestCompanionXmlManager = companionXmlManager;
                bestVastResource = vastResource;
                bestVastScaledDimensions = vastScaledDimensions;
            }
            if (bestCompanionXmlManager != null) break;
        }
        if (bestCompanionXmlManager != null) {
            return new VastCompanionAdConfig(bestVastScaledDimensions.x, bestVastScaledDimensions.y, bestVastResource, bestCompanionXmlManager.getClickThroughUrl(), bestCompanionXmlManager.getClickTrackers(), bestCompanionXmlManager.getCompanionCreativeViewTrackers());
        }
        return null;
    }

    @VisibleForTesting
    @NonNull
    Map<String, VastCompanionAdConfig> getSocialActionsCompanionAds(@NonNull List<VastCompanionAdXmlManager> managers) {
        Preconditions.checkNotNull(managers, "managers cannot be null");
        HashMap<String, VastCompanionAdConfig> socialActionsCompanionAds = new HashMap<String, VastCompanionAdConfig>();
        for (VastCompanionAdXmlManager companionXmlManager : managers) {
            String adSlotId;
            Integer width = companionXmlManager.getWidth();
            Integer height = companionXmlManager.getHeight();
            if (width == null || height == null || (!ADS_BY_AD_SLOT_ID.equals(adSlotId = companionXmlManager.getAdSlotId()) ? !SOCIAL_ACTIONS_AD_SLOT_ID.equals(adSlotId) || width < 50 || width > 150 || height < 10 || height > 50 : width < 25 || width > 75 || height < 10 || height > 50)) continue;
            VastResource vastResource = VastResource.fromVastResourceXmlManager(companionXmlManager.getResourceXmlManager(), VastResource.Type.HTML_RESOURCE, width, height);
            if (vastResource == null) continue;
            socialActionsCompanionAds.put(adSlotId, new VastCompanionAdConfig(width, height, vastResource, companionXmlManager.getClickThroughUrl(), companionXmlManager.getClickTrackers(), companionXmlManager.getCompanionCreativeViewTrackers()));
        }
        return socialActionsCompanionAds;
    }

    @VisibleForTesting
    @NonNull
    Point getScaledDimensions(int widthDp, int heightDp, VastResource.Type type, CompanionOrientation orientation) {
        int screenHeightPx;
        int screenWidthPx;
        Point defaultPoint = new Point(widthDp, heightDp);
        Display display = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay();
        int x = display.getWidth();
        int y = display.getHeight();
        int widthPx = Dips.dipsToIntPixels(widthDp, this.mContext);
        int heightPx = Dips.dipsToIntPixels(heightDp, this.mContext);
        if (CompanionOrientation.LANDSCAPE == orientation) {
            screenWidthPx = Math.max(x, y);
            screenHeightPx = Math.min(x, y);
        } else {
            screenWidthPx = Math.min(x, y);
            screenHeightPx = Math.max(x, y);
        }
        if (widthPx <= screenWidthPx - 16 && heightPx <= screenHeightPx - 16) {
            return defaultPoint;
        }
        Point point = new Point();
        if (VastResource.Type.HTML_RESOURCE == type) {
            point.x = Math.min(screenWidthPx, widthPx);
            point.y = Math.min(screenHeightPx, heightPx);
        } else {
            float widthRatio = (float)widthPx / (float)screenWidthPx;
            float heightRatio = (float)heightPx / (float)screenHeightPx;
            if (widthRatio >= heightRatio) {
                point.x = screenWidthPx;
                point.y = (int)((float)heightPx / widthRatio);
            } else {
                point.x = (int)((float)widthPx / heightRatio);
                point.y = screenHeightPx;
            }
        }
        point.x -= 16;
        point.y -= 16;
        if (point.x < 0 || point.y < 0) {
            return defaultPoint;
        }
        point.x = Dips.pixelsToIntDips(point.x, this.mContext);
        point.y = Dips.pixelsToIntDips(point.y, this.mContext);
        return point;
    }

    @VisibleForTesting
    @Nullable
    VastIconConfig getBestIcon(@NonNull List<VastIconXmlManager> managers) {
        Preconditions.checkNotNull(managers, "managers cannot be null");
        ArrayList<VastIconXmlManager> iconXmlManagers = new ArrayList<VastIconXmlManager>(managers);
        for (VastResource.Type type : VastResource.Type.values()) {
            for (VastIconXmlManager iconXmlManager : iconXmlManagers) {
                VastResource vastResource;
                Integer width = iconXmlManager.getWidth();
                Integer height = iconXmlManager.getHeight();
                if (width == null || width <= 0 || width > 300 || height == null || height <= 0 || height > 300 || (vastResource = VastResource.fromVastResourceXmlManager(iconXmlManager.getResourceXmlManager(), type, width, height)) == null) continue;
                return new VastIconConfig(iconXmlManager.getWidth(), iconXmlManager.getHeight(), iconXmlManager.getOffsetMS(), iconXmlManager.getDurationMS(), vastResource, iconXmlManager.getClickTrackingUris(), iconXmlManager.getClickThroughUri(), iconXmlManager.getViewTrackingUris());
            }
        }
        return null;
    }

    private double calculateFitness(int widthDp, int heightDp) {
        double mediaAspectRatio = (double)widthDp / (double)heightDp;
        int mediaAreaDp = widthDp * heightDp;
        double aspectRatioRatio = mediaAspectRatio / this.mScreenAspectRatio;
        double areaRatio = (double)mediaAreaDp / (double)this.mScreenAreaDp;
        return 70.0 * Math.abs(Math.log(aspectRatioRatio)) + 30.0 * Math.abs(Math.log(areaRatio));
    }

    static boolean isValidSequenceNumber(@Nullable String sequence) {
        if (TextUtils.isEmpty((CharSequence)sequence)) {
            return true;
        }
        try {
            int sequenceInt = Integer.parseInt(sequence);
            return sequenceInt < 2;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String followVastRedirect(@NonNull String redirectUrl) throws IOException {
        Preconditions.checkNotNull(redirectUrl);
        if (this.mTimesFollowedVastRedirect < 10) {
            String string;
            ++this.mTimesFollowedVastRedirect;
            HttpURLConnection urlConnection = null;
            BufferedInputStream inputStream = null;
            try {
                urlConnection = MoPubHttpUrlConnection.getHttpUrlConnection(redirectUrl);
                inputStream = new BufferedInputStream(urlConnection.getInputStream());
                string = Strings.fromStream(inputStream);
            }
            catch (Throwable throwable) {
                Streams.closeStream(inputStream);
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                throw throwable;
            }
            Streams.closeStream(inputStream);
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            return string;
        }
        return null;
    }

    @Deprecated
    @VisibleForTesting
    void setTimesFollowedVastRedirect(int timesFollowedVastRedirect) {
        this.mTimesFollowedVastRedirect = timesFollowedVastRedirect;
    }

    static enum CompanionOrientation {
        LANDSCAPE,
        PORTRAIT;

    }

    static interface VastXmlManagerAggregatorListener {
        public void onAggregationComplete(@Nullable VastVideoConfig var1);
    }
}

