/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.os.Handler;
import android.support.annotation.NonNull;
import com.mopub.common.ExternalViewabilitySession;
import com.mopub.common.Preconditions;
import com.mopub.mobileads.RepeatingHandlerRunnable;
import com.mopub.mobileads.VastFractionalProgressTracker;
import com.mopub.mobileads.VastMacroHelper;
import com.mopub.mobileads.VastTracker;
import com.mopub.mobileads.VastVideoConfig;
import com.mopub.mobileads.VastVideoViewController;
import com.mopub.network.TrackingRequest;
import java.util.ArrayList;
import java.util.List;

public class VastVideoViewProgressRunnable
extends RepeatingHandlerRunnable {
    @NonNull
    private final VastVideoViewController mVideoViewController;
    @NonNull
    private final VastVideoConfig mVastVideoConfig;

    public VastVideoViewProgressRunnable(@NonNull VastVideoViewController videoViewController, @NonNull VastVideoConfig vastVideoConfig, @NonNull Handler handler) {
        super(handler);
        Preconditions.checkNotNull(videoViewController);
        Preconditions.checkNotNull(vastVideoConfig);
        this.mVideoViewController = videoViewController;
        this.mVastVideoConfig = vastVideoConfig;
        ArrayList<VastFractionalProgressTracker> trackers = new ArrayList<VastFractionalProgressTracker>();
        trackers.add(new VastFractionalProgressTracker(VastTracker.MessageType.QUARTILE_EVENT, ExternalViewabilitySession.VideoEvent.AD_STARTED.name(), 0.0f));
        trackers.add(new VastFractionalProgressTracker(VastTracker.MessageType.QUARTILE_EVENT, ExternalViewabilitySession.VideoEvent.AD_IMPRESSED.name(), 0.0f));
        trackers.add(new VastFractionalProgressTracker(VastTracker.MessageType.QUARTILE_EVENT, ExternalViewabilitySession.VideoEvent.AD_VIDEO_FIRST_QUARTILE.name(), 0.25f));
        trackers.add(new VastFractionalProgressTracker(VastTracker.MessageType.QUARTILE_EVENT, ExternalViewabilitySession.VideoEvent.AD_VIDEO_MIDPOINT.name(), 0.5f));
        trackers.add(new VastFractionalProgressTracker(VastTracker.MessageType.QUARTILE_EVENT, ExternalViewabilitySession.VideoEvent.AD_VIDEO_THIRD_QUARTILE.name(), 0.75f));
        this.mVastVideoConfig.addFractionalTrackers(trackers);
    }

    @Override
    public void doWork() {
        int videoLength = this.mVideoViewController.getDuration();
        int currentPosition = this.mVideoViewController.getCurrentPosition();
        this.mVideoViewController.updateProgressBar();
        if (videoLength > 0) {
            List<VastTracker> trackersToTrack = this.mVastVideoConfig.getUntriggeredTrackersBefore(currentPosition, videoLength);
            if (!trackersToTrack.isEmpty()) {
                ArrayList<String> trackUrls = new ArrayList<String>();
                for (VastTracker tracker : trackersToTrack) {
                    if (tracker.getMessageType() == VastTracker.MessageType.TRACKING_URL) {
                        trackUrls.add(tracker.getContent());
                    } else if (tracker.getMessageType() == VastTracker.MessageType.QUARTILE_EVENT) {
                        this.mVideoViewController.handleViewabilityQuartileEvent(tracker.getContent());
                    }
                    tracker.setTracked();
                }
                TrackingRequest.makeTrackingHttpRequest(new VastMacroHelper(trackUrls).withAssetUri(this.mVideoViewController.getNetworkMediaFileUrl()).withContentPlayHead(currentPosition).getUris(), this.mVideoViewController.getContext());
            }
            this.mVideoViewController.handleIconDisplay(currentPosition);
        }
    }
}

