/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.util.Dips;
import com.mopub.common.util.Utils;
import com.mopub.mobileads.resource.RadialCountdownDrawable;

public class VastVideoRadialCountdownWidget
extends ImageView {
    @NonNull
    private RadialCountdownDrawable mRadialCountdownDrawable;
    private int mLastProgressMilliseconds;

    public VastVideoRadialCountdownWidget(@NonNull Context context) {
        super(context);
        this.setId((int)Utils.generateUniqueId());
        int sideLength = Dips.dipsToIntPixels(45.0f, context);
        int topMargin = Dips.dipsToIntPixels(16.0f, context);
        int rightMargin = Dips.dipsToIntPixels(16.0f, context);
        int padding = Dips.dipsToIntPixels(5.0f, context);
        this.mRadialCountdownDrawable = new RadialCountdownDrawable(context);
        this.setImageDrawable(this.mRadialCountdownDrawable);
        this.setPadding(padding, padding, padding, padding);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(sideLength, sideLength);
        layoutParams.setMargins(0, topMargin, rightMargin, 0);
        layoutParams.addRule(11);
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void calibrateAndMakeVisible(int initialCountdownMilliseconds) {
        this.mRadialCountdownDrawable.setInitialCountdown(initialCountdownMilliseconds);
        this.setVisibility(0);
    }

    public void updateCountdownProgress(int initialCountdownMilliseconds, int currentProgressMilliseconds) {
        if (currentProgressMilliseconds >= this.mLastProgressMilliseconds) {
            int millisecondsUntilSkippable = initialCountdownMilliseconds - currentProgressMilliseconds;
            if (millisecondsUntilSkippable < 0) {
                this.setVisibility(8);
            } else {
                this.mRadialCountdownDrawable.updateCountdownProgress(currentProgressMilliseconds);
                this.mLastProgressMilliseconds = currentProgressMilliseconds;
            }
        }
    }

    @Deprecated
    @VisibleForTesting
    public RadialCountdownDrawable getImageViewDrawable() {
        return this.mRadialCountdownDrawable;
    }

    @Deprecated
    @VisibleForTesting
    public void setImageViewDrawable(RadialCountdownDrawable drawable) {
        this.mRadialCountdownDrawable = drawable;
    }
}

