/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.ImageView;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.ImageUtils;

public class VastVideoBlurLastVideoFrameTask
extends AsyncTask<String, Void, Boolean> {
    private static final int MICROSECONDS_PER_MILLISECOND = 1000;
    private static final int OFFSET_IN_MICROSECONDS = 200000;
    @NonNull
    private final MediaMetadataRetriever mMediaMetadataRetriever;
    @NonNull
    private final ImageView mBlurredLastVideoFrameImageView;
    private int mVideoDuration;
    @Nullable
    private Bitmap mLastVideoFrame;
    @Nullable
    private Bitmap mBlurredLastVideoFrame;

    public VastVideoBlurLastVideoFrameTask(@NonNull MediaMetadataRetriever mediaMetadataRetriever, @NonNull ImageView blurredLastVideoFrameImageView, int videoDuration) {
        this.mMediaMetadataRetriever = mediaMetadataRetriever;
        this.mBlurredLastVideoFrameImageView = blurredLastVideoFrameImageView;
        this.mVideoDuration = videoDuration;
    }

    protected Boolean doInBackground(String ... videoPaths) {
        if (videoPaths == null || videoPaths.length == 0 || videoPaths[0] == null) {
            return false;
        }
        try {
            String videoPath = videoPaths[0];
            this.mMediaMetadataRetriever.setDataSource(videoPath);
            this.mLastVideoFrame = this.mMediaMetadataRetriever.getFrameAtTime((long)(this.mVideoDuration * 1000 - 200000), 3);
            if (this.mLastVideoFrame == null) {
                return false;
            }
            this.mBlurredLastVideoFrame = ImageUtils.applyFastGaussianBlurToBitmap(this.mLastVideoFrame, 4);
            return true;
        }
        catch (Exception e) {
            MoPubLog.d("Failed to blur last video frame", e);
            return false;
        }
    }

    protected void onPostExecute(Boolean success) {
        if (this.isCancelled()) {
            this.onCancelled();
            return;
        }
        if (success != null && success.booleanValue()) {
            this.mBlurredLastVideoFrameImageView.setImageBitmap(this.mBlurredLastVideoFrame);
            this.mBlurredLastVideoFrameImageView.setImageAlpha(100);
        }
    }

    protected void onCancelled() {
        MoPubLog.d("VastVideoBlurLastVideoFrameTask was cancelled.");
    }

    @Deprecated
    @VisibleForTesting
    Bitmap getBlurredLastVideoFrame() {
        return this.mBlurredLastVideoFrame;
    }
}

