/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.support.annotation.NonNull;
import com.mopub.common.Preconditions;
import java.io.Serializable;

public class VastTracker
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final MessageType mMessageType;
    @NonNull
    private final String mContent;
    private boolean mCalled;
    private boolean mIsRepeatable;

    public VastTracker(@NonNull MessageType messageType, @NonNull String content) {
        Preconditions.checkNotNull((Object)messageType);
        Preconditions.checkNotNull(content);
        this.mMessageType = messageType;
        this.mContent = content;
    }

    public VastTracker(@NonNull String trackingUrl) {
        this(MessageType.TRACKING_URL, trackingUrl);
    }

    public VastTracker(@NonNull String trackingUrl, boolean isRepeatable) {
        this(trackingUrl);
        this.mIsRepeatable = isRepeatable;
    }

    @NonNull
    public MessageType getMessageType() {
        return this.mMessageType;
    }

    @NonNull
    public String getContent() {
        return this.mContent;
    }

    public void setTracked() {
        this.mCalled = true;
    }

    public boolean isTracked() {
        return this.mCalled;
    }

    public boolean isRepeatable() {
        return this.mIsRepeatable;
    }

    static enum MessageType {
        TRACKING_URL,
        QUARTILE_EVENT;

    }
}

