/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.support.annotation.NonNull;
import com.mopub.common.Preconditions;
import com.mopub.mobileads.VastTracker;
import java.io.Serializable;
import java.util.Locale;

public class VastFractionalProgressTracker
extends VastTracker
implements Comparable<VastFractionalProgressTracker>,
Serializable {
    private static final long serialVersionUID = 0L;
    private final float mFraction;

    public VastFractionalProgressTracker(@NonNull VastTracker.MessageType messageType, @NonNull String content, float trackingFraction) {
        super(messageType, content);
        Preconditions.checkArgument(trackingFraction >= 0.0f);
        this.mFraction = trackingFraction;
    }

    public VastFractionalProgressTracker(@NonNull String trackingUrl, float trackingFraction) {
        this(VastTracker.MessageType.TRACKING_URL, trackingUrl, trackingFraction);
    }

    public float trackingFraction() {
        return this.mFraction;
    }

    @Override
    public int compareTo(@NonNull VastFractionalProgressTracker other) {
        float you = other.trackingFraction();
        float me = this.trackingFraction();
        return Double.compare(me, you);
    }

    public String toString() {
        return String.format(Locale.US, "%2f: %s", Float.valueOf(this.mFraction), this.getContent());
    }
}

