/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.mobileads.util.XmlUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.w3c.dom.Node;

class MoatBuyerTagXmlManager {
    private static final String VIEWABLE_IMPRESSION = "ViewableImpression";
    private static final String ID = "id";
    private final List<Node> mMoatVerificationNodes;

    MoatBuyerTagXmlManager(@NonNull List<Node> moatVerificationNodes) {
        Preconditions.checkNotNull(moatVerificationNodes);
        this.mMoatVerificationNodes = moatVerificationNodes;
    }

    @NonNull
    Set<String> getImpressionPixelsXml() {
        HashSet<String> impressionPixelsXml = new HashSet<String>();
        for (Node verification : this.mMoatVerificationNodes) {
            Node viewableImpression;
            String viewableImpressionXml;
            if (verification == null || (viewableImpressionXml = this.getViewableImpressionXml(viewableImpression = XmlUtils.getFirstMatchingChildNode(verification, VIEWABLE_IMPRESSION))) == null) continue;
            impressionPixelsXml.add(viewableImpressionXml);
        }
        return impressionPixelsXml;
    }

    @Nullable
    private String getViewableImpressionXml(@Nullable Node viewableImpression) {
        if (viewableImpression == null || !viewableImpression.hasAttributes()) {
            return null;
        }
        String idAttribute = XmlUtils.getAttributeValue(viewableImpression, ID);
        String content = XmlUtils.getNodeValue(viewableImpression);
        return String.format(Locale.US, "<ViewableImpression id=\"%s\"><![CDATA[%s]]</ViewableImpression>", idAttribute, content);
    }
}

