/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import com.mopub.common.MoPub;
import com.mopub.common.Preconditions;
import com.mopub.common.SharedPreferencesHelper;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.privacy.ConsentData;
import com.mopub.common.privacy.PersonalInfoManager;
import com.mopub.mobileads.ConversionUrlGenerator;
import com.mopub.network.TrackingRequest;
import com.mopub.volley.VolleyError;

public class MoPubConversionTracker {
    private static final String WANT_TO_TRACK = " wantToTrack";
    @NonNull
    private final Context mContext;
    @NonNull
    private final String mWantToTrack;
    @NonNull
    private final String mIsTrackedKey;
    @NonNull
    private SharedPreferences mSharedPreferences;

    public MoPubConversionTracker(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        this.mContext = context.getApplicationContext();
        String packageName = this.mContext.getPackageName();
        this.mWantToTrack = packageName + WANT_TO_TRACK;
        this.mIsTrackedKey = packageName + " tracked";
        this.mSharedPreferences = SharedPreferencesHelper.getSharedPreferences(this.mContext);
    }

    public void reportAppOpen() {
        this.reportAppOpen(false);
    }

    public void reportAppOpen(boolean sessionTracker) {
        PersonalInfoManager infoManager = MoPub.getPersonalInformationManager();
        if (infoManager == null) {
            MoPubLog.w("Cannot report app open until initialization is done");
            return;
        }
        if (!sessionTracker && this.isAlreadyTracked()) {
            MoPubLog.d("Conversion already tracked");
            return;
        }
        if (!sessionTracker && !MoPub.canCollectPersonalInformation()) {
            this.mSharedPreferences.edit().putBoolean(this.mWantToTrack, true).apply();
            return;
        }
        ConsentData consentData = infoManager.getConsentData();
        String url = new ConversionUrlGenerator(this.mContext).withGdprApplies(infoManager.gdprApplies()).withForceGdprApplies(consentData.isForceGdprApplies()).withCurrentConsentStatus(infoManager.getPersonalInfoConsentStatus().getValue()).withConsentedPrivacyPolicyVersion(consentData.getConsentedPrivacyPolicyVersion()).withConsentedVendorListVersion(consentData.getConsentedVendorListVersion()).withSessionTracker(sessionTracker).generateUrlString("ads.mopub.com");
        TrackingRequest.makeTrackingHttpRequest(url, this.mContext, new TrackingRequest.Listener(){

            @Override
            public void onResponse(@NonNull String url) {
                MoPubConversionTracker.this.mSharedPreferences.edit().putBoolean(MoPubConversionTracker.this.mIsTrackedKey, true).putBoolean(MoPubConversionTracker.this.mWantToTrack, false).apply();
            }

            public void onErrorResponse(VolleyError volleyError) {
            }
        });
    }

    public boolean shouldTrack() {
        PersonalInfoManager infoManager = MoPub.getPersonalInformationManager();
        if (infoManager == null) {
            return false;
        }
        return infoManager.canCollectPersonalInformation() && this.mSharedPreferences.getBoolean(this.mWantToTrack, false);
    }

    private boolean isAlreadyTracked() {
        return this.mSharedPreferences.getBoolean(this.mIsTrackedKey, false);
    }
}

