/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.BaseUrlGenerator;
import com.mopub.common.ClientMetadata;

class ConversionUrlGenerator
extends BaseUrlGenerator {
    private static final String SESSION_TRACKER_KEY = "st";
    private static final String PACKAGE_NAME_KEY = "id";
    @NonNull
    private Context mContext;
    @Nullable
    private String mCurrentConsentStatus;
    @Nullable
    private String mConsentedVendorListVersion;
    @Nullable
    private String mConsentedPrivacyPolicyVersion;
    @Nullable
    private Boolean mGdprApplies;
    private boolean mForceGdprApplies;
    private boolean mSt;

    ConversionUrlGenerator(@NonNull Context context) {
        this.mContext = context;
    }

    public ConversionUrlGenerator withCurrentConsentStatus(@Nullable String currentConsentStatus) {
        this.mCurrentConsentStatus = currentConsentStatus;
        return this;
    }

    public ConversionUrlGenerator withGdprApplies(@Nullable Boolean gdprApplies) {
        this.mGdprApplies = gdprApplies;
        return this;
    }

    public ConversionUrlGenerator withForceGdprApplies(boolean forceGdprApplies) {
        this.mForceGdprApplies = forceGdprApplies;
        return this;
    }

    public ConversionUrlGenerator withConsentedVendorListVersion(@Nullable String consentedVendorListVersion) {
        this.mConsentedVendorListVersion = consentedVendorListVersion;
        return this;
    }

    public ConversionUrlGenerator withConsentedPrivacyPolicyVersion(@Nullable String consentedPrivacyPolicyVersion) {
        this.mConsentedPrivacyPolicyVersion = consentedPrivacyPolicyVersion;
        return this;
    }

    public ConversionUrlGenerator withSessionTracker(boolean st) {
        this.mSt = st;
        return this;
    }

    @Override
    public String generateUrlString(String serverHostname) {
        ClientMetadata clientMetadata = ClientMetadata.getInstance(this.mContext);
        this.initUrlString(serverHostname, "/m/open");
        this.setApiVersion("6");
        this.setAppVersion(clientMetadata.getAppVersion());
        this.appendAdvertisingInfoTemplates();
        this.addParam(PACKAGE_NAME_KEY, this.mContext.getPackageName());
        if (this.mSt) {
            this.addParam(SESSION_TRACKER_KEY, true);
        }
        this.addParam("nv", "5.4.0");
        this.addParam("current_consent_status", this.mCurrentConsentStatus);
        this.addParam("consented_vendor_list_version", this.mConsentedVendorListVersion);
        this.addParam("consented_privacy_policy_version", this.mConsentedPrivacyPolicyVersion);
        this.addParam("gdpr_applies", this.mGdprApplies);
        this.addParam("force_gdpr_applies", this.mForceGdprApplies);
        return this.getFinalUrlString();
    }
}

