/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.util.Views;
import com.mopub.mobileads.util.WebViews;

public class BaseWebView
extends WebView {
    private static boolean sDeadlockCleared = false;
    protected boolean mIsDestroyed;

    public BaseWebView(Context context) {
        super(context.getApplicationContext());
        this.enablePlugins(false);
        this.restrictDeviceContentAccess();
        WebViews.setDisableJSChromeClient(this);
        if (!sDeadlockCleared) {
            this.clearWebViewDeadlock(this.getContext());
            sDeadlockCleared = true;
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        WebViews.manageThirdPartyCookies(this);
    }

    public void destroy() {
        if (this.mIsDestroyed) {
            return;
        }
        this.mIsDestroyed = true;
        Views.removeFromParent((View)this);
        this.removeAllViews();
        super.destroy();
    }

    public void enablePlugins(boolean enabled) {
        if (Build.VERSION.SDK_INT >= 18) {
            return;
        }
        if (enabled) {
            this.getSettings().setPluginState(WebSettings.PluginState.ON);
        } else {
            this.getSettings().setPluginState(WebSettings.PluginState.OFF);
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void enableJavascriptCaching() {
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setDomStorageEnabled(true);
        this.getSettings().setAppCacheEnabled(true);
        this.getSettings().setAppCachePath(this.getContext().getCacheDir().getAbsolutePath());
    }

    private void restrictDeviceContentAccess() {
        this.getSettings().setAllowFileAccess(false);
        this.getSettings().setAllowContentAccess(false);
        this.getSettings().setAllowFileAccessFromFileURLs(false);
        this.getSettings().setAllowUniversalAccessFromFileURLs(false);
    }

    private void clearWebViewDeadlock(@NonNull Context context) {
        if (Build.VERSION.SDK_INT == 19) {
            WebView webView = new WebView(context.getApplicationContext());
            webView.setBackgroundColor(0);
            webView.loadDataWithBaseURL(null, "", "text/html", "UTF-8", null);
            WindowManager.LayoutParams params = new WindowManager.LayoutParams();
            params.width = 1;
            params.height = 1;
            params.type = 2005;
            params.flags = 0x1000018;
            params.format = -2;
            params.gravity = 0x800033;
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            windowManager.addView((View)webView, (ViewGroup.LayoutParams)params);
        }
    }

    @Deprecated
    @VisibleForTesting
    void setIsDestroyed(boolean isDestroyed) {
        this.mIsDestroyed = isDestroyed;
    }
}

