/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.WebSettings;
import com.mopub.common.AdReport;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.BaseWebView;
import com.mopub.mobileads.ViewGestureDetector;
import com.mopub.network.Networking;

public class BaseHtmlWebView
extends BaseWebView
implements ViewGestureDetector.UserClickListener {
    private final ViewGestureDetector mViewGestureDetector;
    private boolean mClicked;

    public BaseHtmlWebView(Context context, AdReport adReport) {
        super(context);
        this.disableScrollingAndZoom();
        this.getSettings().setJavaScriptEnabled(true);
        this.mViewGestureDetector = new ViewGestureDetector(context, (View)this, adReport);
        this.mViewGestureDetector.setUserClickListener(this);
        this.enablePlugins(true);
        this.setBackgroundColor(0);
    }

    public void init() {
        this.initializeOnTouchListener();
    }

    public void loadUrl(@Nullable String url) {
        if (url == null) {
            return;
        }
        if (url.startsWith("javascript:")) {
            super.loadUrl(url);
            return;
        }
        MoPubLog.d("Loading url: " + url);
    }

    public void stopLoading() {
        if (this.mIsDestroyed) {
            MoPubLog.w(BaseHtmlWebView.class.getSimpleName() + "#stopLoading() called after destroy()");
            return;
        }
        WebSettings webSettings = this.getSettings();
        if (webSettings == null) {
            MoPubLog.w(BaseHtmlWebView.class.getSimpleName() + "#getSettings() returned null");
            return;
        }
        webSettings.setJavaScriptEnabled(false);
        super.stopLoading();
        webSettings.setJavaScriptEnabled(true);
    }

    private void disableScrollingAndZoom() {
        this.setHorizontalScrollBarEnabled(false);
        this.setHorizontalScrollbarOverlay(false);
        this.setVerticalScrollBarEnabled(false);
        this.setVerticalScrollbarOverlay(false);
        this.getSettings().setSupportZoom(false);
    }

    void loadHtmlResponse(String htmlResponse) {
        this.loadDataWithBaseURL(Networking.getBaseUrlScheme() + "://" + "ads.mopub.com" + "/", htmlResponse, "text/html", "utf-8", null);
    }

    void initializeOnTouchListener() {
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                BaseHtmlWebView.this.mViewGestureDetector.sendTouchEvent(event);
                return event.getAction() == 2;
            }
        });
    }

    @Override
    public void onUserClick() {
        this.mClicked = true;
    }

    @Override
    public void onResetUserClick() {
        this.mClicked = false;
    }

    @Override
    public boolean wasClicked() {
        return this.mClicked;
    }
}

