/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.support.annotation.NonNull;
import com.mopub.common.Preconditions;
import com.mopub.mobileads.util.XmlUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;

class AvidBuyerTagXmlManager {
    private static final String AD_VERIFICATIONS = "AdVerifications";
    private static final String VERIFICATION = "Verification";
    private static final String JAVA_SCRIPT_RESOURCE = "JavaScriptResource";
    private final Node mAvidNode;

    AvidBuyerTagXmlManager(@NonNull Node avidNode) {
        Preconditions.checkNotNull(avidNode);
        this.mAvidNode = avidNode;
    }

    @NonNull
    Set<String> getJavaScriptResources() {
        HashSet<String> avidJavaScriptResources = new HashSet<String>();
        Node adVerification = XmlUtils.getFirstMatchingChildNode(this.mAvidNode, AD_VERIFICATIONS);
        if (adVerification == null) {
            return avidJavaScriptResources;
        }
        List<Node> verifications = XmlUtils.getMatchingChildNodes(adVerification, VERIFICATION);
        if (verifications == null) {
            return avidJavaScriptResources;
        }
        for (Node verification : verifications) {
            Node javaScriptResource = XmlUtils.getFirstMatchingChildNode(verification, JAVA_SCRIPT_RESOURCE);
            if (javaScriptResource == null) continue;
            avidJavaScriptResources.add(XmlUtils.getNodeValue(javaScriptResource));
        }
        return avidJavaScriptResources;
    }
}

