/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.annotation.SuppressLint;
import android.content.Context;
import android.location.Location;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.mopub.common.AdReport;
import com.mopub.common.ClientMetadata;
import com.mopub.common.MoPub;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.DeviceUtils;
import com.mopub.common.util.Dips;
import com.mopub.common.util.Utils;
import com.mopub.mobileads.MoPubError;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MoPubView;
import com.mopub.mobileads.WebViewAdUrlGenerator;
import com.mopub.mraid.MraidNativeCommandHandler;
import com.mopub.network.AdLoader;
import com.mopub.network.AdResponse;
import com.mopub.network.MoPubNetworkError;
import com.mopub.network.TrackingRequest;
import com.mopub.volley.NetworkResponse;
import com.mopub.volley.Request;
import com.mopub.volley.VolleyError;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;

public class AdViewController {
    static final int DEFAULT_REFRESH_TIME_MILLISECONDS = 60000;
    private static final int MAX_REFRESH_TIME_MILLISECONDS = 600000;
    private static final double BACKOFF_FACTOR = 1.5;
    private static final FrameLayout.LayoutParams WRAP_AND_CENTER_LAYOUT_PARAMS = new FrameLayout.LayoutParams(-2, -2, 17);
    private static final WeakHashMap<View, Boolean> sViewShouldHonorServerDimensions = new WeakHashMap();
    private final long mBroadcastIdentifier;
    @Nullable
    private Context mContext;
    @Nullable
    private MoPubView mMoPubView;
    @Nullable
    private WebViewAdUrlGenerator mUrlGenerator;
    @Nullable
    private Request mActiveRequest;
    @Nullable
    AdLoader mAdLoader;
    @NonNull
    private final AdLoader.Listener mAdListener;
    @Nullable
    private AdResponse mAdResponse;
    @Nullable
    private String mCustomEventClassName;
    private final Runnable mRefreshRunnable;
    private boolean mIsDestroyed;
    private Handler mHandler;
    private boolean mExpanded;
    @VisibleForTesting
    int mBackoffPower = 1;
    private Map<String, Object> mLocalExtras = new HashMap<String, Object>();
    private boolean mCurrentAutoRefreshStatus = true;
    private boolean mShouldAllowAutoRefresh = true;
    private String mKeywords;
    private String mUserDataKeywords;
    private Location mLocation;
    private boolean mIsTesting;
    private boolean mAdWasLoaded;
    @Nullable
    private String mAdUnitId;
    @Nullable
    private Integer mRefreshTimeMillis;

    public static void setShouldHonorServerDimensions(View view) {
        sViewShouldHonorServerDimensions.put(view, true);
    }

    private static boolean getShouldHonorServerDimensions(View view) {
        return sViewShouldHonorServerDimensions.get(view) != null;
    }

    public AdViewController(@NonNull Context context, @NonNull MoPubView view) {
        this.mContext = context;
        this.mMoPubView = view;
        this.mBroadcastIdentifier = Utils.generateUniqueId();
        this.mUrlGenerator = new WebViewAdUrlGenerator(this.mContext.getApplicationContext(), MraidNativeCommandHandler.isStorePictureSupported(this.mContext));
        this.mAdListener = new AdLoader.Listener(){

            @Override
            public void onSuccess(AdResponse response) {
                AdViewController.this.onAdLoadSuccess(response);
            }

            public void onErrorResponse(VolleyError volleyError) {
                AdViewController.this.onAdLoadError(volleyError);
            }
        };
        this.mRefreshRunnable = new Runnable(){

            @Override
            public void run() {
                AdViewController.this.internalLoadAd();
            }
        };
        this.mRefreshTimeMillis = 60000;
        this.mHandler = new Handler();
    }

    @VisibleForTesting
    void onAdLoadSuccess(@NonNull AdResponse adResponse) {
        this.mBackoffPower = 1;
        this.mAdResponse = adResponse;
        this.mCustomEventClassName = adResponse.getCustomEventClassName();
        this.mRefreshTimeMillis = this.mAdResponse.getRefreshTimeMillis();
        this.mActiveRequest = null;
        this.loadCustomEvent(this.mMoPubView, adResponse.getCustomEventClassName(), adResponse.getServerExtras());
        this.scheduleRefreshTimerIfEnabled();
    }

    @VisibleForTesting
    void onAdLoadError(VolleyError error) {
        MoPubErrorCode errorCode;
        MoPubNetworkError moPubNetworkError;
        if (error instanceof MoPubNetworkError && (moPubNetworkError = (MoPubNetworkError)error).getRefreshTimeMillis() != null) {
            this.mRefreshTimeMillis = moPubNetworkError.getRefreshTimeMillis();
        }
        if ((errorCode = AdViewController.getErrorCodeFromVolleyError(error, this.mContext)) == MoPubErrorCode.SERVER_ERROR) {
            ++this.mBackoffPower;
        }
        this.adDidFail(errorCode);
    }

    @VisibleForTesting
    void loadCustomEvent(@Nullable MoPubView moPubView, @Nullable String customEventClassName, @NonNull Map<String, String> serverExtras) {
        Preconditions.checkNotNull(serverExtras);
        if (moPubView == null) {
            MoPubLog.d("Can't load an ad in this ad view because it was destroyed.");
            return;
        }
        moPubView.loadCustomEvent(customEventClassName, serverExtras);
    }

    @VisibleForTesting
    @NonNull
    static MoPubErrorCode getErrorCodeFromVolleyError(@NonNull VolleyError error, @Nullable Context context) {
        NetworkResponse networkResponse = error.networkResponse;
        if (error instanceof MoPubNetworkError) {
            switch (((MoPubNetworkError)error).getReason()) {
                case WARMING_UP: {
                    return MoPubErrorCode.WARMUP;
                }
                case NO_FILL: {
                    return MoPubErrorCode.NO_FILL;
                }
            }
            return MoPubErrorCode.UNSPECIFIED;
        }
        if (networkResponse == null) {
            if (!DeviceUtils.isNetworkAvailable(context)) {
                return MoPubErrorCode.NO_CONNECTION;
            }
            return MoPubErrorCode.UNSPECIFIED;
        }
        if (error.networkResponse.statusCode >= 400) {
            return MoPubErrorCode.SERVER_ERROR;
        }
        return MoPubErrorCode.UNSPECIFIED;
    }

    @Nullable
    public MoPubView getMoPubView() {
        return this.mMoPubView;
    }

    public void loadAd() {
        this.mBackoffPower = 1;
        this.internalLoadAd();
    }

    private void internalLoadAd() {
        this.mAdWasLoaded = true;
        if (TextUtils.isEmpty((CharSequence)this.mAdUnitId)) {
            MoPubLog.d("Can't load an ad in this ad view because the ad unit ID is not set. Did you forget to call setAdUnitId()?");
            return;
        }
        if (!this.isNetworkAvailable()) {
            MoPubLog.d("Can't load an ad because there is no network connectivity.");
            this.scheduleRefreshTimerIfEnabled();
            return;
        }
        String adUrl = this.generateAdUrl();
        this.loadNonJavascript(adUrl, null);
    }

    void loadNonJavascript(@Nullable String url, @Nullable MoPubError moPubError) {
        if (url == null) {
            this.adDidFail(MoPubErrorCode.NO_FILL);
            return;
        }
        if (!url.startsWith("javascript:")) {
            MoPubLog.d("Loading url: " + url);
        }
        if (this.mActiveRequest != null) {
            if (!TextUtils.isEmpty((CharSequence)this.mAdUnitId)) {
                MoPubLog.i("Already loading an ad for " + this.mAdUnitId + ", wait to finish.");
            }
            return;
        }
        this.fetchAd(url, moPubError);
    }

    @Deprecated
    public void reload() {
        this.loadAd();
    }

    boolean loadFailUrl(MoPubErrorCode errorCode) {
        Log.v((String)"MoPub", (String)("MoPubErrorCode: " + (errorCode == null ? "" : errorCode.toString())));
        if (this.mAdLoader != null && this.mAdLoader.hasMoreAds()) {
            this.loadNonJavascript("", errorCode);
            return true;
        }
        this.adDidFail(MoPubErrorCode.NO_FILL);
        return false;
    }

    void setNotLoading() {
        if (this.mActiveRequest != null) {
            if (!this.mActiveRequest.isCanceled()) {
                this.mActiveRequest.cancel();
            }
            this.mActiveRequest = null;
        }
        this.mAdLoader = null;
    }

    void creativeDownloadSuccess() {
        this.scheduleRefreshTimerIfEnabled();
        if (this.mAdLoader == null) {
            MoPubLog.w("mAdLoader is not supposed to be null");
            return;
        }
        this.mAdLoader.creativeDownloadSuccess();
        this.mAdLoader = null;
    }

    public String getKeywords() {
        return this.mKeywords;
    }

    public void setKeywords(String keywords) {
        this.mKeywords = keywords;
    }

    public String getUserDataKeywords() {
        if (!MoPub.canCollectPersonalInformation()) {
            return null;
        }
        return this.mUserDataKeywords;
    }

    public void setUserDataKeywords(String userDataKeywords) {
        if (!MoPub.canCollectPersonalInformation()) {
            this.mUserDataKeywords = null;
            return;
        }
        this.mUserDataKeywords = userDataKeywords;
    }

    public Location getLocation() {
        if (!MoPub.canCollectPersonalInformation()) {
            return null;
        }
        return this.mLocation;
    }

    public void setLocation(Location location) {
        if (!MoPub.canCollectPersonalInformation()) {
            this.mLocation = null;
            return;
        }
        this.mLocation = location;
    }

    public String getAdUnitId() {
        return this.mAdUnitId;
    }

    @Nullable
    public String getCustomEventClassName() {
        return this.mCustomEventClassName;
    }

    public void setAdUnitId(@NonNull String adUnitId) {
        this.mAdUnitId = adUnitId;
    }

    public long getBroadcastIdentifier() {
        return this.mBroadcastIdentifier;
    }

    public int getAdWidth() {
        if (this.mAdResponse != null && this.mAdResponse.getWidth() != null) {
            return this.mAdResponse.getWidth();
        }
        return 0;
    }

    public int getAdHeight() {
        if (this.mAdResponse != null && this.mAdResponse.getHeight() != null) {
            return this.mAdResponse.getHeight();
        }
        return 0;
    }

    @Deprecated
    public boolean getAutorefreshEnabled() {
        return this.getCurrentAutoRefreshStatus();
    }

    public boolean getCurrentAutoRefreshStatus() {
        return this.mCurrentAutoRefreshStatus;
    }

    void pauseRefresh() {
        this.setAutoRefreshStatus(false);
    }

    void resumeRefresh() {
        if (this.mShouldAllowAutoRefresh && !this.mExpanded) {
            this.setAutoRefreshStatus(true);
        }
    }

    void setShouldAllowAutoRefresh(boolean shouldAllowAutoRefresh) {
        this.mShouldAllowAutoRefresh = shouldAllowAutoRefresh;
        this.setAutoRefreshStatus(shouldAllowAutoRefresh);
    }

    private void setAutoRefreshStatus(boolean newAutoRefreshStatus) {
        boolean autoRefreshStatusChanged;
        boolean bl = autoRefreshStatusChanged = this.mAdWasLoaded && this.mCurrentAutoRefreshStatus != newAutoRefreshStatus;
        if (autoRefreshStatusChanged) {
            String enabledString = newAutoRefreshStatus ? "enabled" : "disabled";
            MoPubLog.d("Refresh " + enabledString + " for ad unit (" + this.mAdUnitId + ").");
        }
        this.mCurrentAutoRefreshStatus = newAutoRefreshStatus;
        if (this.mAdWasLoaded && this.mCurrentAutoRefreshStatus) {
            this.scheduleRefreshTimerIfEnabled();
        } else if (!this.mCurrentAutoRefreshStatus) {
            this.cancelRefreshTimer();
        }
    }

    void expand() {
        this.mExpanded = true;
        this.pauseRefresh();
    }

    void collapse() {
        this.mExpanded = false;
        this.resumeRefresh();
    }

    @Nullable
    public AdReport getAdReport() {
        if (this.mAdUnitId != null && this.mAdResponse != null) {
            return new AdReport(this.mAdUnitId, ClientMetadata.getInstance(this.mContext), this.mAdResponse);
        }
        return null;
    }

    public boolean getTesting() {
        return this.mIsTesting;
    }

    public void setTesting(boolean enabled) {
        this.mIsTesting = enabled;
    }

    boolean isDestroyed() {
        return this.mIsDestroyed;
    }

    void cleanup() {
        if (this.mIsDestroyed) {
            return;
        }
        this.setNotLoading();
        this.setAutoRefreshStatus(false);
        this.cancelRefreshTimer();
        this.mMoPubView = null;
        this.mContext = null;
        this.mUrlGenerator = null;
        this.mIsDestroyed = true;
    }

    @NonNull
    Integer getAdTimeoutDelay(int defaultValue) {
        if (this.mAdResponse == null) {
            return defaultValue;
        }
        return this.mAdResponse.getAdTimeoutMillis(defaultValue);
    }

    void trackImpression() {
        if (this.mAdResponse != null) {
            TrackingRequest.makeTrackingHttpRequest(this.mAdResponse.getImpressionTrackingUrls(), this.mContext);
        }
    }

    void registerClick() {
        if (this.mAdResponse != null) {
            TrackingRequest.makeTrackingHttpRequest(this.mAdResponse.getClickTrackingUrl(), this.mContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fetchAd(@NonNull String url, @Nullable MoPubError moPubError) {
        MoPubView moPubView = this.getMoPubView();
        if (moPubView == null || this.mContext == null) {
            MoPubLog.d("Can't load an ad in this ad view because it was destroyed.");
            this.setNotLoading();
            return;
        }
        AdViewController adViewController = this;
        synchronized (adViewController) {
            if (this.mAdLoader == null || !this.mAdLoader.hasMoreAds()) {
                this.mAdLoader = new AdLoader(url, moPubView.getAdFormat(), this.mAdUnitId, this.mContext, this.mAdListener);
            }
        }
        this.mActiveRequest = this.mAdLoader.loadNextAd(moPubError);
    }

    void forceRefresh() {
        this.setNotLoading();
        this.loadAd();
    }

    @Nullable
    String generateAdUrl() {
        if (this.mUrlGenerator == null) {
            return null;
        }
        boolean canCollectPersonalInformation = MoPub.canCollectPersonalInformation();
        this.mUrlGenerator.withAdUnitId(this.mAdUnitId).withKeywords(this.mKeywords).withUserDataKeywords(canCollectPersonalInformation ? this.mUserDataKeywords : null).withLocation(canCollectPersonalInformation ? this.mLocation : null);
        return this.mUrlGenerator.generateUrlString("ads.mopub.com");
    }

    void adDidFail(MoPubErrorCode errorCode) {
        MoPubLog.i("Ad failed to load.");
        this.setNotLoading();
        MoPubView moPubView = this.getMoPubView();
        if (moPubView == null) {
            return;
        }
        this.scheduleRefreshTimerIfEnabled();
        moPubView.adFailed(errorCode);
    }

    void scheduleRefreshTimerIfEnabled() {
        this.cancelRefreshTimer();
        if (this.mCurrentAutoRefreshStatus && this.mRefreshTimeMillis != null && this.mRefreshTimeMillis > 0) {
            this.mHandler.postDelayed(this.mRefreshRunnable, Math.min(600000L, (long)this.mRefreshTimeMillis.intValue() * (long)Math.pow(1.5, this.mBackoffPower)));
        }
    }

    void setLocalExtras(Map<String, Object> localExtras) {
        this.mLocalExtras = localExtras != null ? new TreeMap<String, Object>(localExtras) : new TreeMap();
    }

    Map<String, Object> getLocalExtras() {
        return this.mLocalExtras != null ? new TreeMap<String, Object>(this.mLocalExtras) : new TreeMap();
    }

    private void cancelRefreshTimer() {
        this.mHandler.removeCallbacks(this.mRefreshRunnable);
    }

    @SuppressLint(value={"MissingPermission"})
    private boolean isNetworkAvailable() {
        if (this.mContext == null) {
            return false;
        }
        if (!DeviceUtils.isPermissionGranted(this.mContext, "android.permission.ACCESS_NETWORK_STATE")) {
            return true;
        }
        ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    void setAdContentView(final View view) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                MoPubView moPubView = AdViewController.this.getMoPubView();
                if (moPubView == null) {
                    return;
                }
                moPubView.removeAllViews();
                moPubView.addView(view, (ViewGroup.LayoutParams)AdViewController.this.getAdLayoutParams(view));
            }
        });
    }

    private FrameLayout.LayoutParams getAdLayoutParams(View view) {
        Integer width = null;
        Integer height = null;
        if (this.mAdResponse != null) {
            width = this.mAdResponse.getWidth();
            height = this.mAdResponse.getHeight();
        }
        if (width != null && height != null && AdViewController.getShouldHonorServerDimensions(view) && width > 0 && height > 0) {
            int scaledWidth = Dips.asIntPixels(width.intValue(), this.mContext);
            int scaledHeight = Dips.asIntPixels(height.intValue(), this.mContext);
            return new FrameLayout.LayoutParams(scaledWidth, scaledHeight, 17);
        }
        return WRAP_AND_CENTER_LAYOUT_PARAMS;
    }

    @Deprecated
    @VisibleForTesting
    Integer getRefreshTimeMillis() {
        return this.mRefreshTimeMillis;
    }

    @Deprecated
    @VisibleForTesting
    void setRefreshTimeMillis(@Nullable Integer refreshTimeMillis) {
        this.mRefreshTimeMillis = refreshTimeMillis;
    }
}

