/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.AdFormat;
import com.mopub.common.util.ResponseHeader;
import com.mopub.network.HeaderUtils;
import org.json.JSONObject;

public class AdTypeTranslator {
    public static final String BANNER_SUFFIX = "_banner";
    public static final String INTERSTITIAL_SUFFIX = "_interstitial";

    static String getAdNetworkType(String adType, String fullAdType) {
        String adNetworkType = "interstitial".equals(adType) ? fullAdType : adType;
        return adNetworkType != null ? adNetworkType : "unknown";
    }

    public static String getCustomEventName(@NonNull AdFormat adFormat, @NonNull String adType, @Nullable String fullAdType, @Nullable JSONObject headers) {
        if ("custom".equalsIgnoreCase(adType)) {
            return HeaderUtils.extractHeader(headers, ResponseHeader.CUSTOM_EVENT_NAME);
        }
        if ("json".equalsIgnoreCase(adType)) {
            return CustomEventType.MOPUB_NATIVE.toString();
        }
        if ("json_video".equalsIgnoreCase(adType)) {
            return CustomEventType.MOPUB_VIDEO_NATIVE.toString();
        }
        if ("rewarded_video".equalsIgnoreCase(adType)) {
            return CustomEventType.MOPUB_REWARDED_VIDEO.toString();
        }
        if ("rewarded_playable".equalsIgnoreCase(adType)) {
            return CustomEventType.MOPUB_REWARDED_PLAYABLE.toString();
        }
        if ("html".equalsIgnoreCase(adType) || "mraid".equalsIgnoreCase(adType)) {
            return (AdFormat.INTERSTITIAL.equals((Object)adFormat) ? CustomEventType.fromString(adType + INTERSTITIAL_SUFFIX) : CustomEventType.fromString(adType + BANNER_SUFFIX)).toString();
        }
        if ("interstitial".equalsIgnoreCase(adType)) {
            return CustomEventType.fromString(fullAdType + INTERSTITIAL_SUFFIX).toString();
        }
        return CustomEventType.fromString(adType + BANNER_SUFFIX).toString();
    }

    public static enum CustomEventType {
        GOOGLE_PLAY_SERVICES_BANNER("admob_native_banner", "com.mopub.mobileads.GooglePlayServicesBanner", false),
        GOOGLE_PLAY_SERVICES_INTERSTITIAL("admob_full_interstitial", "com.mopub.mobileads.GooglePlayServicesInterstitial", false),
        MILLENNIAL_BANNER("millennial_native_banner", "com.mopub.mobileads.MillennialBanner", false),
        MILLENNIAL_INTERSTITIAL("millennial_full_interstitial", "com.mopub.mobileads.MillennialInterstitial", false),
        MRAID_BANNER("mraid_banner", "com.mopub.mraid.MraidBanner", true),
        MRAID_INTERSTITIAL("mraid_interstitial", "com.mopub.mraid.MraidInterstitial", true),
        HTML_BANNER("html_banner", "com.mopub.mobileads.HtmlBanner", true),
        HTML_INTERSTITIAL("html_interstitial", "com.mopub.mobileads.HtmlInterstitial", true),
        VAST_VIDEO_INTERSTITIAL("vast_interstitial", "com.mopub.mobileads.VastVideoInterstitial", true),
        MOPUB_NATIVE("mopub_native", "com.mopub.nativeads.MoPubCustomEventNative", true),
        MOPUB_VIDEO_NATIVE("mopub_video_native", "com.mopub.nativeads.MoPubCustomEventVideoNative", true),
        MOPUB_REWARDED_VIDEO("rewarded_video", "com.mopub.mobileads.MoPubRewardedVideo", true),
        MOPUB_REWARDED_PLAYABLE("rewarded_playable", "com.mopub.mobileads.MoPubRewardedPlayable", true),
        UNSPECIFIED("", null, false);

        @NonNull
        private final String mKey;
        @Nullable
        private final String mClassName;
        private final boolean mIsMoPubSpecific;

        private CustomEventType(String key, String className, boolean isMoPubSpecific) {
            this.mKey = key;
            this.mClassName = className;
            this.mIsMoPubSpecific = isMoPubSpecific;
        }

        private static CustomEventType fromString(@Nullable String key) {
            for (CustomEventType customEventType : CustomEventType.values()) {
                if (!customEventType.mKey.equals(key)) continue;
                return customEventType;
            }
            return UNSPECIFIED;
        }

        private static CustomEventType fromClassName(@Nullable String className) {
            for (CustomEventType customEventType : CustomEventType.values()) {
                if (customEventType.mClassName == null || !customEventType.mClassName.equals(className)) continue;
                return customEventType;
            }
            return UNSPECIFIED;
        }

        public String toString() {
            return this.mClassName;
        }

        public static boolean isMoPubSpecific(@Nullable String className) {
            return CustomEventType.fromClassName((String)className).mIsMoPubSpecific;
        }
    }
}

