/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.util;

import java.security.MessageDigest;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;

public class Utils {
    private static final AtomicLong sNextGeneratedId = new AtomicLong(1L);

    public static String sha1(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] bytes = string.getBytes("UTF-8");
            digest.update(bytes, 0, bytes.length);
            for (byte b : bytes = digest.digest()) {
                stringBuilder.append(String.format("%02X", b));
            }
            return stringBuilder.toString().toLowerCase(Locale.US);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static long generateUniqueId() {
        long newValue;
        long result;
        do {
            if ((newValue = (result = sNextGeneratedId.get()) + 1L) <= 0x7FFFFFFFFFFFFFFEL) continue;
            newValue = 1L;
        } while (!sNextGeneratedId.compareAndSet(result, newValue));
        return result;
    }

    public static boolean bitMaskContainsFlag(int bitMask, int flag) {
        return (bitMask & flag) != 0;
    }
}

