/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.util;

import com.mopub.common.logging.MoPubLog;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Streams {
    public static void copyContent(InputStream inputStream, OutputStream outputStream) throws IOException {
        int length;
        if (inputStream == null || outputStream == null) {
            throw new IOException("Unable to copy from or to a null stream.");
        }
        byte[] buffer = new byte[16384];
        while ((length = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, length);
        }
    }

    public static void copyContent(InputStream inputStream, OutputStream outputStream, long maxBytes) throws IOException {
        int length;
        if (inputStream == null || outputStream == null) {
            throw new IOException("Unable to copy from or to a null stream.");
        }
        byte[] buffer = new byte[16384];
        long totalRead = 0L;
        while ((length = inputStream.read(buffer)) != -1) {
            if ((totalRead += (long)length) >= maxBytes) {
                throw new IOException("Error copying content: attempted to copy " + totalRead + " bytes, with " + maxBytes + " maximum.");
            }
            outputStream.write(buffer, 0, length);
        }
    }

    public static void readStream(InputStream inputStream, byte[] buffer) throws IOException {
        int offset = 0;
        int bytesRead = 0;
        int maxBytes = buffer.length;
        while ((bytesRead = inputStream.read(buffer, offset, maxBytes)) != -1) {
            offset += bytesRead;
            if ((maxBytes -= bytesRead) > 0) continue;
            return;
        }
    }

    public static void closeStream(Closeable stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (Exception e) {
            MoPubLog.d("Unable to close stream. Ignoring.");
        }
    }
}

