/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.util;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class Reflection {
    @Nullable
    public static Method getDeclaredMethodWithTraversal(@Nullable Class<?> clazz, @NonNull String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Preconditions.checkNotNull(methodName);
        Preconditions.checkNotNull(parameterTypes);
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                return currentClass.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        throw new NoSuchMethodException();
    }

    public static boolean classFound(@NonNull String className) {
        Preconditions.checkNotNull(className);
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @NonNull
    public static <T> T instantiateClassWithEmptyConstructor(@NonNull String className, @NonNull Class<? extends T> superclass) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, NullPointerException {
        Preconditions.checkNotNull(className);
        Preconditions.checkNotNull(superclass);
        Class<T> clazz = Class.forName(className).asSubclass(superclass);
        Constructor<T> constructor = clazz.getDeclaredConstructor(null);
        constructor.setAccessible(true);
        return constructor.newInstance(new Object[0]);
    }

    @NonNull
    public static <T> T instantiateClassWithConstructor(@NonNull String className, @NonNull Class<? extends T> superClass, @NonNull Class[] classes, @NonNull Object[] parameters) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Preconditions.checkNotNull(className);
        Preconditions.checkNotNull(superClass);
        Preconditions.checkNotNull(classes);
        Preconditions.checkNotNull(parameters);
        Class<T> clazz = Class.forName(className).asSubclass(superClass);
        Constructor<T> constructor = clazz.getDeclaredConstructor(classes);
        constructor.setAccessible(true);
        return constructor.newInstance(parameters);
    }

    public static Field getPrivateField(@NonNull Class classType, @NonNull String fieldName) throws NoSuchFieldException {
        Field declaredField = classType.getDeclaredField(fieldName);
        declaredField.setAccessible(true);
        return declaredField;
    }

    public static class MethodBuilder {
        @Nullable
        private final Object mInstance;
        @NonNull
        private final String mMethodName;
        @Nullable
        private Class<?> mClass;
        @NonNull
        private List<Class<?>> mParameterClasses;
        @NonNull
        private List<Object> mParameters;
        private boolean mIsAccessible;
        private boolean mIsStatic;

        public MethodBuilder(@Nullable Object instance, @NonNull String methodName) {
            Preconditions.checkNotNull(methodName);
            this.mInstance = instance;
            this.mMethodName = methodName;
            this.mParameterClasses = new ArrayList();
            this.mParameters = new ArrayList<Object>();
            this.mClass = instance != null ? instance.getClass() : null;
        }

        @NonNull
        public <T> MethodBuilder addParam(@NonNull Class<T> clazz, @Nullable T parameter) {
            Preconditions.checkNotNull(clazz);
            this.mParameterClasses.add(clazz);
            this.mParameters.add(parameter);
            return this;
        }

        @NonNull
        public MethodBuilder addParam(@NonNull String className, @Nullable Object parameter) throws ClassNotFoundException {
            Preconditions.checkNotNull(className);
            Class<?> clazz = Class.forName(className);
            this.mParameterClasses.add(clazz);
            this.mParameters.add(parameter);
            return this;
        }

        @NonNull
        public MethodBuilder setAccessible() {
            this.mIsAccessible = true;
            return this;
        }

        @NonNull
        public MethodBuilder setStatic(@NonNull Class<?> clazz) {
            Preconditions.checkNotNull(clazz);
            this.mIsStatic = true;
            this.mClass = clazz;
            return this;
        }

        @NonNull
        public MethodBuilder setStatic(@NonNull String className) throws ClassNotFoundException {
            Preconditions.checkNotNull(className);
            this.mIsStatic = true;
            this.mClass = Class.forName(className);
            return this;
        }

        @Nullable
        public Object execute() throws Exception {
            Class[] classArray = new Class[this.mParameterClasses.size()];
            Class[] parameterTypes = this.mParameterClasses.toArray(classArray);
            Method method = Reflection.getDeclaredMethodWithTraversal(this.mClass, this.mMethodName, parameterTypes);
            if (this.mIsAccessible) {
                method.setAccessible(true);
            }
            Object[] parameters = this.mParameters.toArray();
            if (this.mIsStatic) {
                return method.invoke(null, parameters);
            }
            return method.invoke(this.mInstance, parameters);
        }
    }
}

