/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.util;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import java.util.concurrent.Executor;

public class AsyncTasks {
    private static Executor sExecutor;
    private static Handler sUiThreadHandler;

    private static void init() {
        sExecutor = AsyncTask.THREAD_POOL_EXECUTOR;
        sUiThreadHandler = new Handler(Looper.getMainLooper());
    }

    @VisibleForTesting
    public static void setExecutor(Executor executor) {
        sExecutor = executor;
    }

    public static <P> void safeExecuteOnExecutor(final @NonNull AsyncTask<P, ?, ?> asyncTask, final P ... params) {
        Preconditions.checkNotNull(asyncTask, "Unable to execute null AsyncTask.");
        if (Looper.getMainLooper() == Looper.myLooper()) {
            asyncTask.executeOnExecutor(sExecutor, (Object[])params);
        } else {
            MoPubLog.d("Posting AsyncTask to main thread for execution.");
            sUiThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    asyncTask.executeOnExecutor(sExecutor, params);
                }
            });
        }
    }

    static {
        AsyncTasks.init();
    }
}

