/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.privacy;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.BaseUrlGenerator;
import com.mopub.common.ClientMetadata;
import com.mopub.common.Preconditions;
import com.mopub.common.privacy.ConsentStatus;

public class SyncUrlGenerator
extends BaseUrlGenerator {
    private static final String LAST_CHANGED_MS_KEY = "last_changed_ms";
    private static final String LAST_CONSENT_STATUS_KEY = "last_consent_status";
    private static final String CONSENT_CHANGE_REASON_KEY = "consent_change_reason";
    private static final String CACHED_VENDOR_LIST_IAB_HASH_KEY = "cached_vendor_list_iab_hash";
    private static final String EXTRAS_KEY = "extras";
    private static final String FORCED_GDPR_APPLIES_CHANGED = "forced_gdpr_applies_changed";
    @NonNull
    private final Context mContext;
    @Nullable
    private String mAdUnitId;
    @Nullable
    private String mUdid;
    @Nullable
    private String mLastChangedMs;
    @Nullable
    private String mLastConsentStatus;
    @NonNull
    private final String mCurrentConsentStatus;
    @Nullable
    private String mConsentChangeReason;
    @Nullable
    private String mConsentedVendorListVersion;
    @Nullable
    private String mConsentedPrivacyPolicyVersion;
    @Nullable
    private String mCachedVendorListIabHash;
    @Nullable
    private String mExtras;
    @Nullable
    private Boolean mGdprApplies;
    private boolean mForceGdprApplies;
    @Nullable
    private Boolean mForceGdprAppliesChanged;

    public SyncUrlGenerator(@NonNull Context context, @NonNull String currentConsentStatus) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(currentConsentStatus);
        this.mContext = context.getApplicationContext();
        this.mCurrentConsentStatus = currentConsentStatus;
    }

    public SyncUrlGenerator withAdUnitId(@Nullable String adUnitId) {
        this.mAdUnitId = adUnitId;
        return this;
    }

    public SyncUrlGenerator withUdid(@Nullable String udid) {
        this.mUdid = udid;
        return this;
    }

    public SyncUrlGenerator withGdprApplies(@Nullable Boolean gdprApplies) {
        this.mGdprApplies = gdprApplies;
        return this;
    }

    public SyncUrlGenerator withForceGdprApplies(boolean forceGdprApplies) {
        this.mForceGdprApplies = forceGdprApplies;
        return this;
    }

    public SyncUrlGenerator withForceGdprAppliesChanged(@Nullable Boolean forceGdprAppliesChanged) {
        this.mForceGdprAppliesChanged = forceGdprAppliesChanged;
        return this;
    }

    public SyncUrlGenerator withLastChangedMs(@Nullable String lastChangedMs) {
        this.mLastChangedMs = lastChangedMs;
        return this;
    }

    public SyncUrlGenerator withLastConsentStatus(@Nullable ConsentStatus lastConsentStatus) {
        this.mLastConsentStatus = lastConsentStatus == null ? null : lastConsentStatus.getValue();
        return this;
    }

    public SyncUrlGenerator withConsentChangeReason(@Nullable String consentChangeReason) {
        this.mConsentChangeReason = consentChangeReason;
        return this;
    }

    public SyncUrlGenerator withConsentedVendorListVersion(@Nullable String consentedVendorListVersion) {
        this.mConsentedVendorListVersion = consentedVendorListVersion;
        return this;
    }

    public SyncUrlGenerator withConsentedPrivacyPolicyVersion(@Nullable String consentedPrivacyPolicyVersion) {
        this.mConsentedPrivacyPolicyVersion = consentedPrivacyPolicyVersion;
        return this;
    }

    public SyncUrlGenerator withCachedVendorListIabHash(@Nullable String cachedVendorListIabHash) {
        this.mCachedVendorListIabHash = cachedVendorListIabHash;
        return this;
    }

    public SyncUrlGenerator withExtras(@Nullable String extras) {
        this.mExtras = extras;
        return this;
    }

    @Override
    public String generateUrlString(@NonNull String serverHostname) {
        this.initUrlString(serverHostname, "/m/gdpr_sync");
        this.addParam("id", this.mAdUnitId);
        this.addParam("nv", "5.4.0");
        this.addParam(LAST_CHANGED_MS_KEY, this.mLastChangedMs);
        this.addParam(LAST_CONSENT_STATUS_KEY, this.mLastConsentStatus);
        this.addParam("current_consent_status", this.mCurrentConsentStatus);
        this.addParam(CONSENT_CHANGE_REASON_KEY, this.mConsentChangeReason);
        this.addParam("consented_vendor_list_version", this.mConsentedVendorListVersion);
        this.addParam("consented_privacy_policy_version", this.mConsentedPrivacyPolicyVersion);
        this.addParam(CACHED_VENDOR_LIST_IAB_HASH_KEY, this.mCachedVendorListIabHash);
        this.addParam(EXTRAS_KEY, this.mExtras);
        this.addParam("udid", this.mUdid);
        this.addParam("gdpr_applies", this.mGdprApplies);
        this.addParam("force_gdpr_applies", this.mForceGdprApplies);
        this.addParam(FORCED_GDPR_APPLIES_CHANGED, this.mForceGdprAppliesChanged);
        this.addParam("bundle", ClientMetadata.getInstance(this.mContext).getAppPackageName());
        this.addParam("dnt", "mp_tmpl_do_not_track");
        return this.getFinalUrlString();
    }
}

