/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.privacy;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mopub.common.ClientMetadata;
import com.mopub.common.MoPub;
import com.mopub.common.Preconditions;
import com.mopub.common.SdkInitializationListener;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.privacy.AdvertisingId;
import com.mopub.common.privacy.ConsentChangeReason;
import com.mopub.common.privacy.ConsentData;
import com.mopub.common.privacy.ConsentDialogController;
import com.mopub.common.privacy.ConsentDialogListener;
import com.mopub.common.privacy.ConsentStatus;
import com.mopub.common.privacy.ConsentStatusChangeListener;
import com.mopub.common.privacy.MoPubIdentifier;
import com.mopub.common.privacy.PersonalInfoData;
import com.mopub.common.privacy.SyncRequest;
import com.mopub.common.privacy.SyncResponse;
import com.mopub.common.privacy.SyncUrlGenerator;
import com.mopub.common.util.ManifestUtils;
import com.mopub.mobileads.MoPubConversionTracker;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.network.MoPubNetworkError;
import com.mopub.network.MultiAdResponse;
import com.mopub.network.Networking;
import com.mopub.volley.VolleyError;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class PersonalInfoManager {
    private static final long MINIMUM_SYNC_DELAY = 300000L;
    @NonNull
    private final Context mAppContext;
    @NonNull
    private final Set<ConsentStatusChangeListener> mConsentStatusChangeListeners;
    @NonNull
    private final PersonalInfoData mPersonalInfoData;
    @NonNull
    private final ConsentDialogController mConsentDialogController;
    @NonNull
    private final MoPubConversionTracker mConversionTracker;
    @NonNull
    private final SyncRequest.Listener mSyncRequestListener;
    @NonNull
    private MultiAdResponse.ServerOverrideListener mServerOverrideListener;
    @Nullable
    private SdkInitializationListener mSdkInitializationListener;
    private long mSyncDelayMs = 300000L;
    @Nullable
    private Long mLastSyncRequestTimeUptimeMs;
    @Nullable
    private ConsentStatus mSyncRequestConsentStatus;
    private long mSyncRequestEpochTime;
    private boolean mSyncRequestInFlight;
    private boolean mForceGdprAppliesChanged;
    private boolean mForceGdprAppliesChangedSending;

    public PersonalInfoManager(@NonNull Context context, @NonNull String adUnitId, @Nullable SdkInitializationListener sdkInitializationListener) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(adUnitId);
        this.mAppContext = context.getApplicationContext();
        this.mConsentStatusChangeListeners = Collections.synchronizedSet(new HashSet());
        this.mSyncRequestListener = new PersonalInfoSyncRequestListener();
        this.mServerOverrideListener = new PersonalInfoServerOverrideListener();
        MultiAdResponse.setServerOverrideListener(this.mServerOverrideListener);
        this.mConsentDialogController = new ConsentDialogController(this.mAppContext);
        this.mPersonalInfoData = new PersonalInfoData(this.mAppContext, adUnitId);
        this.mConversionTracker = new MoPubConversionTracker(this.mAppContext);
        MoPubIdentifier.AdvertisingIdChangeListener advertisingIdChangeListener = new MoPubIdentifier.AdvertisingIdChangeListener(){

            @Override
            public void onIdChanged(@NonNull AdvertisingId oldId, @NonNull AdvertisingId newId) {
                Preconditions.checkNotNull(oldId);
                Preconditions.checkNotNull(newId);
                if (oldId.isDoNotTrack() && newId.isDoNotTrack()) {
                    return;
                }
                if (!oldId.isDoNotTrack() && newId.isDoNotTrack()) {
                    PersonalInfoManager.this.attemptStateTransition(ConsentStatus.DNT, ConsentChangeReason.DENIED_BY_DNT_ON);
                    PersonalInfoManager.this.requestSync(true);
                    return;
                }
                if (oldId.isDoNotTrack() && !newId.isDoNotTrack()) {
                    if (ConsentStatus.EXPLICIT_NO.equals((Object)PersonalInfoManager.this.mPersonalInfoData.getConsentStatusBeforeDnt())) {
                        PersonalInfoManager.this.attemptStateTransition(ConsentStatus.EXPLICIT_NO, ConsentChangeReason.DNT_OFF);
                        return;
                    }
                    PersonalInfoManager.this.attemptStateTransition(ConsentStatus.UNKNOWN, ConsentChangeReason.DNT_OFF);
                    return;
                }
                if (!TextUtils.isEmpty((CharSequence)newId.mAdvertisingId) && !newId.getIfaWithPrefix().equals(PersonalInfoManager.this.mPersonalInfoData.getUdid()) && ConsentStatus.EXPLICIT_YES.equals((Object)PersonalInfoManager.this.mPersonalInfoData.getConsentStatus())) {
                    PersonalInfoManager.this.mPersonalInfoData.setLastSuccessfullySyncedConsentStatus(null);
                    PersonalInfoManager.this.mPersonalInfoData.setLastChangedMs(null);
                    PersonalInfoManager.this.attemptStateTransition(ConsentStatus.UNKNOWN, ConsentChangeReason.IFA_CHANGED);
                }
            }
        };
        this.mSdkInitializationListener = sdkInitializationListener;
        MoPubIdentifier moPubIdentifier = ClientMetadata.getInstance(this.mAppContext).getMoPubIdentifier();
        moPubIdentifier.setIdChangeListener(advertisingIdChangeListener);
        moPubIdentifier.setInitializationListener(this.createInitializationListener());
    }

    public boolean shouldShowConsentDialog() {
        if (this.gdprApplies() == null || !this.gdprApplies().booleanValue()) {
            return false;
        }
        if (ClientMetadata.getInstance(this.mAppContext).getMoPubIdentifier().getAdvertisingInfo().isDoNotTrack()) {
            return false;
        }
        if (this.mPersonalInfoData.shouldReacquireConsent() && this.mPersonalInfoData.getConsentStatus().equals((Object)ConsentStatus.EXPLICIT_YES)) {
            return true;
        }
        return this.mPersonalInfoData.getConsentStatus().equals((Object)ConsentStatus.UNKNOWN);
    }

    public boolean isConsentDialogReady() {
        return this.mConsentDialogController.isReady();
    }

    public void loadConsentDialog(final @Nullable ConsentDialogListener consentDialogListener) {
        ManifestUtils.checkGdprActivitiesDeclared(this.mAppContext);
        if (ClientMetadata.getInstance(this.mAppContext).getMoPubIdentifier().getAdvertisingInfo().isDoNotTrack()) {
            if (consentDialogListener != null) {
                new Handler().post(new Runnable(){

                    @Override
                    public void run() {
                        consentDialogListener.onConsentDialogLoadFailed(MoPubErrorCode.DO_NOT_TRACK);
                    }
                });
            }
            return;
        }
        Boolean gdprApplies = this.gdprApplies();
        if (gdprApplies != null && !gdprApplies.booleanValue()) {
            if (consentDialogListener != null) {
                new Handler().post(new Runnable(){

                    @Override
                    public void run() {
                        consentDialogListener.onConsentDialogLoadFailed(MoPubErrorCode.GDPR_DOES_NOT_APPLY);
                    }
                });
            }
            return;
        }
        this.mConsentDialogController.loadConsentDialog(consentDialogListener, gdprApplies, this.mPersonalInfoData);
    }

    public boolean showConsentDialog() {
        return this.mConsentDialogController.showConsentDialog();
    }

    public boolean canCollectPersonalInformation() {
        Boolean gdprApplies = this.gdprApplies();
        if (gdprApplies == null) {
            return false;
        }
        if (!gdprApplies.booleanValue()) {
            return true;
        }
        return this.getPersonalInfoConsentStatus().equals((Object)ConsentStatus.EXPLICIT_YES) && !ClientMetadata.getInstance(this.mAppContext).getMoPubIdentifier().getAdvertisingInfo().isDoNotTrack();
    }

    public Boolean gdprApplies() {
        if (this.mPersonalInfoData.isForceGdprApplies()) {
            return true;
        }
        return this.mPersonalInfoData.getGdprApplies();
    }

    public void forceGdprApplies() {
        if (this.mPersonalInfoData.isForceGdprApplies()) {
            return;
        }
        boolean oldCanCollectPersonalInformation = this.canCollectPersonalInformation();
        this.mPersonalInfoData.setForceGdprApplies(true);
        this.mForceGdprAppliesChanged = true;
        this.mPersonalInfoData.writeToDisk();
        boolean newCanCollectPersonalInformation = this.canCollectPersonalInformation();
        if (oldCanCollectPersonalInformation != newCanCollectPersonalInformation) {
            this.fireOnConsentStateChangeListeners(this.mPersonalInfoData.getConsentStatus(), this.mPersonalInfoData.getConsentStatus(), newCanCollectPersonalInformation);
        }
        this.requestSync(true);
    }

    @NonNull
    public ConsentStatus getPersonalInfoConsentStatus() {
        return this.mPersonalInfoData.getConsentStatus();
    }

    public void grantConsent() {
        if (ClientMetadata.getInstance(this.mAppContext).getMoPubIdentifier().getAdvertisingInfo().isDoNotTrack()) {
            MoPubLog.e("Cannot grant consent because Do Not Track is on.");
            return;
        }
        if (this.mPersonalInfoData.isWhitelisted()) {
            this.attemptStateTransition(ConsentStatus.EXPLICIT_YES, ConsentChangeReason.GRANTED_BY_WHITELISTED_PUB);
        } else {
            MoPubLog.w("You do not have approval to use the grantConsent API. Please reach out to your account teams or support@mopub.com for more information.");
            this.attemptStateTransition(ConsentStatus.POTENTIAL_WHITELIST, ConsentChangeReason.GRANTED_BY_NOT_WHITELISTED_PUB);
        }
        this.requestSync(true);
    }

    public void revokeConsent() {
        if (ClientMetadata.getInstance(this.mAppContext).getMoPubIdentifier().getAdvertisingInfo().isDoNotTrack()) {
            MoPubLog.e("Cannot revoke consent because Do Not Track is on.");
            return;
        }
        this.attemptStateTransition(ConsentStatus.EXPLICIT_NO, ConsentChangeReason.DENIED_BY_PUB);
        this.requestSync(true);
    }

    void changeConsentStateFromDialog(@NonNull ConsentStatus consentStatus) {
        Preconditions.checkNotNull((Object)consentStatus);
        switch (consentStatus) {
            case EXPLICIT_YES: {
                this.attemptStateTransition(consentStatus, ConsentChangeReason.GRANTED_BY_USER);
                this.requestSync(true);
                break;
            }
            case EXPLICIT_NO: {
                this.attemptStateTransition(consentStatus, ConsentChangeReason.DENIED_BY_USER);
                this.requestSync(true);
                break;
            }
            default: {
                MoPubLog.d("Invalid consent status: " + (Object)((Object)consentStatus) + ". This is a bug with the use of changeConsentStateFromDialog.");
            }
        }
    }

    public void subscribeConsentStatusChangeListener(@Nullable ConsentStatusChangeListener consentStatusChangeListener) {
        if (consentStatusChangeListener == null) {
            return;
        }
        this.mConsentStatusChangeListeners.add(consentStatusChangeListener);
    }

    public void unsubscribeConsentStatusChangeListener(@Nullable ConsentStatusChangeListener consentStatusChangeListener) {
        this.mConsentStatusChangeListeners.remove(consentStatusChangeListener);
    }

    @VisibleForTesting
    static boolean shouldMakeSyncRequest(boolean syncRequestInFlight, @Nullable Boolean gdprApplies, boolean force, @Nullable Long lastSyncRequestTimeMs, long syncDelay, @Nullable String udid, boolean dnt) {
        if (syncRequestInFlight) {
            return false;
        }
        if (gdprApplies == null) {
            return true;
        }
        if (!gdprApplies.booleanValue()) {
            return false;
        }
        if (force) {
            return true;
        }
        if (dnt && TextUtils.isEmpty((CharSequence)udid)) {
            return false;
        }
        if (lastSyncRequestTimeMs == null) {
            return true;
        }
        return SystemClock.uptimeMillis() - lastSyncRequestTimeMs > syncDelay;
    }

    public void requestSync(boolean force) {
        if (!MoPub.isSdkInitialized()) {
            return;
        }
        AdvertisingId advertisingId = ClientMetadata.getInstance(this.mAppContext).getMoPubIdentifier().getAdvertisingInfo();
        if (!PersonalInfoManager.shouldMakeSyncRequest(this.mSyncRequestInFlight, this.gdprApplies(), force, this.mLastSyncRequestTimeUptimeMs, this.mSyncDelayMs, this.mPersonalInfoData.getUdid(), advertisingId.isDoNotTrack())) {
            return;
        }
        this.requestSync();
    }

    @VisibleForTesting
    void requestSync() {
        this.mSyncRequestConsentStatus = this.mPersonalInfoData.getConsentStatus();
        this.mSyncRequestEpochTime = Calendar.getInstance().getTimeInMillis();
        this.mSyncRequestInFlight = true;
        this.mLastSyncRequestTimeUptimeMs = SystemClock.uptimeMillis();
        SyncUrlGenerator syncUrlGenerator = new SyncUrlGenerator(this.mAppContext, this.mSyncRequestConsentStatus.getValue());
        syncUrlGenerator.withAdUnitId(this.mPersonalInfoData.getAdUnitId()).withUdid(this.mPersonalInfoData.getUdid()).withLastChangedMs(this.mPersonalInfoData.getLastChangedMs()).withLastConsentStatus(this.mPersonalInfoData.getLastSuccessfullySyncedConsentStatus()).withConsentChangeReason(this.mPersonalInfoData.getConsentChangeReason()).withConsentedVendorListVersion(this.mPersonalInfoData.getConsentedVendorListVersion()).withConsentedPrivacyPolicyVersion(this.mPersonalInfoData.getConsentedPrivacyPolicyVersion()).withCachedVendorListIabHash(this.mPersonalInfoData.getCurrentVendorListIabHash()).withExtras(this.mPersonalInfoData.getExtras()).withGdprApplies(this.gdprApplies()).withForceGdprApplies(this.mPersonalInfoData.isForceGdprApplies());
        if (this.mForceGdprAppliesChanged) {
            this.mForceGdprAppliesChangedSending = true;
            syncUrlGenerator.withForceGdprAppliesChanged(true);
        }
        SyncRequest syncRequest = new SyncRequest(this.mAppContext, syncUrlGenerator.generateUrlString("ads.mopub.com"), this.mSyncRequestListener);
        Networking.getRequestQueue(this.mAppContext).add(syncRequest);
    }

    public ConsentData getConsentData() {
        return new PersonalInfoData(this.mAppContext, this.mPersonalInfoData.getAdUnitId());
    }

    private void attemptStateTransition(@NonNull ConsentStatus newConsentStatus, @NonNull ConsentChangeReason consentChangeReason) {
        this.attemptStateTransition(newConsentStatus, consentChangeReason.getReason());
    }

    @VisibleForTesting
    void attemptStateTransition(@NonNull ConsentStatus newConsentStatus, @NonNull String consentChangeReason) {
        Preconditions.checkNotNull((Object)newConsentStatus);
        Preconditions.checkNotNull(consentChangeReason);
        ConsentStatus oldConsentStatus = this.mPersonalInfoData.getConsentStatus();
        if (oldConsentStatus.equals((Object)newConsentStatus)) {
            MoPubLog.d("Consent status is already " + (Object)((Object)oldConsentStatus) + ". Not doing a state transition.");
            return;
        }
        MoPubLog.d("Changing consent status from " + (Object)((Object)oldConsentStatus) + "to " + (Object)((Object)newConsentStatus) + " because " + consentChangeReason);
        this.mPersonalInfoData.setConsentChangeReason(consentChangeReason);
        this.mPersonalInfoData.setConsentStatus(newConsentStatus);
        if (ConsentStatus.POTENTIAL_WHITELIST.equals((Object)newConsentStatus) || !ConsentStatus.POTENTIAL_WHITELIST.equals((Object)oldConsentStatus) && ConsentStatus.EXPLICIT_YES.equals((Object)newConsentStatus)) {
            this.mPersonalInfoData.setConsentedPrivacyPolicyVersion(this.mPersonalInfoData.getCurrentPrivacyPolicyVersion());
            this.mPersonalInfoData.setConsentedVendorListVersion(this.mPersonalInfoData.getCurrentVendorListVersion());
            this.mPersonalInfoData.setConsentedVendorListIabFormat(this.mPersonalInfoData.getCurrentVendorListIabFormat());
        }
        if (ConsentStatus.DNT.equals((Object)newConsentStatus) || ConsentStatus.EXPLICIT_NO.equals((Object)newConsentStatus) || ConsentStatus.UNKNOWN.equals((Object)newConsentStatus)) {
            this.mPersonalInfoData.setConsentedPrivacyPolicyVersion(null);
            this.mPersonalInfoData.setConsentedVendorListVersion(null);
            this.mPersonalInfoData.setConsentedVendorListIabFormat(null);
        }
        if (ConsentStatus.EXPLICIT_YES.equals((Object)newConsentStatus)) {
            this.mPersonalInfoData.setUdid(ClientMetadata.getInstance(this.mAppContext).getMoPubIdentifier().getAdvertisingInfo().getIfaWithPrefix());
        }
        if (ConsentStatus.DNT.equals((Object)newConsentStatus)) {
            this.mPersonalInfoData.setConsentStatusBeforeDnt(oldConsentStatus);
        }
        this.mPersonalInfoData.setShouldReacquireConsent(false);
        this.mPersonalInfoData.writeToDisk();
        boolean canCollectPersonalInformation = this.canCollectPersonalInformation();
        if (canCollectPersonalInformation) {
            ClientMetadata.getInstance(this.mAppContext).repopulateCountryData();
            if (this.mConversionTracker.shouldTrack()) {
                this.mConversionTracker.reportAppOpen(false);
            }
        }
        this.fireOnConsentStateChangeListeners(oldConsentStatus, newConsentStatus, canCollectPersonalInformation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireOnConsentStateChangeListeners(final @NonNull ConsentStatus oldConsentStatus, final @NonNull ConsentStatus newConsentStatus, final boolean canCollectPersonalInformation) {
        Set<ConsentStatusChangeListener> set = this.mConsentStatusChangeListeners;
        synchronized (set) {
            for (final ConsentStatusChangeListener stateChangeListener : this.mConsentStatusChangeListeners) {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        stateChangeListener.onConsentStateChange(oldConsentStatus, newConsentStatus, canCollectPersonalInformation);
                    }
                });
            }
        }
    }

    private SdkInitializationListener createInitializationListener() {
        return new SdkInitializationListener(){

            @Override
            public void onInitializationFinished() {
                MoPubLog.d("MoPubIdentifier initialized.");
                AdvertisingId advertisingId = ClientMetadata.getInstance(PersonalInfoManager.this.mAppContext).getMoPubIdentifier().getAdvertisingInfo();
                if (!PersonalInfoManager.shouldMakeSyncRequest(PersonalInfoManager.this.mSyncRequestInFlight, PersonalInfoManager.this.gdprApplies(), false, PersonalInfoManager.this.mLastSyncRequestTimeUptimeMs, PersonalInfoManager.this.mSyncDelayMs, PersonalInfoManager.this.mPersonalInfoData.getUdid(), advertisingId.isDoNotTrack())) {
                    if (PersonalInfoManager.this.mSdkInitializationListener != null) {
                        PersonalInfoManager.this.mSdkInitializationListener.onInitializationFinished();
                        PersonalInfoManager.this.mSdkInitializationListener = null;
                    }
                } else {
                    PersonalInfoManager.this.requestSync();
                }
                new MoPubConversionTracker(PersonalInfoManager.this.mAppContext).reportAppOpen(true);
            }
        };
    }

    @Deprecated
    @NonNull
    @VisibleForTesting
    PersonalInfoData getPersonalInfoData() {
        return this.mPersonalInfoData;
    }

    @Deprecated
    @NonNull
    @VisibleForTesting
    MultiAdResponse.ServerOverrideListener getServerOverrideListener() {
        return this.mServerOverrideListener;
    }

    private class PersonalInfoServerOverrideListener
    implements MultiAdResponse.ServerOverrideListener {
        private PersonalInfoServerOverrideListener() {
        }

        @Override
        public void onForceExplicitNo(@Nullable String consentChangeReason) {
            if (TextUtils.isEmpty((CharSequence)consentChangeReason)) {
                PersonalInfoManager.this.attemptStateTransition(ConsentStatus.EXPLICIT_NO, ConsentChangeReason.REVOKED_BY_SERVER);
                return;
            }
            PersonalInfoManager.this.attemptStateTransition(ConsentStatus.EXPLICIT_NO, consentChangeReason);
        }

        @Override
        public void onInvalidateConsent(@Nullable String consentChangeReason) {
            if (TextUtils.isEmpty((CharSequence)consentChangeReason)) {
                PersonalInfoManager.this.attemptStateTransition(ConsentStatus.UNKNOWN, ConsentChangeReason.REACQUIRE_BY_SERVER);
                return;
            }
            PersonalInfoManager.this.attemptStateTransition(ConsentStatus.UNKNOWN, consentChangeReason);
        }

        @Override
        public void onReacquireConsent(@Nullable String consentChangeReason) {
            if (!TextUtils.isEmpty((CharSequence)consentChangeReason)) {
                PersonalInfoManager.this.mPersonalInfoData.setConsentChangeReason(consentChangeReason);
            }
            PersonalInfoManager.this.mPersonalInfoData.setShouldReacquireConsent(true);
            PersonalInfoManager.this.mPersonalInfoData.writeToDisk();
        }

        @Override
        public void onForceGdprApplies() {
            PersonalInfoManager.this.forceGdprApplies();
        }
    }

    private class PersonalInfoSyncRequestListener
    implements SyncRequest.Listener {
        private PersonalInfoSyncRequestListener() {
        }

        @Override
        public void onSuccess(SyncResponse response) {
            String extras;
            boolean oldCanCollectPersonalInformation = PersonalInfoManager.this.canCollectPersonalInformation();
            if (PersonalInfoManager.this.mPersonalInfoData.getGdprApplies() == null) {
                PersonalInfoManager.this.mPersonalInfoData.setGdprApplies(response.isGdprRegion());
            }
            if (response.isForceGdprApplies()) {
                PersonalInfoManager.this.mForceGdprAppliesChanged = true;
                PersonalInfoManager.this.mPersonalInfoData.setForceGdprApplies(true);
                boolean newCanCollectPersonalInformation = PersonalInfoManager.this.canCollectPersonalInformation();
                if (oldCanCollectPersonalInformation != newCanCollectPersonalInformation) {
                    PersonalInfoManager.this.fireOnConsentStateChangeListeners(PersonalInfoManager.this.mPersonalInfoData.getConsentStatus(), PersonalInfoManager.this.mPersonalInfoData.getConsentStatus(), newCanCollectPersonalInformation);
                }
            }
            PersonalInfoManager.this.mPersonalInfoData.setLastChangedMs("" + PersonalInfoManager.this.mSyncRequestEpochTime);
            PersonalInfoManager.this.mPersonalInfoData.setLastSuccessfullySyncedConsentStatus(PersonalInfoManager.this.mSyncRequestConsentStatus);
            PersonalInfoManager.this.mPersonalInfoData.setWhitelisted(response.isWhitelisted());
            PersonalInfoManager.this.mPersonalInfoData.setCurrentVendorListVersion(response.getCurrentVendorListVersion());
            PersonalInfoManager.this.mPersonalInfoData.setCurrentVendorListLink(response.getCurrentVendorListLink());
            PersonalInfoManager.this.mPersonalInfoData.setCurrentPrivacyPolicyVersion(response.getCurrentPrivacyPolicyVersion());
            PersonalInfoManager.this.mPersonalInfoData.setCurrentPrivacyPolicyLink(response.getCurrentPrivacyPolicyLink());
            String iabHash = response.getCurrentVendorListIabHash();
            String iabFormat = response.getCurrentVendorListIabFormat();
            if (!(TextUtils.isEmpty((CharSequence)iabHash) || iabHash.equals(PersonalInfoManager.this.mPersonalInfoData.getCurrentVendorListIabHash()) || TextUtils.isEmpty((CharSequence)iabFormat))) {
                PersonalInfoManager.this.mPersonalInfoData.setCurrentVendorListIabFormat(iabFormat);
                PersonalInfoManager.this.mPersonalInfoData.setCurrentVendorListIabHash(iabHash);
            }
            if (!TextUtils.isEmpty((CharSequence)(extras = response.getExtras()))) {
                PersonalInfoManager.this.mPersonalInfoData.setExtras(extras);
            }
            String consentChangeReason = response.getConsentChangeReason();
            if (response.isForceExplicitNo()) {
                PersonalInfoManager.this.mServerOverrideListener.onForceExplicitNo(consentChangeReason);
            } else if (response.isInvalidateConsent()) {
                PersonalInfoManager.this.mServerOverrideListener.onInvalidateConsent(consentChangeReason);
            } else if (response.isReacquireConsent()) {
                PersonalInfoManager.this.mServerOverrideListener.onReacquireConsent(consentChangeReason);
            }
            String callAgainAfterSecs = response.getCallAgainAfterSecs();
            if (!TextUtils.isEmpty((CharSequence)callAgainAfterSecs)) {
                try {
                    long callAgainAfterSecsLong = Long.parseLong(callAgainAfterSecs);
                    if (callAgainAfterSecsLong > 0L) {
                        PersonalInfoManager.this.mSyncDelayMs = callAgainAfterSecsLong * 1000L;
                    } else {
                        MoPubLog.d("callAgainAfterSecs is not positive: " + callAgainAfterSecs);
                    }
                }
                catch (NumberFormatException e) {
                    MoPubLog.d("Unable to parse callAgainAfterSecs. Ignoring value");
                }
            }
            if (!ConsentStatus.EXPLICIT_YES.equals((Object)PersonalInfoManager.this.mSyncRequestConsentStatus)) {
                PersonalInfoManager.this.mPersonalInfoData.setUdid(null);
            }
            if (PersonalInfoManager.this.mForceGdprAppliesChangedSending) {
                PersonalInfoManager.this.mForceGdprAppliesChanged = false;
                PersonalInfoManager.this.mForceGdprAppliesChangedSending = false;
            }
            PersonalInfoManager.this.mPersonalInfoData.writeToDisk();
            PersonalInfoManager.this.mSyncRequestInFlight = false;
            if (ConsentStatus.POTENTIAL_WHITELIST.equals((Object)PersonalInfoManager.this.mSyncRequestConsentStatus) && PersonalInfoManager.this.mPersonalInfoData.isWhitelisted()) {
                PersonalInfoManager.this.attemptStateTransition(ConsentStatus.EXPLICIT_YES, ConsentChangeReason.GRANTED_BY_WHITELISTED_PUB);
                PersonalInfoManager.this.requestSync(true);
            }
            if (PersonalInfoManager.this.mSdkInitializationListener != null) {
                PersonalInfoManager.this.mSdkInitializationListener.onInitializationFinished();
                PersonalInfoManager.this.mSdkInitializationListener = null;
            }
        }

        public void onErrorResponse(VolleyError volleyError) {
            MoPubLog.d("Failed sync request because of " + (volleyError instanceof MoPubNetworkError ? ((MoPubNetworkError)volleyError).getReason() : volleyError.getMessage()));
            PersonalInfoManager.this.mSyncRequestInFlight = false;
            if (PersonalInfoManager.this.mSdkInitializationListener != null) {
                MoPubLog.d("Personal Info Manager initialization finished but ran into errors.");
                PersonalInfoManager.this.mSdkInitializationListener.onInitializationFinished();
                PersonalInfoManager.this.mSdkInitializationListener = null;
            }
        }
    }
}

