/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.privacy;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mopub.common.GpsHelper;
import com.mopub.common.Preconditions;
import com.mopub.common.SdkInitializationListener;
import com.mopub.common.SharedPreferencesHelper;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.privacy.AdvertisingId;
import com.mopub.common.util.AsyncTasks;
import java.util.Calendar;

public class MoPubIdentifier {
    private static final String PREF_AD_INFO_GROUP = "com.mopub.settings.identifier";
    private static final String PREF_IFA_IDENTIFIER = "privacy.identifier.ifa";
    private static final String PREF_MOPUB_IDENTIFIER = "privacy.identifier.mopub";
    private static final String PREF_IDENTIFIER_TIME = "privacy.identifier.time";
    private static final String PREF_LIMIT_AD_TRACKING = "privacy.limit.ad.tracking";
    private static final int MISSING_VALUE = -1;
    @NonNull
    private AdvertisingId mAdInfo;
    @NonNull
    private final Context mAppContext;
    @Nullable
    private AdvertisingIdChangeListener mIdChangeListener;
    private boolean mRefreshingAdvertisingInfo;
    private boolean initialized;
    @Nullable
    private SdkInitializationListener mInitializationListener;

    public MoPubIdentifier(@NonNull Context appContext) {
        this(appContext, null);
    }

    @VisibleForTesting
    MoPubIdentifier(@NonNull Context appContext, @Nullable AdvertisingIdChangeListener idChangeListener) {
        Preconditions.checkNotNull(appContext);
        this.mAppContext = appContext;
        this.mIdChangeListener = idChangeListener;
        this.mAdInfo = MoPubIdentifier.readIdFromStorage(this.mAppContext);
        if (this.mAdInfo == null) {
            this.mAdInfo = AdvertisingId.generateExpiredAdvertisingId();
        }
        this.refreshAdvertisingInfo();
    }

    @NonNull
    public AdvertisingId getAdvertisingInfo() {
        AdvertisingId adInfo = this.mAdInfo;
        this.refreshAdvertisingInfo();
        return adInfo;
    }

    private void refreshAdvertisingInfo() {
        if (this.mRefreshingAdvertisingInfo) {
            return;
        }
        this.mRefreshingAdvertisingInfo = true;
        AsyncTasks.safeExecuteOnExecutor(new RefreshAdvertisingInfoAsyncTask(), new Void[0]);
    }

    void refreshAdvertisingInfoBackgroundThread() {
        Object info;
        long time = Calendar.getInstance().getTimeInMillis();
        if (this.isPlayServicesAvailable()) {
            info = GpsHelper.fetchAdvertisingInfoSync(this.mAppContext);
            if (info != null && !TextUtils.isEmpty((CharSequence)((GpsHelper.AdvertisingInfo)info).advertisingId)) {
                AdvertisingId oldId = this.mAdInfo;
                if (oldId.isRotationRequired()) {
                    this.setAdvertisingInfo(((GpsHelper.AdvertisingInfo)info).advertisingId, AdvertisingId.generateIdString(), ((GpsHelper.AdvertisingInfo)info).limitAdTracking, time);
                } else {
                    this.setAdvertisingInfo(((GpsHelper.AdvertisingInfo)info).advertisingId, oldId.mMopubId, ((GpsHelper.AdvertisingInfo)info).limitAdTracking, oldId.mLastRotation.getTimeInMillis());
                }
                return;
            }
            MoPubLog.w("Call to 'getAdvertisingIdInfo' returned invalid value.");
        }
        if ((info = this.getAmazonAdvertisingInfo(this.mAppContext)) != null && !TextUtils.isEmpty((CharSequence)((AdvertisingId)info).mAdvertisingId)) {
            AdvertisingId oldId = this.mAdInfo;
            if (oldId.isRotationRequired()) {
                this.setAdvertisingInfo(((AdvertisingId)info).mAdvertisingId, AdvertisingId.generateIdString(), ((AdvertisingId)info).mDoNotTrack, time);
            } else {
                this.setAdvertisingInfo(((AdvertisingId)info).mAdvertisingId, oldId.mMopubId, ((AdvertisingId)info).mDoNotTrack, oldId.mLastRotation.getTimeInMillis());
            }
            return;
        }
        this.rotateMopubId();
    }

    @Nullable
    static synchronized AdvertisingId readIdFromStorage(@NonNull Context appContext) {
        Preconditions.checkNotNull(appContext);
        Calendar now = Calendar.getInstance();
        try {
            SharedPreferences preferences = SharedPreferencesHelper.getSharedPreferences(appContext, PREF_AD_INFO_GROUP);
            String ifa_id = preferences.getString(PREF_IFA_IDENTIFIER, "");
            String mopub_id = preferences.getString(PREF_MOPUB_IDENTIFIER, "");
            long time = preferences.getLong(PREF_IDENTIFIER_TIME, now.getTimeInMillis());
            boolean limitTracking = preferences.getBoolean(PREF_LIMIT_AD_TRACKING, false);
            if (!TextUtils.isEmpty((CharSequence)ifa_id) && !TextUtils.isEmpty((CharSequence)mopub_id)) {
                return new AdvertisingId(ifa_id, mopub_id, limitTracking, time);
            }
        }
        catch (ClassCastException ex) {
            MoPubLog.e("Cannot read identifier from shared preferences");
        }
        return null;
    }

    private static synchronized void writeIdToStorage(@NonNull Context context, @NonNull AdvertisingId info) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(info);
        SharedPreferences preferences = SharedPreferencesHelper.getSharedPreferences(context, PREF_AD_INFO_GROUP);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean(PREF_LIMIT_AD_TRACKING, info.mDoNotTrack);
        editor.putString(PREF_IFA_IDENTIFIER, info.mAdvertisingId);
        editor.putString(PREF_MOPUB_IDENTIFIER, info.mMopubId);
        editor.putLong(PREF_IDENTIFIER_TIME, info.mLastRotation.getTimeInMillis());
        editor.apply();
    }

    @VisibleForTesting
    static synchronized void clearStorage(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        SharedPreferences preferences = SharedPreferencesHelper.getSharedPreferences(context, PREF_AD_INFO_GROUP);
        SharedPreferences.Editor editor = preferences.edit();
        editor.remove(PREF_LIMIT_AD_TRACKING);
        editor.remove(PREF_IFA_IDENTIFIER);
        editor.remove(PREF_MOPUB_IDENTIFIER);
        editor.remove(PREF_IDENTIFIER_TIME);
        editor.apply();
    }

    void rotateMopubId() {
        if (!this.mAdInfo.isRotationRequired()) {
            this.setAdvertisingInfo(this.mAdInfo);
            return;
        }
        this.setAdvertisingInfo(AdvertisingId.generateFreshAdvertisingId());
    }

    private void setAdvertisingInfo(@NonNull String advertisingId, @NonNull String mopubId, boolean limitAdTracking, long rotationTime) {
        Preconditions.checkNotNull(advertisingId);
        Preconditions.checkNotNull(mopubId);
        this.setAdvertisingInfo(new AdvertisingId(advertisingId, mopubId, limitAdTracking, rotationTime));
    }

    void setAdvertisingInfo(@NonNull AdvertisingId newId) {
        AdvertisingId oldId = this.mAdInfo;
        this.mAdInfo = newId;
        MoPubIdentifier.writeIdToStorage(this.mAppContext, this.mAdInfo);
        if (!this.mAdInfo.equals(oldId) || !this.initialized) {
            this.notifyIdChangeListener(oldId, this.mAdInfo);
        }
        this.initialized = true;
        this.reportInitializationComplete();
    }

    public void setIdChangeListener(@Nullable AdvertisingIdChangeListener idChangeListener) {
        this.mIdChangeListener = idChangeListener;
    }

    void setInitializationListener(@Nullable SdkInitializationListener initializationListener) {
        this.mInitializationListener = initializationListener;
        if (this.initialized) {
            this.reportInitializationComplete();
        }
    }

    private void reportInitializationComplete() {
        if (this.mInitializationListener != null) {
            this.mInitializationListener.onInitializationFinished();
            this.mInitializationListener = null;
        }
    }

    private void notifyIdChangeListener(@NonNull AdvertisingId oldId, @NonNull AdvertisingId newId) {
        Preconditions.checkNotNull(newId);
        if (this.mIdChangeListener != null) {
            this.mIdChangeListener.onIdChanged(oldId, newId);
        }
    }

    boolean isPlayServicesAvailable() {
        return GpsHelper.isPlayServicesAvailable(this.mAppContext);
    }

    @Nullable
    private AdvertisingId getAmazonAdvertisingInfo(@NonNull Context context) {
        Preconditions.NoThrow.checkNotNull(context);
        ContentResolver resolver = context.getContentResolver();
        int limitAdTracking = Settings.Secure.getInt((ContentResolver)resolver, (String)"limit_ad_tracking", (int)-1);
        String advertisingId = Settings.Secure.getString((ContentResolver)resolver, (String)"advertising_id");
        if (limitAdTracking != -1 && !TextUtils.isEmpty((CharSequence)advertisingId)) {
            boolean doNotTrack = limitAdTracking != 0;
            AdvertisingId oldId = this.mAdInfo;
            return new AdvertisingId(advertisingId, oldId.mMopubId, doNotTrack, oldId.mLastRotation.getTimeInMillis());
        }
        return null;
    }

    private class RefreshAdvertisingInfoAsyncTask
    extends AsyncTask<Void, Void, Void> {
        private RefreshAdvertisingInfoAsyncTask() {
        }

        protected Void doInBackground(Void ... voids) {
            MoPubIdentifier.this.refreshAdvertisingInfoBackgroundThread();
            MoPubIdentifier.this.mRefreshingAdvertisingInfo = false;
            return null;
        }
    }

    public static interface AdvertisingIdChangeListener {
        public void onIdChanged(@NonNull AdvertisingId var1, @NonNull AdvertisingId var2);
    }
}

