/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.privacy;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.BaseUrlGenerator;
import com.mopub.common.ClientMetadata;
import com.mopub.common.Preconditions;

public class ConsentDialogUrlGenerator
extends BaseUrlGenerator {
    private static final String LANGUAGE_KEY = "language";
    @NonNull
    private final Context mContext;
    @NonNull
    private final String mAdUnitId;
    @NonNull
    private final String mCurrentConsentStatus;
    @Nullable
    private Boolean mGdprApplies;
    private boolean mForceGdprApplies;
    @Nullable
    private String mConsentedVendorListVersion;
    @Nullable
    private String mConsentedPrivacyPolicyVersion;

    ConsentDialogUrlGenerator(@NonNull Context context, @NonNull String adUnitId, @NonNull String currentConsentStatus) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(adUnitId);
        Preconditions.checkNotNull(currentConsentStatus);
        this.mContext = context.getApplicationContext();
        this.mAdUnitId = adUnitId;
        this.mCurrentConsentStatus = currentConsentStatus;
    }

    protected ConsentDialogUrlGenerator withGdprApplies(@Nullable Boolean gdprApplies) {
        this.mGdprApplies = gdprApplies;
        return this;
    }

    protected ConsentDialogUrlGenerator withForceGdprApplies(boolean forceGdprApplies) {
        this.mForceGdprApplies = forceGdprApplies;
        return this;
    }

    protected ConsentDialogUrlGenerator withConsentedVendorListVersion(@Nullable String consentedVendorListVersion) {
        this.mConsentedVendorListVersion = consentedVendorListVersion;
        return this;
    }

    protected ConsentDialogUrlGenerator withConsentedPrivacyPolicyVersion(@Nullable String consentedPrivacyPolicyVersion) {
        this.mConsentedPrivacyPolicyVersion = consentedPrivacyPolicyVersion;
        return this;
    }

    @Override
    public String generateUrlString(String serverHostname) {
        this.initUrlString(serverHostname, "/m/gdpr_consent_dialog");
        this.addParam("id", this.mAdUnitId);
        this.addParam("current_consent_status", this.mCurrentConsentStatus);
        this.addParam("nv", "5.4.0");
        this.addParam(LANGUAGE_KEY, ClientMetadata.getCurrentLanguage(this.mContext));
        this.addParam("gdpr_applies", this.mGdprApplies);
        this.addParam("force_gdpr_applies", this.mForceGdprApplies);
        this.addParam("consented_vendor_list_version", this.mConsentedVendorListVersion);
        this.addParam("consented_privacy_policy_version", this.mConsentedPrivacyPolicyVersion);
        this.addParam("bundle", ClientMetadata.getInstance(this.mContext).getAppPackageName());
        return this.getFinalUrlString();
    }
}

