/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.privacy;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mopub.common.privacy.ConsentDialogResponse;
import com.mopub.network.MoPubNetworkError;
import com.mopub.network.MoPubRequest;
import com.mopub.volley.Cache;
import com.mopub.volley.DefaultRetryPolicy;
import com.mopub.volley.NetworkResponse;
import com.mopub.volley.Response;
import com.mopub.volley.RetryPolicy;
import com.mopub.volley.VolleyError;
import com.mopub.volley.toolbox.HttpHeaderParser;
import org.json.JSONException;
import org.json.JSONObject;

class ConsentDialogRequest
extends MoPubRequest<ConsentDialogResponse> {
    private static final String HTML_KEY = "dialog_html";
    @Nullable
    private Listener mListener;

    ConsentDialogRequest(@NonNull Context context, @NonNull String url, @Nullable Listener listener) {
        super(context, url, listener);
        this.mListener = listener;
        DefaultRetryPolicy retryPolicy = new DefaultRetryPolicy(2500, 1, 1.0f);
        this.setRetryPolicy((RetryPolicy)retryPolicy);
        this.setShouldCache(false);
    }

    protected Response<ConsentDialogResponse> parseNetworkResponse(NetworkResponse networkResponse) {
        ConsentDialogResponse response;
        String responseBody = this.parseStringBody(networkResponse);
        try {
            JSONObject jsonBody = new JSONObject(responseBody);
            String html = jsonBody.getString(HTML_KEY);
            if (TextUtils.isEmpty((CharSequence)html)) {
                throw new JSONException("Empty HTML body");
            }
            response = new ConsentDialogResponse(html);
        }
        catch (JSONException e) {
            return Response.error((VolleyError)new MoPubNetworkError("Unable to parse consent dialog request network response.", MoPubNetworkError.Reason.BAD_BODY, null));
        }
        return Response.success((Object)response, (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)networkResponse));
    }

    protected void deliverResponse(ConsentDialogResponse consentDialogResponse) {
        if (this.mListener != null) {
            this.mListener.onSuccess(consentDialogResponse);
        }
    }

    public static interface Listener
    extends Response.ErrorListener {
        public void onSuccess(ConsentDialogResponse var1);
    }
}

