/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.privacy;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.privacy.ConsentDialogActivity;
import com.mopub.common.privacy.ConsentDialogListener;
import com.mopub.common.privacy.ConsentDialogRequest;
import com.mopub.common.privacy.ConsentDialogResponse;
import com.mopub.common.privacy.ConsentDialogUrlGenerator;
import com.mopub.common.privacy.PersonalInfoData;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.network.MoPubNetworkError;
import com.mopub.network.Networking;
import com.mopub.volley.VolleyError;

public class ConsentDialogController
implements ConsentDialogRequest.Listener {
    @NonNull
    private final Context mAppContext;
    @Nullable
    private String mHtmlBody;
    @Nullable
    private ConsentDialogListener mExtListener;
    volatile boolean mReady;
    volatile boolean mRequestInFlight;
    private final Handler mHandler;

    ConsentDialogController(@NonNull Context appContext) {
        Preconditions.checkNotNull(appContext);
        this.mAppContext = appContext.getApplicationContext();
        this.mHandler = new Handler();
    }

    @Override
    public void onSuccess(ConsentDialogResponse response) {
        this.mRequestInFlight = false;
        this.mHtmlBody = response.getHtml();
        if (TextUtils.isEmpty((CharSequence)this.mHtmlBody)) {
            this.mReady = false;
            if (this.mExtListener != null) {
                this.mExtListener.onConsentDialogLoadFailed(MoPubErrorCode.INTERNAL_ERROR);
            }
            return;
        }
        this.mReady = true;
        if (this.mExtListener != null) {
            this.mExtListener.onConsentDialogLoaded();
        }
    }

    public void onErrorResponse(VolleyError volleyError) {
        ConsentDialogListener loadListener = this.mExtListener;
        this.resetState();
        if (loadListener == null) {
            return;
        }
        if (volleyError instanceof MoPubNetworkError) {
            switch (((MoPubNetworkError)volleyError).getReason()) {
                case BAD_BODY: {
                    loadListener.onConsentDialogLoadFailed(MoPubErrorCode.INTERNAL_ERROR);
                    return;
                }
            }
        }
        loadListener.onConsentDialogLoadFailed(MoPubErrorCode.UNSPECIFIED);
    }

    synchronized void loadConsentDialog(final @Nullable ConsentDialogListener listener, @Nullable Boolean gdprApplies, @NonNull PersonalInfoData personalInfoData) {
        Preconditions.checkNotNull(personalInfoData);
        if (this.mReady) {
            if (listener != null) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        listener.onConsentDialogLoaded();
                    }
                });
            }
            return;
        }
        if (this.mRequestInFlight) {
            MoPubLog.d("Already making a consent dialog load request.");
            return;
        }
        this.mExtListener = listener;
        this.mRequestInFlight = true;
        ConsentDialogRequest consentDialogRequest = new ConsentDialogRequest(this.mAppContext, new ConsentDialogUrlGenerator(this.mAppContext, personalInfoData.getAdUnitId(), personalInfoData.getConsentStatus().getValue()).withGdprApplies(gdprApplies).withConsentedPrivacyPolicyVersion(personalInfoData.getConsentedPrivacyPolicyVersion()).withConsentedVendorListVersion(personalInfoData.getConsentedVendorListVersion()).withForceGdprApplies(personalInfoData.isForceGdprApplies()).generateUrlString("ads.mopub.com"), this);
        Networking.getRequestQueue(this.mAppContext).add(consentDialogRequest);
    }

    boolean showConsentDialog() {
        if (!this.mReady || TextUtils.isEmpty((CharSequence)this.mHtmlBody)) {
            return false;
        }
        ConsentDialogActivity.start(this.mAppContext, this.mHtmlBody);
        this.resetState();
        return true;
    }

    boolean isReady() {
        return this.mReady;
    }

    private void resetState() {
        this.mRequestInFlight = false;
        this.mReady = false;
        this.mExtListener = null;
        this.mHtmlBody = null;
    }
}

