/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.privacy;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.mopub.common.Preconditions;
import java.io.Serializable;
import java.util.Calendar;
import java.util.UUID;

public class AdvertisingId
implements Serializable {
    static final long ROTATION_TIME_MS = 86400000L;
    private static final String PREFIX_IFA = "ifa:";
    private static final String PREFIX_MOPUB = "mopub:";
    @NonNull
    final Calendar mLastRotation;
    @NonNull
    final String mAdvertisingId;
    @NonNull
    final String mMopubId;
    final boolean mDoNotTrack;

    AdvertisingId(@NonNull String ifaId, @NonNull String mopubId, boolean limitAdTrackingEnabled, long rotationTime) {
        Preconditions.checkNotNull(ifaId);
        Preconditions.checkNotNull(ifaId);
        this.mAdvertisingId = ifaId;
        this.mMopubId = mopubId;
        this.mDoNotTrack = limitAdTrackingEnabled;
        this.mLastRotation = Calendar.getInstance();
        this.mLastRotation.setTimeInMillis(rotationTime);
    }

    public String getIdentifier(boolean consent) {
        return this.mDoNotTrack || !consent ? this.mMopubId : this.mAdvertisingId;
    }

    @NonNull
    public String getIdWithPrefix(boolean consent) {
        if (this.mDoNotTrack || !consent || this.mAdvertisingId.isEmpty()) {
            return PREFIX_MOPUB + this.mMopubId;
        }
        return PREFIX_IFA + this.mAdvertisingId;
    }

    @NonNull
    String getIfaWithPrefix() {
        if (TextUtils.isEmpty((CharSequence)this.mAdvertisingId)) {
            return "";
        }
        return PREFIX_IFA + this.mAdvertisingId;
    }

    public boolean isDoNotTrack() {
        return this.mDoNotTrack;
    }

    @NonNull
    static AdvertisingId generateExpiredAdvertisingId() {
        Calendar time = Calendar.getInstance();
        String mopubId = AdvertisingId.generateIdString();
        return new AdvertisingId("", mopubId, false, time.getTimeInMillis() - 86400000L - 1L);
    }

    @NonNull
    static AdvertisingId generateFreshAdvertisingId() {
        Calendar time = Calendar.getInstance();
        String mopubId = AdvertisingId.generateIdString();
        return new AdvertisingId("", mopubId, false, time.getTimeInMillis());
    }

    @NonNull
    static String generateIdString() {
        return UUID.randomUUID().toString();
    }

    boolean isRotationRequired() {
        Calendar now = Calendar.getInstance();
        return now.getTimeInMillis() - this.mLastRotation.getTimeInMillis() >= 86400000L;
    }

    public String toString() {
        return "AdvertisingId{mLastRotation=" + this.mLastRotation + ", mAdvertisingId='" + this.mAdvertisingId + '\'' + ", mMopubId='" + this.mMopubId + '\'' + ", mDoNotTrack=" + this.mDoNotTrack + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdvertisingId)) {
            return false;
        }
        AdvertisingId that = (AdvertisingId)o;
        if (this.mDoNotTrack != that.mDoNotTrack) {
            return false;
        }
        if (!this.mAdvertisingId.equals(that.mAdvertisingId)) {
            return false;
        }
        return this.mMopubId.equals(that.mMopubId);
    }

    public int hashCode() {
        int result = this.mAdvertisingId.hashCode();
        result = 31 * result + this.mMopubId.hashCode();
        result = 31 * result + (this.mDoNotTrack ? 1 : 0);
        return result;
    }
}

