/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.MediationSettings;
import com.mopub.common.MoPubAdvancedBidder;
import com.mopub.common.Preconditions;
import com.mopub.common.util.MoPubCollections;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SdkConfiguration {
    @NonNull
    private final String mAdUnitId;
    @NonNull
    private final List<Class<? extends MoPubAdvancedBidder>> mAdvancedBidders;
    @NonNull
    private final MediationSettings[] mMediationSettings;
    @Nullable
    private final List<String> mNetworksToInit;

    private SdkConfiguration(@NonNull String adUnitId, @NonNull List<Class<? extends MoPubAdvancedBidder>> advancedBidders, @NonNull MediationSettings[] mediationSettings, @Nullable List<String> networksToInit) {
        Preconditions.checkNotNull(adUnitId);
        Preconditions.checkNotNull(advancedBidders);
        this.mAdUnitId = adUnitId;
        this.mAdvancedBidders = advancedBidders;
        this.mMediationSettings = mediationSettings;
        this.mNetworksToInit = networksToInit;
    }

    @NonNull
    public String getAdUnitId() {
        return this.mAdUnitId;
    }

    @NonNull
    public List<Class<? extends MoPubAdvancedBidder>> getAdvancedBidders() {
        return Collections.unmodifiableList(this.mAdvancedBidders);
    }

    @NonNull
    public MediationSettings[] getMediationSettings() {
        return Arrays.copyOf(this.mMediationSettings, this.mMediationSettings.length);
    }

    @Nullable
    public List<String> getNetworksToInit() {
        if (this.mNetworksToInit == null) {
            return null;
        }
        return Collections.unmodifiableList(this.mNetworksToInit);
    }

    public static class Builder {
        @NonNull
        private String adUnitId;
        @NonNull
        private final List<Class<? extends MoPubAdvancedBidder>> advancedBidders;
        @NonNull
        private MediationSettings[] mediationSettings;
        @Nullable
        private List<String> networksToInit;

        public Builder(@NonNull String adUnitId) {
            this.adUnitId = adUnitId;
            this.advancedBidders = new ArrayList<Class<? extends MoPubAdvancedBidder>>();
            this.mediationSettings = new MediationSettings[0];
        }

        public Builder withAdvancedBidder(@NonNull Class<? extends MoPubAdvancedBidder> advancedBidder) {
            Preconditions.checkNotNull(advancedBidder);
            this.advancedBidders.add(advancedBidder);
            return this;
        }

        public Builder withAdvancedBidders(@NonNull Collection<Class<? extends MoPubAdvancedBidder>> advancedBidders) {
            Preconditions.NoThrow.checkNotNull(advancedBidders);
            MoPubCollections.addAllNonNull(this.advancedBidders, advancedBidders);
            return this;
        }

        public Builder withMediationSettings(MediationSettings ... mediationSettings) {
            Preconditions.checkNotNull(mediationSettings);
            this.mediationSettings = mediationSettings;
            return this;
        }

        public Builder withNetworksToInit(@Nullable List<String> networksToInit) {
            if (networksToInit == null) {
                return this;
            }
            this.networksToInit = new ArrayList<String>();
            MoPubCollections.addAllNonNull(this.networksToInit, networksToInit);
            return this;
        }

        public SdkConfiguration build() {
            return new SdkConfiguration(this.adUnitId, this.advancedBidders, this.mediationSettings, this.networksToInit);
        }
    }
}

